/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.util.io.Filterable;
import com.liferay.faces.util.io.ResourceOutputStream;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;

public class ResourceOutputStreamRichFacesImpl
extends ResourceOutputStream
implements Filterable {
    private static final Logger logger = LoggerFactory.getLogger(ResourceOutputStreamRichFacesImpl.class);
    private static final String EXTENSION_CSS = ".css";
    private static final String ORG_RICHFACES_IMAGES = "org.richfaces.images";
    private static final String PACKED_JS = "packed.js";

    public ResourceOutputStreamRichFacesImpl(Resource resource, int size) {
        super(resource, size);
    }

    public void filter() throws IOException {
        String resourceName = this.getResource().getResourceName();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (resourceName.indexOf(EXTENSION_CSS) > 0) {
            String textBefore = this.toString();
            String textAfter = this.fixRichFacesImageURLs(facesContext, textBefore);
            this.reset();
            this.write(textAfter.getBytes());
        } else if (resourceName.indexOf(PACKED_JS) >= 0) {
            String textBefore = this.toString();
            String textAfter = this.fixRichFacesPackedDotJs(facesContext, textBefore);
            this.reset();
            this.write(textAfter.getBytes());
        }
    }

    protected String fixRichFacesImageURLs(FacesContext facesContext, String cssText) {
        HashMap<String, String> resourceURLCache = new HashMap<String, String>();
        ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
        for (RichFacesImageResource richFacesImageResource : RichFacesImageResource.values()) {
            boolean doneProcessingURLs = false;
            while (!doneProcessingURLs) {
                String pathPrefix = richFacesImageResource.getPathPrefix();
                int urlStartPos = cssText.indexOf(pathPrefix);
                if (urlStartPos > 0) {
                    int fileNameStartPos = urlStartPos + pathPrefix.length();
                    int dotPos = cssText.indexOf(".", fileNameStartPos);
                    if (dotPos > 0) {
                        int extensionStartPos;
                        boolean doneFindingExtension = false;
                        int extensionFinishPos = extensionStartPos = dotPos + 1;
                        while (!doneFindingExtension) {
                            if (extensionFinishPos < cssText.length() && Character.isLetterOrDigit(cssText.charAt(extensionFinishPos))) {
                                ++extensionFinishPos;
                                continue;
                            }
                            doneFindingExtension = true;
                        }
                        String relativePathKey = cssText.substring(urlStartPos, extensionFinishPos);
                        String imageResourceURL = (String)resourceURLCache.get(relativePathKey);
                        if (imageResourceURL == null) {
                            String resourceName = cssText.substring(fileNameStartPos, extensionFinishPos);
                            String libraryName = richFacesImageResource.getLibraryName();
                            String substitutionToken = richFacesImageResource.getSubstitutionToken();
                            Resource imageResource = resourceHandler.createResource(resourceName, libraryName);
                            imageResourceURL = imageResource.getRequestPath();
                            imageResourceURL = imageResourceURL.replaceAll(libraryName, substitutionToken);
                            resourceURLCache.put(relativePathKey, imageResourceURL);
                        }
                        StringBuilder buf = new StringBuilder();
                        buf.append(cssText.substring(0, urlStartPos));
                        buf.append(imageResourceURL);
                        buf.append(cssText.substring(extensionFinishPos));
                        cssText = buf.toString();
                        continue;
                    }
                    logger.error("Unable to find image filename in URL");
                    continue;
                }
                doneProcessingURLs = true;
            }
        }
        for (RichFacesImageResource richFacesImageResource : RichFacesImageResource.values()) {
            cssText = cssText.replace(richFacesImageResource.getSubstitutionToken(), richFacesImageResource.getLibraryName());
        }
        return cssText;
    }

    protected String fixRichFacesPackedDotJs(FacesContext facesContext, String javaScriptText) {
        StringBuilder buf;
        String token = "this.form.attr(\"action\", originalAction + delimiter + UID + \"=\" + this.loadableItem.uid);";
        int pos = javaScriptText.indexOf(token);
        if (pos > 0) {
            logger.debug("Found first token in packed.js");
            buf = new StringBuilder();
            buf.append(javaScriptText.substring(0, pos));
            buf.append("this.form.attr(\"action\", this.form.children(\"input[name='javax.faces.encodedURL']\").val() + delimiter + UID + \"=\" + this.loadableItem.uid);");
            buf.append(javaScriptText.substring(pos + token.length() + 1));
            javaScriptText = buf.toString();
        }
        if ((pos = javaScriptText.indexOf(token = "if (jQuery.atmosphere.requests.length > 0) {")) > 0) {
            logger.debug("Found second token in packed.js");
            buf = new StringBuilder();
            buf.append(javaScriptText.substring(0, pos));
            buf.append("if (!jQuery.atmosphere) { return; }; ");
            buf.append(javaScriptText.substring(pos));
            javaScriptText = buf.toString();
        }
        if ((pos = javaScriptText.indexOf(token = "jQuery.atmosphere.unsubscribe();")) > 0) {
            logger.debug("Found third token in packed.js");
            buf = new StringBuilder();
            buf.append(javaScriptText.substring(0, pos));
            buf.append("if (!jQuery.atmosphere) { return; }; ");
            buf.append(javaScriptText.substring(pos));
            javaScriptText = buf.toString();
        }
        return javaScriptText;
    }

    protected static enum RichFacesImageResource {
        TYPE1("org.richfaces", "../../org.richfaces.images/", "richfaces-type1"),
        TYPE2("org.richfaces", "../../", "richfaces-type2"),
        TYPE3("org.richfaces.images", "../org.richfaces.images/", "richfaces-type3"),
        TYPE4("org.richfaces.images", "org.richfaces.images/", "richfaces-type4");

        private String libraryName;
        private String pathPrefix;
        private String substitutionToken;

        private RichFacesImageResource(String libraryName, String pathPrefix, String substitutionToken) {
            this.libraryName = libraryName;
            this.pathPrefix = pathPrefix;
            this.substitutionToken = substitutionToken;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public String getSubstitutionToken() {
            return this.substitutionToken;
        }
    }
}

