/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.MissingResourceImpl;
import com.liferay.faces.bridge.application.internal.ResourceImpl;
import com.liferay.faces.bridge.config.internal.PortletConfigParam;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.util.application.ResourceHandlerWrapperBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;

public class ResourceHandlerBridgeImpl
extends ResourceHandlerWrapperBase {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHandlerBridgeImpl.class);
    private static final String ENCODED_RESOURCE_TOKEN = "javax.faces.resource=";
    private Integer bufferSize;

    public ResourceHandlerBridgeImpl(ResourceHandler resourceHandler) {
        super(resourceHandler);
    }

    public static boolean isEncodedFacesResourceURL(String url) {
        return url != null && url.indexOf(ENCODED_RESOURCE_TOKEN) > 0;
    }

    public static boolean isFacesResourceURL(String url) {
        return url != null && url.indexOf("javax.faces.resource") >= 0;
    }

    public Resource createResource(String resourceName) {
        Resource wrappableResource = this.getWrapped().createResource(resourceName);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.getWrapped(), resourceName);
        }
        return new ResourceImpl(wrappableResource);
    }

    public Resource createResource(String resourceName, String libraryName) {
        Resource wrappableResource = this.getWrapped().createResource(resourceName, libraryName);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.getWrapped(), resourceName, libraryName);
        }
        return new ResourceImpl(wrappableResource);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource wrappableResource = this.getWrapped().createResource(resourceName, libraryName, contentType);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.getWrapped(), resourceName, libraryName, contentType);
        }
        return new ResourceImpl(wrappableResource);
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        String resourceName = (String)requestParameterMap.get("javax.faces.resource");
        if (resourceName != null) {
            String libraryName = (String)requestParameterMap.get("ln");
            if (logger.isTraceEnabled()) {
                logger.trace("Handling - resourceName=[{0}], libraryName[{1}]", new Object[]{resourceName, libraryName});
            }
            ResourceHandler resourceHandlerChain = facesContext.getApplication().getResourceHandler();
            Resource resource = null;
            resource = libraryName == null ? resourceHandlerChain.createResource(resourceName) : resourceHandlerChain.createResource(resourceName, libraryName);
            this.handleResource(facesContext, resource);
        } else {
            logger.debug("NOT HANDLED - Missing request parameter {0} so delegating handleResourceRequest to chain", new Object[]{"javax.faces.resource"});
            this.getWrapped().handleResourceRequest(facesContext);
        }
    }

    protected int getBufferSize(FacesContext facesContext) {
        if (this.bufferSize == null) {
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            PortletConfig portletConfig = bridgeContext.getPortletConfig();
            this.bufferSize = PortletConfigParam.ResourceBufferSize.getIntegerValue(portletConfig);
        }
        return this.bufferSize;
    }

    protected boolean isAbleToSetHttpStatusCode(FacesContext facesContext) {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        PortalContext portalContext = portletRequest.getPortalContext();
        String setHttpStatusCodeSupport = portalContext.getProperty("com.liferay.faces.bridge.set.http.status.code.support");
        return setHttpStatusCodeSupport != null;
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        String resourceId = (String)requestParameterMap.get("javax.faces.resource");
        if (resourceId != null) {
            logger.debug("Found {0} request parameter and recognized resourceId=[{1}] as a resource", new Object[]{"javax.faces.resource", resourceId});
            return true;
        }
        logger.debug("Did not find the {0} request parameter so delegating isResourceRequest to chain", new Object[]{"javax.faces.resource"});
        return this.getWrapped().isResourceRequest(facesContext);
    }
}

