/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.BridgeNavigationCaseImpl;
import com.liferay.faces.bridge.application.internal.BridgeNavigationHandler;
import com.liferay.faces.bridge.application.internal.BridgeNavigationUtil;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BridgeURL;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowStateException;

public class BridgeNavigationHandlerImpl
extends BridgeNavigationHandler {
    private static final Logger logger = LoggerFactory.getLogger(BridgeNavigationHandlerImpl.class);
    private NavigationHandler wrappedNavigationHandler;

    public BridgeNavigationHandlerImpl(NavigationHandler navigationHandler) {
        this.wrappedNavigationHandler = navigationHandler;
    }

    @Override
    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        logger.debug("fromAction=[{0}] outcome=[{1}]", new Object[]{fromAction, outcome});
        NavigationCase navigationCase = this.getNavigationCase(facesContext, fromAction, outcome);
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        this.wrappedNavigationHandler.handleNavigation(facesContext, fromAction, outcome);
        if (navigationCase != null) {
            PortletResponse portletResponse;
            String toViewId;
            Iterator itr = facesContext.getMessages();
            while (itr.hasNext()) {
                FacesMessage facesMessage = (FacesMessage)itr.next();
                if (!facesMessage.getDetail().contains("Unable to find matching navigation case")) continue;
                logger.warn("Removed bogus FacesMessage caused by http://jira.icesoft.org/browse/ICE-7996");
                itr.remove();
            }
            if (!navigationCase.isRedirect() && (toViewId = navigationCase.getToViewId(facesContext)) != null && (portletResponse = bridgeContext.getPortletResponse()) instanceof StateAwareResponse) {
                BridgeURL bridgeActionURL = bridgeContext.encodeActionURL(toViewId);
                try {
                    String windowState;
                    BridgeNavigationCaseImpl bridgeNavigationCase = new BridgeNavigationCaseImpl(navigationCase);
                    String portletMode = bridgeNavigationCase.getPortletMode();
                    if (portletMode != null) {
                        bridgeActionURL.setParameter("javax.portlet.faces.PortletMode", portletMode);
                    }
                    if ((windowState = bridgeNavigationCase.getWindowState()) != null) {
                        bridgeActionURL.setParameter("javax.portlet.faces.WindowState", windowState);
                    }
                    BridgeNavigationUtil.navigate(bridgeContext.getPortletRequest(), (StateAwareResponse)portletResponse, bridgeContext.getBridgeRequestScope(), bridgeActionURL);
                }
                catch (PortletModeException e) {
                    logger.error(e.getMessage());
                }
                catch (WindowStateException e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }

    @Override
    public void handleNavigation(FacesContext facesContext, PortletMode fromPortletMode, PortletMode toPortletMode) {
        if (fromPortletMode != null && !fromPortletMode.equals((Object)toPortletMode)) {
            logger.debug("fromPortletMode=[{0}] toPortletMode=[{1}]", new Object[]{fromPortletMode, toPortletMode});
            String currentViewId = facesContext.getViewRoot().getViewId();
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            Map defaultViewIdMap = bridgeContext.getDefaultViewIdMap();
            String portletModeViewId = (String)defaultViewIdMap.get(toPortletMode.toString());
            if (currentViewId != null && portletModeViewId != null && !currentViewId.equals(portletModeViewId)) {
                logger.debug("Navigating to viewId=[{0}]", new Object[]{portletModeViewId});
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                UIViewRoot viewRoot = viewHandler.createView(facesContext, portletModeViewId);
                if (viewRoot != null) {
                    facesContext.setViewRoot(viewRoot);
                    PartialViewContext partialViewContext = facesContext.getPartialViewContext();
                    partialViewContext.setRenderAll(true);
                }
            }
        }
    }

    public NavigationCase getNavigationCase(FacesContext facesContext, String fromAction, String outcome) {
        if (this.wrappedNavigationHandler instanceof ConfigurableNavigationHandler) {
            ConfigurableNavigationHandler wrappedConfigurableNavigationHandler = (ConfigurableNavigationHandler)this.wrappedNavigationHandler;
            return wrappedConfigurableNavigationHandler.getNavigationCase(facesContext, fromAction, outcome);
        }
        throw new UnsupportedOperationException("JSF runtime does not provide an instance of ConfigurableNavigationHandler");
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this.wrappedNavigationHandler instanceof ConfigurableNavigationHandler) {
            ConfigurableNavigationHandler wrappedConfigurableNavigationHandler = (ConfigurableNavigationHandler)this.wrappedNavigationHandler;
            return wrappedConfigurableNavigationHandler.getNavigationCases();
        }
        throw new UnsupportedOperationException("JSF runtime does not provide an instance of ConfigurableNavigationHandler");
    }
}

