/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.context.IncongruityContext;
import com.liferay.faces.bridge.context.url.BridgeResourceURL;
import com.liferay.faces.bridge.context.url.BridgeURL;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeInvalidViewPathException;

public abstract class BridgeContext {
    private static ThreadLocal<BridgeContext> instance = new ThreadLocal();

    public static BridgeContext getCurrentInstance() {
        return instance.get();
    }

    public static void setCurrentInstance(BridgeContext bridgeContext) {
        if (bridgeContext == null) {
            instance.remove();
        } else {
            instance.set(bridgeContext);
        }
    }

    public abstract BridgeURL encodeActionURL(String var1);

    public abstract BridgeURL encodeBookmarkableURL(String var1, Map<String, List<String>> var2);

    public abstract BridgeURL encodePartialActionURL(String var1);

    public abstract BridgeURL encodeRedirectURL(String var1, Map<String, List<String>> var2);

    public abstract BridgeResourceURL encodeResourceURL(String var1);

    public abstract void redirect(String var1) throws IOException;

    public abstract void release();

    public abstract Map<String, Object> getAttributes();

    public abstract BridgeConfig getBridgeConfig();

    public abstract BridgeRequestScope getBridgeRequestScope();

    public abstract String getDefaultRenderKitId();

    public abstract Map<String, String> getDefaultViewIdMap();

    public abstract String getFacesViewId() throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException;

    public abstract String getFacesViewIdFromPath(String var1);

    public abstract String getFacesViewIdFromPath(String var1, boolean var2);

    public abstract String getFacesViewQueryString();

    public abstract boolean isRenderRedirectAfterDispatch();

    public abstract IncongruityContext getIncongruityContext();

    public abstract String getInitParameter(String var1);

    public abstract PortletConfig getPortletConfig();

    public abstract PortletContext getPortletContext();

    public abstract PortletRequest getPortletRequest();

    public abstract void setPortletRequest(PortletRequest var1);

    public abstract Bridge.PortletPhase getPortletRequestPhase();

    public abstract PortletResponse getPortletResponse();

    public abstract void setPortletResponse(PortletResponse var1);

    public abstract List<String> getPreFacesRequestAttrNames();

    public abstract Map<String, String[]> getPreservedActionParams();

    public abstract void setProcessingAfterViewContent(boolean var1);

    public abstract void setRenderRedirectAfterDispatch(boolean var1);

    public abstract BridgeURL getRenderRedirectURL();

    public abstract void setRenderRedirectURL(BridgeURL var1);

    public abstract Map<String, String> getRequestHeaderMap();

    public abstract Map<String, String[]> getRequestHeaderValuesMap();

    public abstract Map<String, String> getRequestParameterMap();

    public abstract Map<String, String[]> getRequestParameterValuesMap();

    public abstract String getRequestPathInfo();

    public abstract String getRequestServletPath();

    public abstract Writer getResponseOutputWriter() throws IOException;

    public abstract boolean isPreserveActionParams();

    public abstract String getSavedViewState();

    public abstract void setSavedViewState(String var1);

    public abstract boolean isProcessingAfterViewContent();

    public abstract boolean isRenderRedirect();
}

