/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.faces.FacesException;

public abstract class BridgeFactoryFinder {
    private static BridgeFactoryFinder instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassPathResourceAsString(String resourcePath) {
        InputStream inputStream;
        String classPathResourceAsString = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(resourcePath)) != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                classPathResourceAsString = bufferedReader.readLine();
            }
            catch (IOException e) {
                System.err.println("Unable to read contents of resourcePath=[" + resourcePath + "]");
            }
            finally {
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return classPathResourceAsString;
    }

    public static Object getFactory(Class<?> clazz) {
        return BridgeFactoryFinder.getInstance().getFactoryInstance(clazz);
    }

    public static BridgeFactoryFinder getInstance() throws FacesException {
        if (instance == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                String factoryFinderService = "META-INF/services/com.liferay.faces.bridge.BridgeFactoryFinder";
                String facesFactoryFinderClassName = BridgeFactoryFinder.getClassPathResourceAsString(factoryFinderService);
                if (facesFactoryFinderClassName == null) {
                    throw new FacesException("Unable to load resource=[" + factoryFinderService + "]");
                }
                Class<?> facesFactoryFinderClass = classLoader.loadClass(facesFactoryFinderClassName);
                instance = (BridgeFactoryFinder)facesFactoryFinderClass.newInstance();
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        return instance;
    }

    public abstract Object getFactoryInstance(Class<?> var1);
}

