/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.cdi.event;

import com.liferay.cdi.portlet.bridge.CDIRenderRequestImpl;
import com.liferay.cdi.portlet.bridge.HttpServletRequestAdapter;
import com.liferay.cdi.portlet.bridge.HttpServletRequestAdapterImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;

public class WeldHelperPhaseListener
implements PhaseListener {
    private static final Logger logger = LoggerFactory.getLogger(WeldHelperPhaseListener.class);
    private static final long serialVersionUID = 1438216845557374340L;
    private PhaseListener weldPhaseListener;

    public WeldHelperPhaseListener() {
        try {
            Class<?> weldPhaseListenerClass = Class.forName("org.jboss.weld.jsf.WeldPhaseListener");
            try {
                this.weldPhaseListener = (PhaseListener)weldPhaseListenerClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            logger.debug("WeldPhaseListener not found on classpath");
        }
    }

    public void afterPhase(PhaseEvent phaseEvent) {
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (this.weldPhaseListener != null) {
            try {
                FacesContext facesContext = phaseEvent.getFacesContext();
                ExternalContext externalContext = facesContext.getExternalContext();
                Object request = externalContext.getRequest();
                if (request instanceof RenderRequest) {
                    PhaseId phaseId = phaseEvent.getPhaseId();
                    Map facesContextAttributes = facesContext.getAttributes();
                    if (phaseId.equals(PhaseId.RESTORE_VIEW)) {
                        facesContextAttributes.put(PhaseId.RESTORE_VIEW, Boolean.TRUE);
                    } else if (phaseId.equals(PhaseId.RENDER_RESPONSE)) {
                        if (facesContextAttributes.get(PhaseId.RESTORE_VIEW) != null) {
                            facesContextAttributes.remove(PhaseId.RESTORE_VIEW);
                        } else {
                            WeldHelperLifecycle weldHelperLifecycle = new WeldHelperLifecycle();
                            PhaseEvent restoreViewPhaseEvent = new PhaseEvent(facesContext, PhaseId.RESTORE_VIEW, (Lifecycle)weldHelperLifecycle);
                            RenderRequest renderRequest = (RenderRequest)request;
                            HttpServletRequestAdapterImpl httpServletRequestAdapter = new HttpServletRequestAdapterImpl((PortletRequest)renderRequest);
                            WeldHelperRenderRequest weldHelperRenderRequest = new WeldHelperRenderRequest(renderRequest, (HttpServletRequestAdapter)httpServletRequestAdapter);
                            externalContext.setRequest((Object)weldHelperRenderRequest);
                            this.weldPhaseListener.beforePhase(restoreViewPhaseEvent);
                            externalContext.setRequest(request);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private static class WeldHelperRenderRequest
    extends CDIRenderRequestImpl {
        public WeldHelperRenderRequest(RenderRequest renderRequest, HttpServletRequestAdapter httpServletRequestAdapter) {
            super(renderRequest, httpServletRequestAdapter);
        }

        public Object getAttribute(String name) {
            if ("org.jboss.weld.context.AbstractConversationContext".equals(name)) {
                return null;
            }
            return super.getAttribute(name);
        }
    }

    private static class WeldHelperLifecycle
    extends Lifecycle {
        private WeldHelperLifecycle() {
        }

        public void addPhaseListener(PhaseListener listener) {
        }

        public void execute(FacesContext context) throws FacesException {
        }

        public PhaseListener[] getPhaseListeners() {
            return null;
        }

        public void removePhaseListener(PhaseListener listener) {
        }

        public void render(FacesContext context) throws FacesException {
        }
    }
}

