/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import routines.system.GlobalResource;

public class RunStat
implements Runnable {
    private boolean openSocket = true;
    private static boolean debug = false;
    public static int BEGIN = 0;
    public static int RUNNING = 1;
    public static int END = 2;
    public static int CLEAR = 3;
    public static int JOBDEFAULT = -1;
    public static int JOBSTART = 0;
    public static int JOBEND = 1;
    public static String TYPE0_JOB = "0";
    public static String TYPE1_CONNECTION = "1";
    private Map<String, StatBean> processStats = new HashMap<String, StatBean>();
    private List<String> keysList = new LinkedList<String>();
    private Socket s;
    private PrintWriter pred;
    private boolean jobIsFinished = false;
    private String str = "";
    long lastStatsUpdate = 0L;
    private String rootPid = null;
    private String fatherPid = null;
    private String pid = "0";
    private String jobName = null;

    public void openSocket(boolean openSocket) {
        this.openSocket = openSocket;
    }

    public void startThreadStat(String clientHost, int portStats) throws IOException, UnknownHostException {
        if (!this.openSocket) {
            Socket s = null;
            Object object = GlobalResource.resourceMap.get(portStats);
            OutputStream output = null;
            if (object == null || !(object instanceof Socket)) {
                String lastCallerJobName = new Exception().getStackTrace()[1].getClassName();
                System.err.println("The socket for statistics function is unavailable in job " + lastCallerJobName + "." + "\nUsually, please check the tRunJob, it should uncheck the option \"Use an independent process to run child job\".");
                output = System.out;
            } else {
                s = (Socket)object;
                output = s.getOutputStream();
            }
            if (debug) {
                output = System.out;
            }
            this.pred = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(output)), true);
            Thread t = new Thread(this);
            t.start();
            return;
        }
        System.out.println("[statistics] connecting to socket on port " + portStats);
        boolean isConnect = false;
        OutputStream output = null;
        try {
            this.s = new Socket(clientHost, portStats);
            isConnect = true;
        }
        catch (Exception e) {
            System.err.println("Unable to connect to " + clientHost + " on the port " + portStats);
        }
        if (isConnect) {
            GlobalResource.resourceMap.put(portStats, this.s);
            output = this.s.getOutputStream();
            System.out.println("[statistics] connected");
        } else {
            output = System.out;
            System.out.println("[statistics] connection refused");
        }
        if (debug) {
            output = System.out;
        }
        this.pred = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(output)), true);
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!debug) {
            RunStat runStat = this;
            synchronized (runStat) {
                try {
                    while (!this.jobIsFinished) {
                        this.sendMessages();
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("[statistics] interrupted");
                }
            }
        }
    }

    public void stopThreadStat() {
        this.jobIsFinished = true;
        try {
            this.sendMessages();
            if (!this.openSocket) {
                return;
            }
            if (this.pred != null) {
                this.pred.close();
            }
            if (this.s != null && !this.s.isClosed()) {
                this.s.close();
            }
            System.out.println("[statistics] disconnected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendMessages() {
        for (String curKey : this.keysList) {
            StatBean sb = this.processStats.get(curKey);
            int jobStat = sb.getJobStat();
            if (jobStat == JOBDEFAULT) {
                this.str = String.valueOf(TYPE1_CONNECTION) + "|" + this.rootPid + "|" + this.fatherPid + "|" + this.pid + "|" + sb.getConnectionId();
                if (sb.getState() == CLEAR) {
                    this.str = String.valueOf(this.str) + "|clear";
                } else {
                    this.str = sb.getExec() == null ? String.valueOf(this.str) + "|" + sb.getNbLine() + "|" + (sb.getEndTime() - sb.getStartTime()) : String.valueOf(this.str) + "|" + sb.getExec();
                    if (sb.getState() != RUNNING) {
                        this.str = String.valueOf(this.str) + "|" + (sb.getState() == BEGIN ? "start" : "stop");
                    }
                    if (sb.isClearAfterSend()) {
                        this.processStats.remove(curKey);
                    }
                }
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
                String jobStatStr = "";
                String itemId = sb.getItemId();
                String string = itemId = itemId == null ? "" : itemId;
                if (jobStat == JOBSTART) {
                    jobStatStr = String.valueOf(this.jobName) + "|" + "start job" + "|" + itemId + "|" + simpleDateFormat.format(new Date(sb.getStartTime()));
                } else if (jobStat == JOBEND) {
                    jobStatStr = String.valueOf(this.jobName) + "|" + "end job" + "|" + itemId + "|" + simpleDateFormat.format(new Date(sb.getEndTime()));
                }
                this.str = String.valueOf(TYPE0_JOB) + "|" + this.rootPid + "|" + this.fatherPid + "|" + this.pid + "|" + jobStatStr;
            }
            this.pred.println(this.str);
        }
        this.keysList.clear();
    }

    public synchronized void updateStatOnConnection(String connectionId, int mode, int nbLine) {
        String key = connectionId;
        if (connectionId.contains(".")) {
            String firstKey = null;
            String connectionName = connectionId.split("\\.")[0];
            int nbKeys = 0;
            for (String myKey : this.keysList) {
                if (!myKey.startsWith(String.valueOf(connectionName) + ".")) continue;
                if (firstKey == null) {
                    firstKey = myKey;
                }
                if (++nbKeys == 4) break;
            }
            if (nbKeys == 4) {
                this.keysList.remove(firstKey);
            }
        }
        if (this.keysList.contains(key)) {
            int keyNb = this.keysList.indexOf(key);
            this.keysList.remove(key);
            this.keysList.add(keyNb, key);
        } else {
            this.keysList.add(key);
        }
        StatBean bean = this.processStats.containsKey(key) ? this.processStats.get(key) : new StatBean(connectionId);
        bean.setState(mode);
        bean.setEndTime(System.currentTimeMillis());
        bean.setNbLine(bean.getNbLine() + nbLine);
        this.processStats.put(key, bean);
        if (mode == BEGIN) {
            bean.setNbLine(0);
            long newStatsUpdate = System.currentTimeMillis();
            if (this.lastStatsUpdate == 0L || this.lastStatsUpdate + 250L < newStatsUpdate) {
                this.sendMessages();
                this.lastStatsUpdate = newStatsUpdate;
            }
            bean.setStartTime(System.currentTimeMillis());
        }
        if (debug) {
            this.sendMessages();
        }
    }

    public synchronized void updateStatOnConnection(String connectionId, int mode, String exec) {
        String key = String.valueOf(connectionId) + "|" + mode;
        boolean clearAfterSend = false;
        if (connectionId.startsWith("iterate")) {
            key = String.valueOf(connectionId) + "|" + mode + "|" + exec;
            clearAfterSend = true;
        } else if (connectionId.contains(".")) {
            String firstKey = null;
            String connectionName = connectionId.split(".")[0];
            int nbKeys = 0;
            for (String myKey : this.keysList) {
                if (!myKey.startsWith(String.valueOf(connectionName) + ".")) continue;
                if (firstKey == null) {
                    firstKey = myKey;
                }
                if (++nbKeys == 4) break;
            }
            if (nbKeys == 4) {
                this.keysList.remove(firstKey);
            }
        }
        if (this.keysList.contains(key)) {
            this.keysList.remove(key);
        }
        this.keysList.add(key);
        StatBean bean = this.processStats.containsKey(key) ? this.processStats.get(key) : new StatBean(connectionId);
        bean.setState(mode);
        bean.setExec(exec);
        bean.setClearAfterSend(clearAfterSend);
        this.processStats.put(key, bean);
        long newStatsUpdate = System.currentTimeMillis();
        if (this.lastStatsUpdate == 0L || this.lastStatsUpdate + 250L < newStatsUpdate) {
            this.sendMessages();
            this.lastStatsUpdate = newStatsUpdate;
        }
    }

    public synchronized void updateStatOnIterate(String connectionId, int mode) {
        String key = String.valueOf(connectionId) + "|" + mode;
        String exec = "";
        StatBean bean = this.processStats.containsKey(key) ? this.processStats.get(key) : new StatBean(connectionId);
        bean.setNbLine(bean.getNbLine() + 1);
        exec = "exec" + bean.getNbLine();
        this.processStats.put(key, bean);
        key = String.valueOf(connectionId) + "|" + mode + "|" + exec;
        if (this.keysList.contains(key)) {
            this.keysList.remove(key);
        }
        this.keysList.add(key);
        bean = this.processStats.containsKey(key) ? this.processStats.get(key) : new StatBean(connectionId);
        bean.setState(mode);
        bean.setExec(exec);
        bean.setClearAfterSend(true);
        this.processStats.put(key, bean);
        long newStatsUpdate = System.currentTimeMillis();
        if (this.lastStatsUpdate == 0L || this.lastStatsUpdate + 250L < newStatsUpdate) {
            this.sendMessages();
            this.lastStatsUpdate = newStatsUpdate;
        }
    }

    public synchronized void updateStatOnJob(int jobStat, String parentNodeName) {
        StatBean bean = new StatBean(jobStat, parentNodeName);
        String key = String.valueOf(jobStat);
        if (this.keysList.contains(key)) {
            this.keysList.remove(key);
        }
        this.keysList.add(key);
        this.processStats.put(key, bean);
        this.sendMessages();
    }

    public void setAllPID(String rootPid, String fatherPid, String pid, String jobName) {
        this.rootPid = rootPid;
        this.fatherPid = fatherPid;
        this.pid = pid;
        this.jobName = jobName;
    }

    private class StatBean {
        private String itemId;
        private String connectionId;
        private int nbLine;
        private int state;
        private long startTime = 0L;
        private long endTime = 0L;
        private String exec = null;
        private boolean clearAfterSend;
        private int jobStat = JOBDEFAULT;

        public StatBean(int jobStat, String itemId) {
            this.jobStat = jobStat;
            this.itemId = itemId;
            if (jobStat == JOBSTART) {
                this.startTime = System.currentTimeMillis();
            } else if (jobStat == JOBEND) {
                this.endTime = System.currentTimeMillis();
            }
        }

        public StatBean(String connectionId) {
            this.connectionId = connectionId;
            this.startTime = System.currentTimeMillis();
        }

        public String getConnectionId() {
            return this.connectionId;
        }

        public void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public int getNbLine() {
            return this.nbLine;
        }

        public void setNbLine(int nbLine) {
            this.nbLine = nbLine;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public String getExec() {
            return this.exec;
        }

        public void setExec(String exec) {
            this.exec = exec;
        }

        public int getJobStat() {
            return this.jobStat;
        }

        public void setJobStat(int jobStat) {
            this.jobStat = jobStat;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setClearAfterSend(boolean clearAfterSend) {
            this.clearAfterSend = clearAfterSend;
        }

        public boolean isClearAfterSend() {
            return this.clearAfterSend;
        }
    }
}

