/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import routines.system.Document;
import routines.system.FastDateParser;
import routines.system.StringUtils;

public class ParserUtils {
    private static final Set<String> primitiveType = new HashSet<String>();
    private static final Map<String, String> primitiveTypeToDefaultValueMap = new HashMap<String, String>();

    static {
        primitiveType.add("boolean");
        primitiveType.add("int");
        primitiveType.add("byte");
        primitiveType.add("char");
        primitiveType.add("double");
        primitiveType.add("float");
        primitiveType.add("long");
        primitiveType.add("short");
        primitiveTypeToDefaultValueMap.put("boolean", "false");
        primitiveTypeToDefaultValueMap.put("int", "0");
        primitiveTypeToDefaultValueMap.put("byte", "0");
        primitiveTypeToDefaultValueMap.put("char", " ");
        primitiveTypeToDefaultValueMap.put("double", "0");
        primitiveTypeToDefaultValueMap.put("float", "0");
        primitiveTypeToDefaultValueMap.put("long", "0");
        primitiveTypeToDefaultValueMap.put("short", "0");
    }

    public static List<String> parseTo_List(String s) {
        return ParserUtils.parseTo_List(s, null);
    }

    public static List<String> parseTo_List(String strSrc, String fieldSep) {
        if (strSrc == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (fieldSep == null || "".equals(fieldSep) || !strSrc.startsWith("[") || !strSrc.endsWith("]")) {
            list.add(strSrc);
            return list;
        }
        String strTemp = strSrc.substring(1, strSrc.length() - 1);
        String[] stringArray = strTemp.split(fieldSep, -1);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            list.add(str);
            ++n2;
        }
        return list;
    }

    public static Character parseTo_Character(String s) {
        if (s == null) {
            return null;
        }
        return Character.valueOf(s.charAt(0));
    }

    public static char parseTo_char(String s) {
        return ParserUtils.parseTo_Character(s).charValue();
    }

    public static Byte parseTo_Byte(String s) {
        if (s == null) {
            return null;
        }
        return (byte)Byte.decode(s);
    }

    public static Byte parseTo_Byte(String s, boolean isDecode) {
        if (s == null) {
            return null;
        }
        if (isDecode) {
            return (byte)Byte.decode(s);
        }
        return Byte.parseByte(s);
    }

    public static byte parseTo_byte(String s) {
        return ParserUtils.parseTo_Byte(s);
    }

    public static byte parseTo_byte(String s, boolean isDecode) {
        return ParserUtils.parseTo_Byte(s, isDecode);
    }

    public static Double parseTo_Double(String s) {
        if (s == null) {
            return null;
        }
        return Double.parseDouble(s);
    }

    public static double parseTo_double(String s) {
        return ParserUtils.parseTo_Double(s);
    }

    public static float parseTo_float(String s) {
        return Float.parseFloat(s);
    }

    public static Float parseTo_Float(String s) {
        if (s == null) {
            return null;
        }
        return Float.valueOf(ParserUtils.parseTo_float(s));
    }

    public static int parseTo_int(String s) {
        return Integer.parseInt(s);
    }

    public static int parseTo_int(String s, boolean isDecode) {
        if (isDecode) {
            return Integer.decode(s);
        }
        return Integer.parseInt(s);
    }

    public static Integer parseTo_Integer(String s) {
        if (s == null) {
            return null;
        }
        return ParserUtils.parseTo_int(s);
    }

    public static Integer parseTo_Integer(String s, boolean isDecode) {
        if (s == null) {
            return null;
        }
        return ParserUtils.parseTo_int(s, isDecode);
    }

    public static short parseTo_short(String s) {
        return Short.parseShort(s);
    }

    public static short parseTo_short(String s, boolean isDecode) {
        if (isDecode) {
            return Short.decode(s);
        }
        return Short.parseShort(s);
    }

    public static Short parseTo_Short(String s) {
        if (s == null) {
            return null;
        }
        return ParserUtils.parseTo_short(s);
    }

    public static Short parseTo_Short(String s, boolean isDecode) {
        if (s == null) {
            return null;
        }
        return ParserUtils.parseTo_short(s, isDecode);
    }

    public static long parseTo_long(String s) {
        return Long.parseLong(s);
    }

    public static long parseTo_long(String s, boolean isDecode) {
        if (isDecode) {
            return Long.decode(s);
        }
        return Long.parseLong(s);
    }

    public static Long parseTo_Long(String s) {
        if (s == null) {
            return null;
        }
        return ParserUtils.parseTo_long(s);
    }

    public static Long parseTo_Long(String s, boolean isDecode) {
        if (s == null) {
            return null;
        }
        return ParserUtils.parseTo_long(s, isDecode);
    }

    public static Boolean parseTo_Boolean(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals("1")) {
            return Boolean.parseBoolean("true");
        }
        return Boolean.parseBoolean(s);
    }

    public static boolean parseTo_boolean(String s) {
        return ParserUtils.parseTo_Boolean(s);
    }

    public static String parseTo_String(String s) {
        return s;
    }

    public static String parseTo_String(List<String> s, String fieldSep) {
        if (s == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append("[");
        int i = 0;
        while (i < s.size()) {
            if (i != 0) {
                result.append(fieldSep);
            }
            result.append(s.get(i));
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public static BigDecimal parseTo_BigDecimal(String s) {
        if (s == null) {
            return null;
        }
        try {
            return new BigDecimal(s);
        }
        catch (NumberFormatException nfe) {
            if (nfe.getMessage() == null) {
                throw new NumberFormatException("Incorrect input \"" + s + "\" for BigDecimal.");
            }
            throw nfe;
        }
    }

    public static Document parseTo_Document(String s) throws DocumentException {
        return ParserUtils.parseTo_Document(s, false);
    }

    public static Document parseTo_Document(String s, boolean ignoreDTD) throws DocumentException {
        return ParserUtils.parseTo_Document(s, false, null);
    }

    public static Document parseTo_Document(String s, boolean ignoreDTD, String encoding) throws DocumentException {
        if (s == null) {
            return null;
        }
        Document theDoc = new Document();
        SAXReader reader = new SAXReader();
        if (ignoreDTD) {
            reader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
            });
        }
        org.dom4j.Document document = reader.read((Reader)new StringReader(s));
        if (encoding != null && !"".equals(encoding)) {
            document.setXMLEncoding(encoding);
        }
        theDoc.setDocument(document);
        return theDoc;
    }

    public static Date parseTo_Date(Long epoch) throws NumberFormatException {
        return new Date(epoch * 1000L);
    }

    public static Date parseTo_Date(String epoch) {
        try {
            return ParserUtils.parseTo_Date(Long.parseLong(epoch));
        }
        catch (NumberFormatException e) {
            Double epochDouble = Double.parseDouble(epoch);
            if (epochDouble == (double)epochDouble.longValue()) {
                return ParserUtils.parseTo_Date(epochDouble.longValue());
            }
            throw e;
        }
    }

    public static Date parseTo_Date(String dateString, String pattern) {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        dateString = dateString.trim();
        if (pattern == null) {
            pattern = "dd-MM-yyyy";
        }
        Date date = null;
        if (pattern.equals("yyyy-MM-dd'T'HH:mm:ss'000Z'")) {
            if (!dateString.endsWith("000Z")) {
                throw new RuntimeException("Unparseable date: \"" + dateString + "\"");
            }
            pattern = "yyyy-MM-dd'T'HH:mm:ss";
            dateString = dateString.substring(0, dateString.lastIndexOf("000Z"));
        }
        DateFormat format = FastDateParser.getInstance(pattern);
        ParsePosition pp = new ParsePosition(0);
        pp.setIndex(0);
        date = format.parse(dateString, pp);
        if (pp.getIndex() != dateString.length() || date == null) {
            throw new RuntimeException("Unparseable date: \"" + dateString + "\"");
        }
        return date;
    }

    public static Date parseTo_Date(String s, String pattern, boolean lenient) {
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() == 0) {
            return null;
        }
        if (pattern == null) {
            pattern = "dd-MM-yyyy";
        }
        Date date = null;
        if (pattern.equals("yyyy-MM-dd'T'HH:mm:ss'000Z'")) {
            if (!s.endsWith("000Z")) {
                throw new RuntimeException("Unparseable date: \"" + s + "\"");
            }
            pattern = "yyyy-MM-dd'T'HH:mm:ss";
            s = s.substring(0, s.lastIndexOf("000Z"));
        }
        DateFormat format = FastDateParser.getInstance(pattern, lenient);
        ParsePosition pp = new ParsePosition(0);
        pp.setIndex(0);
        date = format.parse(s, pp);
        if (pp.getIndex() != s.length() || date == null) {
            throw new RuntimeException("Unparseable date: \"" + s + "\"");
        }
        return date;
    }

    public static Date parseTo_Date(Date date, String pattern) {
        return date;
    }

    public static String parseTo_Number(String s, Character thousandsSeparator, Character decimalSeparator) {
        if (s == null) {
            return null;
        }
        String result = s;
        if (thousandsSeparator != null) {
            result = StringUtils.deleteChar(s, thousandsSeparator.charValue());
        }
        if (decimalSeparator != null) {
            result = result.replace(decimalSeparator.charValue(), '.');
        }
        return result;
    }

    public static Object parse(String text, String javaType, String pattern) {
        if ("String".equals(javaType) || "Object".equals(javaType)) {
            return text;
        }
        if (text == null || text.length() == 0) {
            boolean isPrimitiveType = primitiveType.contains(javaType);
            if (!isPrimitiveType) {
                return null;
            }
            text = primitiveTypeToDefaultValueMap.get(javaType);
        } else {
            if ("java.util.Date".equals(javaType)) {
                return ParserUtils.parseTo_Date(text, pattern);
            }
            if ("byte[]".equals(javaType)) {
                return text.getBytes();
            }
        }
        try {
            Method method = ParserUtils.class.getMethod("parseTo_" + javaType, String.class);
            return method.invoke(null, text);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

