/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class NameSpaceTool {
    public HashMap<String, String> xmlNameSpaceMap = new HashMap();
    private List<String> defualtNSPath = new ArrayList<String>();
    private String matches = "@*\\b[a-z|A-Z|_]+[[-]*\\w]*\\b[^'|^\\(]";
    private Pattern pattern = Pattern.compile(this.matches);

    public void countNSMap(Element el) {
        for (Namespace ns : el.declaredNamespaces()) {
            if (ns.getPrefix().trim().length() == 0) {
                this.xmlNameSpaceMap.put("pre" + this.defualtNSPath.size(), ns.getURI());
                String path = "";
                Element elTmp = el;
                while (elTmp != null) {
                    path = elTmp.getNamespacePrefix() != null && elTmp.getNamespacePrefix().length() > 0 ? "/" + elTmp.getNamespacePrefix() + ":" + elTmp.getName() + path : "/" + elTmp.getName() + path;
                    elTmp = elTmp.getParent();
                }
                this.defualtNSPath.add(path);
                continue;
            }
            this.xmlNameSpaceMap.put(ns.getPrefix(), ns.getURI());
        }
        for (Element e : el.elements()) {
            this.countNSMap(e);
        }
    }

    public String addDefaultNSPrefix(String path, String loopPath) {
        if (this.defualtNSPath.size() > 0) {
            String fullPath = loopPath;
            if (!path.equals(fullPath)) {
                String[] stringArray = path.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String tmp = stringArray[n2];
                    fullPath = "..".equals(tmp) ? fullPath.substring(0, fullPath.lastIndexOf("/")) : String.valueOf(fullPath) + "/" + tmp;
                    ++n2;
                }
            }
            int[] indexs = new int[fullPath.split("/").length - 1];
            Arrays.fill(indexs, -1);
            int length = 0;
            int i = 0;
            while (i < this.defualtNSPath.size()) {
                if (this.defualtNSPath.get(i).length() > length && fullPath.startsWith(this.defualtNSPath.get(i))) {
                    Arrays.fill(indexs, this.defualtNSPath.get(i).split("/").length - 2, indexs.length, i);
                    length = this.defualtNSPath.get(i).length();
                }
                ++i;
            }
            StringBuilder newPath = new StringBuilder();
            String[] pathStrs = path.split("/");
            int i2 = 0;
            while (i2 < pathStrs.length) {
                String tmp = pathStrs[i2];
                if (newPath.length() > 0) {
                    newPath.append("/");
                }
                if (tmp.length() > 0 && tmp.indexOf(":") == -1 && tmp.indexOf(".") == -1) {
                    int index = indexs[i2 + indexs.length - pathStrs.length];
                    if (index >= 0) {
                        if (tmp.indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                            String tmpStr = this.replaceElementWithNS(tmp, "pre" + index + ":");
                            newPath.append(tmpStr);
                        } else if (tmp.indexOf("@") != -1 || tmp.indexOf("(") < tmp.indexOf(")")) {
                            newPath.append(tmp);
                        } else {
                            newPath.append("pre").append(index).append(":").append(tmp);
                        }
                    } else {
                        newPath.append(tmp);
                    }
                } else {
                    newPath.append(tmp);
                }
                ++i2;
            }
            return newPath.toString();
        }
        return path;
    }

    private String replaceElementWithNS(String global, String pre) {
        Matcher match = this.pattern.matcher(global);
        StringBuffer sb = new StringBuffer();
        match.reset();
        while (match.find()) {
            String group = match.group();
            String tmp = "";
            tmp = group.toLowerCase().matches("\\b(div|mod|and|or)\\b.*") || group.matches("@.*") ? group : String.valueOf(tmp) + pre + group;
            match.appendReplacement(sb, tmp);
        }
        match.appendTail(sb);
        return sb.toString();
    }
}

