/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class MRRunStat
implements Runnable {
    private static boolean debug = false;
    private Socket s;
    protected PrintWriter pred;
    private boolean jobIsFinished = false;
    private List<StatBean> messages = new ArrayList<StatBean>();

    public StatBean createStatBean() {
        return new StatBean();
    }

    public void startThreadStat(String clientHost, int portStats) throws IOException, UnknownHostException {
        System.out.println("[statistics] connecting to socket on port " + portStats);
        boolean isConnect = false;
        OutputStream output = null;
        try {
            this.s = new Socket(clientHost, portStats);
            isConnect = true;
        }
        catch (Exception e) {
            System.err.println("Unable to connect to " + clientHost + " on the port " + portStats);
        }
        if (isConnect) {
            output = this.s.getOutputStream();
            System.out.println("[statistics] connected");
        } else {
            output = System.out;
            System.out.println("[statistics] connection refused");
        }
        if (debug) {
            output = System.out;
        }
        this.pred = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(output)), true);
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!debug) {
            MRRunStat mRRunStat = this;
            synchronized (mRRunStat) {
                try {
                    while (!this.jobIsFinished) {
                        this.sendMessages();
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("[statistics] interrupted");
                }
            }
        }
    }

    public void stopThreadStat() {
        this.jobIsFinished = true;
        try {
            this.sendMessages();
            if (this.pred != null) {
                this.pred.close();
            }
            if (this.s != null && !this.s.isClosed()) {
                this.s.close();
            }
            System.out.println("[statistics] disconnected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendMessages() {
        for (StatBean message : this.messages) {
            this.pred.println(message.toStatFormat());
        }
        this.messages.clear();
    }

    public synchronized void updateMRProgress(StatBean message) {
        this.messages.add(message);
        if (debug) {
            this.sendMessages();
        }
    }

    public class StatBean {
        private int groupID;
        private int mrJobID;
        private float mapProgress;
        private float reduceProgress;

        public int getGroupID() {
            return this.groupID;
        }

        public void setGroupID(int groupID) {
            this.groupID = groupID;
        }

        public int getMRJobID() {
            return this.mrJobID;
        }

        public void setMRJobID(int mrJobID) {
            this.mrJobID = mrJobID;
        }

        public float getMapProgress() {
            return this.mapProgress;
        }

        public void setMapProgress(float mapProgress) {
            this.mapProgress = mapProgress;
        }

        public float getReduceProgress() {
            return this.reduceProgress;
        }

        public void setReduceProgress(float reduceProgress) {
            this.reduceProgress = reduceProgress;
        }

        public String toStatFormat() {
            return String.valueOf(this.groupID) + "|" + this.mrJobID + "|" + this.mapProgress + "|" + this.reduceProgress;
        }
    }
}

