/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class GetJarsToRegister {
    private String oozieClasspathLine;
    private boolean isOozieRuntime;

    public GetJarsToRegister() {
        try {
            this.isOozieRuntime = this.setJarsToRegister();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean setJarsToRegister() throws IOException, DocumentException {
        String jobXmlPath = new File("../../job.xml").getCanonicalPath();
        boolean isOozieExecution = this.isNeedAddLibsPath(jobXmlPath);
        if (!isOozieExecution) {
            jobXmlPath = new File("./job.xml").getCanonicalPath();
            isOozieExecution = this.isNeedAddLibsPath(jobXmlPath);
        }
        if (isOozieExecution) {
            SAXReader reader_oozie = new SAXReader();
            Document document_oozie = reader_oozie.read(jobXmlPath);
            List list_oozie = document_oozie.selectNodes("/configuration/property");
            for (Node node : list_oozie) {
                Element element_oozie = (Element)node;
                String name_oozie = element_oozie.elementText("name");
                if (!name_oozie.equals("mapred.cache.localFiles") && !name_oozie.equals("mapreduce.job.cache.local.files")) continue;
                this.oozieClasspathLine = element_oozie.elementText("value");
                return true;
            }
        }
        return false;
    }

    public String replaceJarPaths(String originalClassPathLine) throws Exception {
        return this.replaceJarPaths(originalClassPathLine, "");
    }

    public String replaceJarPaths(String originalClassPathLine, String scheme) throws Exception {
        return this.replaceJarPaths(originalClassPathLine, scheme, false);
    }

    public String replaceJarPaths(String originalClassPathLine, String scheme, boolean encodeSpaces) throws Exception {
        String classPathLine = "";
        String crcMapPath = new File("../crcMap").getCanonicalPath();
        if (this.isNeedAddLibsPath(crcMapPath)) {
            Map crcMap = null;
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(crcMapPath));
            crcMap = (Map)ois.readObject();
            ois.close();
            classPathLine = this.addLibsPath(originalClassPathLine, crcMap);
        } else if (this.isOozieRuntime) {
            if (this.oozieClasspathLine != null) {
                List<String> oozieJars = Arrays.asList(this.oozieClasspathLine.split(","));
                int j = 0;
                while (j < oozieJars.size()) {
                    if (oozieJars.get(j).contains(originalClassPathLine.substring(originalClassPathLine.lastIndexOf("/")))) {
                        classPathLine = oozieJars.get(j);
                        break;
                    }
                    ++j;
                }
            }
        } else {
            classPathLine = originalClassPathLine != null && originalClassPathLine.startsWith(".") ? originalClassPathLine : String.valueOf(scheme) + originalClassPathLine;
        }
        if (encodeSpaces) {
            classPathLine = classPathLine.replaceAll("\\s", "%20");
        }
        return classPathLine;
    }

    private boolean isNeedAddLibsPath(String crcMapPath) {
        return new File(crcMapPath).exists();
    }

    private String addLibsPath(String line, Map<String, String> crcMap) {
        for (Map.Entry<String, String> entry : crcMap.entrySet()) {
            line = this.adaptLibPaths(line, entry);
        }
        return line;
    }

    private String adaptLibPaths(String line, Map.Entry<String, String> entry) {
        String jarName = entry.getValue();
        String crc = entry.getKey();
        String libStringFinder = "../lib/" + jarName;
        String libStringFinder2 = "./" + jarName;
        if (line.contains(libStringFinder)) {
            line = line.replace(libStringFinder, "../../../cache/lib/" + crc + "/" + jarName);
        } else if (line.toLowerCase().contains(libStringFinder2)) {
            line = line.toLowerCase().replace(libStringFinder2, "../../../cache/lib/" + crc + "/" + jarName);
        } else if (line.toLowerCase().equals(jarName)) {
            line = "../../../cache/lib/" + crc + "/" + jarName;
        } else if (line.contains(":$ROOT_PATH/" + jarName + ":")) {
            line = line.replace(":$ROOT_PATH/" + jarName + ":", ":$ROOT_PATH/../../../cache/lib/" + crc + "/" + jarName + ":");
        } else if (line.contains(";" + jarName + ";")) {
            line = line.replace(";" + jarName + ";", ";../../../cache/lib/" + crc + "/" + jarName + ";");
        }
        return line;
    }
}

