/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.XPath;
import org.dom4j.tree.AbstractNode;
import routines.system.NameSpaceTool;

public class DocumentToFlat {
    private Document doc;
    private String currentLoop;
    private String originalLoop;
    private String[] currentRelativePathMappings;
    private String[] absolutePathMappings;
    private Map<String, String> xmlNameSpaceMap;
    private boolean top = false;
    boolean isOptional = false;
    private boolean defineNS = true;
    private NameSpaceTool namespaceTool;
    private List<AbstractNode> nodes;
    private List<Map<String, String>> resultSet = new ArrayList<Map<String, String>>();
    private Map<String, Object> lookupInfo;
    private Map<String, String> xpathOfResults;
    private Map<String, String> xpathToTypeMap;
    private Map<String, String> xpathToPatternMap;
    private boolean loopChanged = false;

    public DocumentToFlat() {
    }

    public void flat() {
        XPath loopXpath = null;
        loopXpath = !this.defineNS ? this.doc.createXPath(this.namespaceTool.addDefaultNSPrefix(this.currentLoop, this.currentLoop)) : this.doc.createXPath(this.currentLoop);
        loopXpath.setNamespaceURIs(this.xmlNameSpaceMap);
        this.nodes = loopXpath.selectNodes((Object)this.doc);
        if (this.isOptional && this.nodes.size() == 0 && !this.top) {
            this.setParentAsLoop();
            this.flat();
        } else if (this.nodes != null) {
            if (this.currentLoop != this.originalLoop) {
                int i = 0;
                while (i < this.currentRelativePathMappings.length) {
                    this.currentRelativePathMappings[i] = this.resetRelativeXPath(this.currentRelativePathMappings[i]);
                    ++i;
                }
            }
            for (AbstractNode node : this.nodes) {
                HashMap<String, String> row = new HashMap<String, String>();
                this.resultSet.add(row);
                int i = 0;
                while (i < this.currentRelativePathMappings.length) {
                    String relativePath = this.currentRelativePathMappings[i];
                    XPath xpath = null;
                    xpath = !this.defineNS ? node.createXPath(this.namespaceTool.addDefaultNSPrefix(relativePath, this.currentLoop)) : node.createXPath(relativePath);
                    xpath.setNamespaceURIs(this.xmlNameSpaceMap);
                    Object obj = xpath.evaluate((Object)node);
                    if (obj instanceof String || obj instanceof Number) {
                        row.put(this.absolutePathMappings[i], String.valueOf(obj));
                    } else {
                        row.put(this.absolutePathMappings[i], xpath.selectSingleNode((Object)node) != null ? xpath.valueOf((Object)node) : null);
                    }
                    ++i;
                }
            }
            this.doc = null;
            this.nodes = null;
        }
    }

    private String resetRelativeXPath(String relativePath) {
        String absolutePath = this.originalLoop;
        String[] stringArray = relativePath.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String step = stringArray[n2];
            if ("..".equals(step)) {
                absolutePath = absolutePath.substring(0, absolutePath.lastIndexOf("/"));
            } else if (!".".equals(step) && !"".equals(step)) {
                absolutePath = String.valueOf(absolutePath) + "/" + step;
            }
            ++n2;
        }
        if (absolutePath.equals(this.currentLoop)) {
            return ".";
        }
        if (absolutePath.startsWith(this.currentLoop)) {
            return absolutePath.substring(this.currentLoop.length() + 1);
        }
        StringBuilder relativeXPath = new StringBuilder();
        String tmp = this.currentLoop;
        while (!absolutePath.startsWith(tmp)) {
            int index = tmp.lastIndexOf("/");
            if (index < 0) break;
            tmp = tmp.substring(0, index);
            relativeXPath.append("../");
        }
        relativeXPath.append(absolutePath.substring(tmp.length() + 1));
        return relativeXPath.toString();
    }

    private void setParentAsLoop() {
        int end = this.currentLoop.length();
        int idx = this.currentLoop.lastIndexOf(47);
        if (idx > 0) {
            end = idx;
        } else if (idx == 0) {
            this.top = true;
        }
        this.currentLoop = this.currentLoop.substring(0, end);
    }

    public List<Map<String, String>> getResultSet() {
        return this.resultSet;
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }

    public void setOriginalLoop(String originalLoop) {
        this.originalLoop = originalLoop;
        this.currentLoop = originalLoop;
    }

    public void setCurrentRelativePathMappings(String[] currentRelativePathMappings) {
        this.currentRelativePathMappings = currentRelativePathMappings;
    }

    public void setAbsolutePathMappings(String[] absolutePathMappings) {
        this.absolutePathMappings = absolutePathMappings;
    }

    public void setXmlNameSpaceMap(Map<String, String> xmlNameSpaceMap) {
        this.xmlNameSpaceMap = xmlNameSpaceMap;
    }

    public void setDefineNS(boolean defineNS) {
        this.defineNS = defineNS;
    }

    public void setNamespaceTool(NameSpaceTool namespaceTool) {
        this.namespaceTool = namespaceTool;
    }

    public DocumentToFlat(Map<String, Object> lookupInfo, Map<String, String> xpathOfResults, Map<String, String> xpathToTypeMap, Map<String, String> xpathToPatternMap) {
        this.lookupInfo = lookupInfo;
        this.xpathOfResults = xpathOfResults;
        this.xpathToTypeMap = xpathToTypeMap;
        this.xpathToPatternMap = xpathToPatternMap;
    }

    public void flatForLookup(boolean isOptionalLoop) {
        XPath loopXpath = this.doc.createXPath(this.currentLoop);
        loopXpath.setNamespaceURIs(this.xmlNameSpaceMap);
        this.nodes = loopXpath.selectNodes((Object)this.doc);
        if (isOptionalLoop && this.nodes.size() == 0 && !this.top) {
            this.setParentAsLoop();
            this.flatForLookup(isOptionalLoop);
        } else if (this.currentLoop != this.originalLoop) {
            this.loopChanged = true;
            this.reset();
        }
    }

    private void reset() {
        this.lookupInfo = this.resetMapRelativeXpathKey(this.lookupInfo);
        this.xpathToTypeMap = this.resetMapRelativeXpathKey(this.xpathToTypeMap);
        this.xpathToPatternMap = this.resetMapRelativeXpathKey(this.xpathToPatternMap);
        this.xpathOfResults = this.resetMapRelativeXpathValue(this.xpathOfResults);
    }

    private Map resetMapRelativeXpathKey(Map<String, ? extends Object> source) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        for (String key : source.keySet()) {
            String newKey = this.resetRelativeXPath(key);
            content.put(newKey, source.get(key));
        }
        return content;
    }

    private Map resetMapRelativeXpathValue(Map<String, String> source) {
        HashMap<String, String> content = new HashMap<String, String>();
        for (String key : source.keySet()) {
            String value = source.get(key);
            String newValue = this.resetRelativeXPath(value);
            content.put(key, newValue);
        }
        return content;
    }

    public List<AbstractNode> getNodes() {
        return this.nodes;
    }

    public Map<String, Object> getLookupInfo() {
        return this.lookupInfo;
    }

    public Map<String, String> getXpathOfResults() {
        return this.xpathOfResults;
    }

    public Map<String, String> getXpathToTypeMap() {
        return this.xpathToTypeMap;
    }

    public Map<String, String> getXpathToPatternMap() {
        return this.xpathToPatternMap;
    }

    public boolean isLoopChanged() {
        return this.loopChanged;
    }

    public void setIsOptional(boolean isLoopOptional) {
        this.isOptional = isLoopOptional;
    }
}

