/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AssertCatcherUtils {
    List<AssertCatcherMessage> messages = Collections.synchronizedList(new ArrayList());

    public void addMessage(String pid, String project, String job, String language, String origin, String status, String substatus, String description) {
        AssertCatcherMessage lcm = new AssertCatcherMessage(pid, project, job, language, origin, status, substatus, description);
        this.messages.add(lcm);
    }

    public void addMessage(String pid, String project, String job, String language, String origin, String status, String substatus, Exception exception) {
        AssertCatcherMessage lcm = new AssertCatcherMessage(pid, project, job, language, origin, status, substatus, exception);
        this.messages.add(lcm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssertCatcherMessage> getMessages() {
        ArrayList<AssertCatcherMessage> messagesToSend = new ArrayList<AssertCatcherMessage>();
        List<AssertCatcherMessage> list = this.messages;
        synchronized (list) {
            for (AssertCatcherMessage acm : this.messages) {
                messagesToSend.add(acm);
            }
            this.messages.clear();
        }
        return messagesToSend;
    }

    public class AssertCatcherMessage {
        private Date moment = Calendar.getInstance().getTime();
        private String pid;
        private String project;
        private String job;
        private String language;
        private String origin;
        private String status;
        private String substatus;
        private String description;
        private Exception exception;

        public AssertCatcherMessage(String pid, String project, String job, String language, String origin, String status, String substatus, String description) {
            this.pid = pid;
            this.project = project;
            this.job = job;
            this.language = language;
            this.origin = origin;
            this.status = status;
            this.substatus = substatus;
            this.description = description;
        }

        public AssertCatcherMessage(String pid, String project, String job, String language, String origin, String status, String substatus, Exception exception) {
            this(pid, project, job, language, origin, status, substatus, exception.getMessage());
            this.exception = exception;
        }

        public Date getMoment() {
            return this.moment;
        }

        public void setMoment(Date moment) {
            this.moment = moment;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getJob() {
            return this.job;
        }

        public void setJob(String job) {
            this.job = job;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public String getPid() {
            return this.pid;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getSubstatus() {
            return this.substatus;
        }

        public void setSubstatus(String substatus) {
            this.substatus = substatus;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }
}

