/*
 * Decompiled with CFR 0.152.
 */
package routines;

import java.util.Random;
import java.util.Vector;

public class TalendString {
    private static final int MIN = 192;
    private static final int MAX = 255;
    private static final Vector map = TalendString.initMap();

    public static Vector getMap() {
        return map;
    }

    public static String replaceSpecialCharForXML(String input) {
        input = input.replaceAll("&", "&amp;");
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll("'", "&apos;");
        input = input.replaceAll("\"", "&quot;");
        return input;
    }

    public static String checkCDATAForXML(String input) {
        if (input.startsWith("<![CDATA[") && input.endsWith("]]>")) {
            return input;
        }
        return TalendString.replaceSpecialCharForXML(input);
    }

    public static String getAsciiRandomString(int length) {
        Random random = new Random();
        int cnt = 0;
        StringBuffer buffer = new StringBuffer();
        int end = 123;
        int start = 32;
        while (cnt < length) {
            char ch = (char)(random.nextInt(end - start) + start);
            if (!Character.isLetterOrDigit(ch)) continue;
            buffer.append(ch);
            ++cnt;
        }
        return buffer.toString();
    }

    public static String talendTrim(String origin, char padding_char, int align) {
        if (origin == null) {
            return null;
        }
        String sPaddingChar = TalendString.quoteChars(Character.toString(padding_char));
        if (align > 0) {
            origin = origin.replaceAll("^" + sPaddingChar + "+", "");
        } else if (align == 0) {
            origin = origin.replaceAll("^" + sPaddingChar + "+", "");
            origin = origin.replaceAll(String.valueOf(sPaddingChar) + "+$", "");
        } else if (align < 0) {
            origin = origin.replaceAll(String.valueOf(sPaddingChar) + "+$", "");
        }
        return origin;
    }

    private static String quoteChars(String padding_chars) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < padding_chars.length()) {
            char c = padding_chars.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                sb.append('\\');
                sb.append(c);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String addEscapeChars(String padding_chars, char escapeChar) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < padding_chars.length()) {
            char c = padding_chars.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_' && !Character.isWhitespace(c)) {
                sb.append(escapeChar);
                sb.append(c);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private static Vector initMap() {
        Vector<String> result = new Vector<String>();
        String car = null;
        car = new String("A");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("AE");
        result.add(car);
        car = new String("C");
        result.add(car);
        car = new String("E");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("I");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("D");
        result.add(car);
        car = new String("N");
        result.add(car);
        car = new String("O");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("*");
        result.add(car);
        car = new String("0");
        result.add(car);
        car = new String("U");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("Y");
        result.add(car);
        car = new String("_");
        result.add(car);
        car = new String("B");
        result.add(car);
        car = new String("a");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("ae");
        result.add(car);
        car = new String("c");
        result.add(car);
        car = new String("e");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("i");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("d");
        result.add(car);
        car = new String("n");
        result.add(car);
        car = new String("o");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("/");
        result.add(car);
        car = new String("0");
        result.add(car);
        car = new String("u");
        result.add(car);
        result.add(car);
        result.add(car);
        result.add(car);
        car = new String("y");
        result.add(car);
        car = new String("_");
        result.add(car);
        car = new String("y");
        result.add(car);
        result.add(car);
        return result;
    }

    public static String removeAccents(String text) {
        StringBuffer result = new StringBuffer();
        int bcl = 0;
        while (bcl < text.length()) {
            char carVal = text.charAt(bcl);
            if (carVal >= '\u00c0' && carVal <= '\u00ff') {
                String newVal = (String)map.get(carVal - 192);
                result.append(newVal);
            } else {
                result.append(carVal);
            }
            ++bcl;
        }
        return result.toString();
    }

    public static String unionString(String separator, Object ... objects) {
        if (objects != null) {
            String value = "";
            boolean isFirst = true;
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (isFirst) {
                    value = String.valueOf(obj);
                    isFirst = false;
                } else {
                    value = String.valueOf(value) + separator + String.valueOf(obj);
                }
                ++n2;
            }
            return value;
        }
        return null;
    }
}

