/*
 * Decompiled with CFR 0.152.
 */
package routines;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class Numeric {
    private static final Map<String, Integer> seq_Hash = new HashMap<String, Integer>();

    public static Integer sequence(String seqName, int startValue, int step) {
        if (seq_Hash.containsKey(seqName)) {
            seq_Hash.put(seqName, seq_Hash.get(seqName) + step);
            return seq_Hash.get(seqName);
        }
        seq_Hash.put(seqName, startValue);
        return startValue;
    }

    public static void resetSequence(String seqName, int startValue) {
        seq_Hash.put(seqName, startValue);
    }

    public static void removeSequence(String seqName) {
        if (seq_Hash.containsKey(seqName)) {
            seq_Hash.remove(seqName);
        }
    }

    public static Integer random(Integer min, Integer max) {
        return Long.valueOf(Math.round((double)min.intValue() - 0.5 + Math.random() * (double)(max - min + 1))).intValue();
    }

    public static Float convertImpliedDecimalFormat(String format, String toConvert) {
        BigDecimal decimal = Numeric.convertString2BigDecimal(format, toConvert);
        return new Float(decimal.doubleValue());
    }

    public static BigDecimal convertString2BigDecimal(String format, String toConvert) {
        long decimalPlace = 1L;
        int indexOf = format.indexOf(86);
        if (indexOf > -1) {
            boolean isV = false;
            int i = 0;
            while (i < format.length()) {
                char charAt = format.charAt(i);
                if (charAt == '9' && isV) {
                    decimalPlace *= 10L;
                } else if (charAt == 'V') {
                    isV = true;
                }
                ++i;
            }
        }
        BigDecimal decimal = new BigDecimal(toConvert);
        decimal = decimal.divide(new BigDecimal(decimalPlace));
        return decimal;
    }
}

