/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.internal.util;

import com.liferay.commerce.user.util.CommerceRole;
import com.liferay.commerce.user.util.CommerceRoleRegistry;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.RoleLocalService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceRoleRegistry.class})
public class CommerceRoleRegistryImpl
implements CommerceRoleRegistry {
    @Reference
    private RoleLocalService _roleLocalService;
    private ServiceTrackerList<CommerceRole, CommerceRole> _serviceTrackerList;

    public List<Role> getRoles(long companyId) {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (CommerceRole commerceRole : this._serviceTrackerList) {
            Role role = this._roleLocalService.fetchRole(companyId, commerceRole.getRoleName());
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, CommerceRole.class);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }
}

