/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.service.impl;

import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.user.segment.exception.CommerceUserSegmentEntryKeyException;
import com.liferay.commerce.user.segment.exception.CommerceUserSegmentEntryNameException;
import com.liferay.commerce.user.segment.exception.CommerceUserSegmentEntrySystemException;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentEntry;
import com.liferay.commerce.user.segment.service.base.CommerceUserSegmentEntryLocalServiceBaseImpl;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;

public class CommerceUserSegmentEntryLocalServiceImpl
extends CommerceUserSegmentEntryLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    @ServiceReference(type=CommerceAccountLocalService.class)
    private CommerceAccountLocalService _commerceAccountLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceUserSegmentEntry addCommerceUserSegmentEntry(Map<Locale, String> nameMap, String key, boolean active, boolean system, double priority, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(0L, groupId, key, nameMap);
        long commerceUserSegmentEntryId = this.counterLocalService.increment();
        CommerceUserSegmentEntry commerceUserSegmentEntry = this.commerceUserSegmentEntryPersistence.create(commerceUserSegmentEntryId);
        commerceUserSegmentEntry.setGroupId(groupId);
        commerceUserSegmentEntry.setCompanyId(user.getCompanyId());
        commerceUserSegmentEntry.setUserId(user.getUserId());
        commerceUserSegmentEntry.setUserName(user.getFullName());
        commerceUserSegmentEntry.setNameMap(nameMap);
        commerceUserSegmentEntry.setKey(key);
        commerceUserSegmentEntry.setActive(active);
        commerceUserSegmentEntry.setSystem(system);
        commerceUserSegmentEntry.setPriority(priority);
        commerceUserSegmentEntry.setExpandoBridgeAttributes(serviceContext);
        this.commerceUserSegmentEntryPersistence.update((BaseModel)commerceUserSegmentEntry);
        this.resourceLocalService.addModelResources((AuditedModel)commerceUserSegmentEntry, serviceContext);
        this.commerceUserSegmentEntryLocalService.cleanUserSegmentsChache(commerceUserSegmentEntry.getGroupId());
        return commerceUserSegmentEntry;
    }

    public void cleanUserSegmentsChache(long groupId) {
        MultiVMPoolUtil.removePortalCache((String)("USER_SEGMENTS_" + groupId));
    }

    public void deleteCommerceUserSegmentEntries(long groupId) throws PortalException {
        List commerceUserSegmentEntries = this.commerceUserSegmentEntryPersistence.findByGroupId(groupId);
        for (CommerceUserSegmentEntry commerceUserSegmentEntry : commerceUserSegmentEntries) {
            this.commerceUserSegmentEntryLocalService.deleteCommerceUserSegmentEntry(commerceUserSegmentEntry.getCommerceUserSegmentEntryId());
        }
        this.commerceUserSegmentEntryLocalService.cleanUserSegmentsChache(groupId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceUserSegmentEntry deleteCommerceUserSegmentEntry(CommerceUserSegmentEntry commerceUserSegmentEntry) throws PortalException {
        if (commerceUserSegmentEntry.isSystem()) {
            throw new CommerceUserSegmentEntrySystemException();
        }
        this.commerceUserSegmentCriterionLocalService.deleteCommerceUserSegmentCriteria(commerceUserSegmentEntry.getCommerceUserSegmentEntryId());
        this.commerceUserSegmentEntryPersistence.remove((BaseModel)commerceUserSegmentEntry);
        this.resourceLocalService.deleteResource((AuditedModel)commerceUserSegmentEntry, 4);
        this.expandoRowLocalService.deleteRows(commerceUserSegmentEntry.getCommerceUserSegmentEntryId());
        this.commerceUserSegmentEntryLocalService.cleanUserSegmentsChache(commerceUserSegmentEntry.getGroupId());
        return commerceUserSegmentEntry;
    }

    @Override
    public CommerceUserSegmentEntry deleteCommerceUserSegmentEntry(long commerceUserSegmentEntryId) throws PortalException {
        CommerceUserSegmentEntry commerceUserSegmentEntry = this.commerceUserSegmentEntryPersistence.findByPrimaryKey(commerceUserSegmentEntryId);
        return this.commerceUserSegmentEntryLocalService.deleteCommerceUserSegmentEntry(commerceUserSegmentEntry);
    }

    public CommerceUserSegmentEntry fetchCommerceUserSegmentEntry(long groupId, String key) {
        return this.commerceUserSegmentEntryPersistence.fetchByG_K(groupId, key);
    }

    public List<CommerceUserSegmentEntry> getCommerceUserSegmentEntries(long groupId, int start, int end, OrderByComparator<CommerceUserSegmentEntry> orderByComparator) {
        return this.commerceUserSegmentEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public int getCommerceUserSegmentEntriesCount(long groupId) {
        return this.commerceUserSegmentEntryPersistence.countByGroupId(groupId);
    }

    public CommerceUserSegmentEntry getCommerceUserSegmentEntry(long groupId, String key) throws PortalException {
        return this.commerceUserSegmentEntryPersistence.findByG_K(groupId, key);
    }

    public long[] getCommerceUserSegmentEntryIds(long groupId, long commerceAccountId, long userId) throws PortalException {
        PortalCache portalCache = MultiVMPoolUtil.getPortalCache((String)("USER_SEGMENTS_" + groupId));
        String cacheKey = String.valueOf(commerceAccountId);
        long[] commerceUserSegmentEntryIds = (long[])portalCache.get((Serializable)((Object)cacheKey));
        boolean userSegmentsCalculated = GetterUtil.getBoolean((Object)portalCache.get((Serializable)((Object)(cacheKey + "_calculated"))));
        if (userSegmentsCalculated) {
            return commerceUserSegmentEntryIds;
        }
        Group group = this.groupLocalService.getGroup(groupId);
        SearchContext searchContext = this.buildSearchContext(group.getCompanyId(), groupId, commerceAccountId, userId);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceUserSegmentEntry.class);
        Hits hits = indexer.search(searchContext, new String[]{"entryClassPK"});
        List documents = hits.toList();
        Stream stream = documents.stream();
        commerceUserSegmentEntryIds = stream.mapToLong(field -> GetterUtil.getLong((String)field.get("entryClassPK"))).toArray();
        portalCache.put((Serializable)((Object)(cacheKey + "_calculated")), (Object)true);
        portalCache.put((Serializable)((Object)cacheKey), (Object)commerceUserSegmentEntryIds);
        return commerceUserSegmentEntryIds;
    }

    public void importSystemCommerceUserSegmentEntries(ServiceContext serviceContext) throws PortalException {
        this._addSystemCommerceUserSegmentEntry("guest", "Guest", serviceContext);
        this._addSystemCommerceUserSegmentEntry("user", "User", serviceContext);
    }

    public BaseModelSearchResult<CommerceUserSegmentEntry> searchCommerceUserSegmentEntries(long companyId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, keywords, start, end, sort);
        return this.commerceUserSegmentEntryLocalService.searchCommerceUserSegmentEntries(searchContext);
    }

    public BaseModelSearchResult<CommerceUserSegmentEntry> searchCommerceUserSegmentEntries(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceUserSegmentEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceUserSegmentEntry> commerceUserSegmentEntries = this.getCommerceUserSegmentEntries(hits);
            if (commerceUserSegmentEntries == null) continue;
            return new BaseModelSearchResult(commerceUserSegmentEntries, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceUserSegmentEntry updateCommerceUserSegmentEntry(long commerceUserSegmentEntryId, Map<Locale, String> nameMap, String key, boolean active, double priority, ServiceContext serviceContext) throws PortalException {
        CommerceUserSegmentEntry commerceUserSegmentEntry = this.commerceUserSegmentEntryPersistence.findByPrimaryKey(commerceUserSegmentEntryId);
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(commerceUserSegmentEntryId, commerceUserSegmentEntry.getGroupId(), key, nameMap);
        commerceUserSegmentEntry.setNameMap(nameMap);
        if (!commerceUserSegmentEntry.isSystem()) {
            commerceUserSegmentEntry.setKey(key);
            commerceUserSegmentEntry.setActive(active);
        }
        commerceUserSegmentEntry.setPriority(priority);
        commerceUserSegmentEntry.setExpandoBridgeAttributes(serviceContext);
        this.commerceUserSegmentEntryLocalService.cleanUserSegmentsChache(commerceUserSegmentEntry.getGroupId());
        return (CommerceUserSegmentEntry)this.commerceUserSegmentEntryPersistence.update((BaseModel)commerceUserSegmentEntry);
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, long commerceAccountId, long userId) {
        SearchContext searchContext = new SearchContext();
        HashMap<String, Comparable<Boolean>> attributes = new HashMap<String, Comparable<Boolean>>();
        attributes.put("active", Boolean.valueOf(true));
        attributes.put("commerceAccountId", Long.valueOf(commerceAccountId));
        attributes.put("criterionType", Boolean.valueOf(true));
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setStart(0);
        searchContext.setEnd(10);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setUserId(userId);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        Sort sort = SortFactoryUtil.create((String)"priority_Number_sortable", (boolean)true);
        searchContext.setSorts(new Sort[]{sort});
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("keywords", keywords);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", keywords);
        attributes.put("params", params);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setStart(start);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        return searchContext;
    }

    protected List<CommerceUserSegmentEntry> getCommerceUserSegmentEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceUserSegmentEntry> commerceUserSegmentEntries = new ArrayList<CommerceUserSegmentEntry>(documents.size());
        for (Document document : documents) {
            long commerceUserSegmentEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceUserSegmentEntry commerceUserSegmentEntry = this.fetchCommerceUserSegmentEntry(commerceUserSegmentEntryId);
            if (commerceUserSegmentEntry == null) {
                commerceUserSegmentEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceUserSegmentEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceUserSegmentEntries == null) continue;
            commerceUserSegmentEntries.add(commerceUserSegmentEntry);
        }
        return commerceUserSegmentEntries;
    }

    protected void validate(long commerceUserSegmentEntryId, long groupId, String key, Map<Locale, String> nameMap) throws PortalException {
        CommerceUserSegmentEntry commerceUserSegmentEntry = this.commerceUserSegmentEntryPersistence.fetchByG_K(groupId, key);
        if (commerceUserSegmentEntry != null && commerceUserSegmentEntry.getCommerceUserSegmentEntryId() != commerceUserSegmentEntryId) {
            throw new CommerceUserSegmentEntryKeyException();
        }
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new CommerceUserSegmentEntryNameException();
        }
    }

    private void _addSystemCommerceUserSegmentEntry(String key, String roleName, ServiceContext serviceContext) throws PortalException {
        CommerceUserSegmentEntry commerceUserSegmentEntry = this.commerceUserSegmentEntryPersistence.fetchByG_K(serviceContext.getScopeGroupId(), key);
        if (commerceUserSegmentEntry != null) {
            return;
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(serviceContext.getLocale(), key);
        commerceUserSegmentEntry = this.commerceUserSegmentEntryLocalService.addCommerceUserSegmentEntry(nameMap, key, true, true, 0.0, serviceContext);
        Role role = this.roleLocalService.getRole(serviceContext.getCompanyId(), roleName);
        this.commerceUserSegmentCriterionLocalService.addCommerceUserSegmentCriterion(commerceUserSegmentEntry.getCommerceUserSegmentEntryId(), "role", String.valueOf(role.getRoleId()), 0.0, serviceContext);
    }
}

