/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.internal.criterion;

import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.internal.criterion.BaseCommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentCriterion;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.user.segment.criterion.type.key=user", "commerce.user.segment.criterion.type.order:Integer=10"}, service={CommerceUserSegmentCriterionType.class})
public class UserCommerceUserSegmentCriterionTypeImpl
extends BaseCommerceUserSegmentCriterionType {
    @Reference
    private UserLocalService _userLocalService;

    public String getKey() {
        return "user";
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"users");
    }

    public String getPreview(CommerceUserSegmentCriterion commerceUserSegmentCriterion, int length) {
        String[] userIds;
        if (length <= 0) {
            return "";
        }
        ArrayList<String> userNames = new ArrayList<String>();
        for (String userId : userIds = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings())) {
            User user = this._userLocalService.fetchUser(GetterUtil.getLong((String)userId));
            if (user == null) continue;
            userNames.add(user.getFullName());
        }
        String preview = StringUtil.merge(userNames, (String)", ");
        return StringUtil.shorten((String)preview, (int)length, (String)"...");
    }

    public void userPostProcessContextBooleanFilter(CommerceUserSegmentCriterion commerceUserSegmentCriterion, BooleanFilter contextBooleanFilter, SearchContext searchContext) {
        Object[] userIds = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings());
        TermsFilter userFilter = new TermsFilter("entryClassPK");
        userFilter.addValues(ArrayUtil.toStringArray((Object[])userIds));
        contextBooleanFilter.add((Filter)userFilter, BooleanClauseOccur.MUST);
    }

    @Override
    protected long[] getUserClassPKs(User user) throws PortalException {
        return new long[]{user.getUserId()};
    }
}

