/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.internal.criterion;

import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.internal.criterion.BaseCommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentCriterion;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.user.segment.criterion.type.key=user_group", "commerce.user.segment.criterion.type.order:Integer=30"}, service={CommerceUserSegmentCriterionType.class})
public class UserGroupCommerceUserSegmentCriterionTypeImpl
extends BaseCommerceUserSegmentCriterionType {
    @Reference
    private UserGroupLocalService _userGroupLocalService;

    public String getKey() {
        return "user_group";
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"user-groups");
    }

    public String getPreview(CommerceUserSegmentCriterion commerceUserSegmentCriterion, int length) {
        String[] userGroupIds;
        if (length <= 0) {
            return "";
        }
        ArrayList<String> userGroupNames = new ArrayList<String>();
        for (String userGroupId : userGroupIds = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings())) {
            UserGroup userGroup = this._userGroupLocalService.fetchUserGroup(GetterUtil.getLong((String)userGroupId));
            if (userGroup == null) continue;
            userGroupNames.add(userGroup.getName());
        }
        String preview = StringUtil.merge(userGroupNames, (String)", ");
        return StringUtil.shorten((String)preview, (int)length, (String)"...");
    }

    public void userPostProcessContextBooleanFilter(CommerceUserSegmentCriterion commerceUserSegmentCriterion, BooleanFilter contextBooleanFilter, SearchContext searchContext) {
        String[] userGroupIds = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings());
        BooleanFilter booleanFilter = new BooleanFilter();
        for (String userGroupId : userGroupIds) {
            TermFilter termFilter = new TermFilter("userGroupIds", userGroupId);
            booleanFilter.add((Filter)termFilter, BooleanClauseOccur.MUST);
        }
        contextBooleanFilter.add((Filter)booleanFilter, BooleanClauseOccur.MUST);
    }

    @Override
    protected long[] getUserClassPKs(User user) throws PortalException {
        return user.getUserGroupIds();
    }
}

