/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.user.segment.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.user.segment.model.CommerceUserSegmentEntry;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentEntryLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceUserSegmentEntry service. Represents a row in the &quot;CommerceUserSegmentEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceUserSegmentEntryImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceUserSegmentEntryImpl
 * @see CommerceUserSegmentEntry
 * @generated
 */
@ProviderType
public abstract class CommerceUserSegmentEntryBaseImpl
	extends CommerceUserSegmentEntryModelImpl
	implements CommerceUserSegmentEntry {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce user segment entry model instance should use the {@link CommerceUserSegmentEntry} interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceUserSegmentEntryLocalServiceUtil.addCommerceUserSegmentEntry(this);
		}
		else {
			CommerceUserSegmentEntryLocalServiceUtil.updateCommerceUserSegmentEntry(this);
		}
	}
}