/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.user.segment.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.user.segment.model.CommerceUserSegmentCriterion;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentCriterionLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceUserSegmentCriterion service. Represents a row in the &quot;CommerceUserSegmentCriterion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceUserSegmentCriterionImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceUserSegmentCriterionImpl
 * @see CommerceUserSegmentCriterion
 * @generated
 */
@ProviderType
public abstract class CommerceUserSegmentCriterionBaseImpl
	extends CommerceUserSegmentCriterionModelImpl
	implements CommerceUserSegmentCriterion {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce user segment criterion model instance should use the {@link CommerceUserSegmentCriterion} interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceUserSegmentCriterionLocalServiceUtil.addCommerceUserSegmentCriterion(this);
		}
		else {
			CommerceUserSegmentCriterionLocalServiceUtil.updateCommerceUserSegmentCriterion(this);
		}
	}
}