/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.service.impl;

import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionTypeRegistry;
import com.liferay.commerce.user.segment.exception.CommerceUserSegmentCriterionTypeException;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentCriterion;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentEntry;
import com.liferay.commerce.user.segment.service.base.CommerceUserSegmentCriterionLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceUserSegmentCriterionLocalServiceImpl
extends CommerceUserSegmentCriterionLocalServiceBaseImpl {
    @ServiceReference(type=CommerceUserSegmentCriterionTypeRegistry.class)
    private CommerceUserSegmentCriterionTypeRegistry _commerceUserSegmentCriterionTypeRegistry;

    public CommerceUserSegmentCriterion addCommerceUserSegmentCriterion(long commerceUserSegmentEntryId, String type, String typeSettings, double priority, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        this.validate(type);
        long commerceUserSegmentCriterionId = this.counterLocalService.increment();
        CommerceUserSegmentCriterion commerceUserSegmentCriterion = this.commerceUserSegmentCriterionPersistence.create(commerceUserSegmentCriterionId);
        commerceUserSegmentCriterion.setGroupId(groupId);
        commerceUserSegmentCriterion.setCompanyId(user.getCompanyId());
        commerceUserSegmentCriterion.setUserId(user.getUserId());
        commerceUserSegmentCriterion.setUserName(user.getFullName());
        commerceUserSegmentCriterion.setCommerceUserSegmentEntryId(commerceUserSegmentEntryId);
        commerceUserSegmentCriterion.setType(type);
        commerceUserSegmentCriterion.setTypeSettings(typeSettings);
        commerceUserSegmentCriterion.setPriority(priority);
        commerceUserSegmentCriterion.setExpandoBridgeAttributes(serviceContext);
        this.commerceUserSegmentCriterionPersistence.update((BaseModel)commerceUserSegmentCriterion);
        this.reindexCommerceUserSegmentEntry(commerceUserSegmentCriterion);
        this.commerceUserSegmentEntryLocalService.cleanUserSegmentsCache(serviceContext.getScopeGroupId());
        return commerceUserSegmentCriterion;
    }

    public void deleteCommerceUserSegmentCriteria(long commerceUserSegmentEntryId) throws PortalException {
        this.commerceUserSegmentCriterionPersistence.removeByCommerceUserSegmentEntryId(commerceUserSegmentEntryId);
    }

    @Override
    @SystemEvent(type=1)
    public CommerceUserSegmentCriterion deleteCommerceUserSegmentCriterion(CommerceUserSegmentCriterion commerceUserSegmentCriterion) throws PortalException {
        this.commerceUserSegmentCriterionPersistence.remove((BaseModel)commerceUserSegmentCriterion);
        this.expandoRowLocalService.deleteRows(commerceUserSegmentCriterion.getCommerceUserSegmentCriterionId());
        this.reindexCommerceUserSegmentEntry(commerceUserSegmentCriterion);
        this.commerceUserSegmentEntryLocalService.cleanUserSegmentsCache(commerceUserSegmentCriterion.getGroupId());
        return commerceUserSegmentCriterion;
    }

    @Override
    public CommerceUserSegmentCriterion deleteCommerceUserSegmentCriterion(long commerceUserSegmentCriterionId) throws PortalException {
        CommerceUserSegmentCriterion commerceUserSegmentCriterion = this.commerceUserSegmentCriterionPersistence.findByPrimaryKey(commerceUserSegmentCriterionId);
        return this.commerceUserSegmentCriterionLocalService.deleteCommerceUserSegmentCriterion(commerceUserSegmentCriterion);
    }

    public List<CommerceUserSegmentCriterion> getCommerceUserSegmentCriteria(long commerceUserSegmentEntryId, int start, int end, OrderByComparator<CommerceUserSegmentCriterion> orderByComparator) {
        return this.commerceUserSegmentCriterionPersistence.findByCommerceUserSegmentEntryId(commerceUserSegmentEntryId, start, end, orderByComparator);
    }

    public int getCommerceUserSegmentCriteriaCount(long commerceUserSegmentEntryId) {
        return this.commerceUserSegmentCriterionPersistence.countByCommerceUserSegmentEntryId(commerceUserSegmentEntryId);
    }

    public CommerceUserSegmentCriterion updateCommerceUserSegmentCriterion(long commerceUserSegmentCriterionId, String type, String typeSettings, double priority, ServiceContext serviceContext) throws PortalException {
        CommerceUserSegmentCriterion commerceUserSegmentCriterion = this.commerceUserSegmentCriterionPersistence.findByPrimaryKey(commerceUserSegmentCriterionId);
        this.validate(type);
        commerceUserSegmentCriterion.setType(type);
        commerceUserSegmentCriterion.setTypeSettings(typeSettings);
        commerceUserSegmentCriterion.setPriority(priority);
        commerceUserSegmentCriterion.setExpandoBridgeAttributes(serviceContext);
        this.commerceUserSegmentCriterionPersistence.update((BaseModel)commerceUserSegmentCriterion);
        this.reindexCommerceUserSegmentEntry(commerceUserSegmentCriterion);
        this.commerceUserSegmentEntryLocalService.cleanUserSegmentsCache(commerceUserSegmentCriterion.getGroupId());
        return commerceUserSegmentCriterion;
    }

    protected void reindexCommerceUserSegmentEntry(CommerceUserSegmentCriterion commerceUserSegmentCriterion) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceUserSegmentEntry.class);
        indexer.reindex(CommerceUserSegmentEntry.class.getName(), commerceUserSegmentCriterion.getCommerceUserSegmentEntryId());
    }

    protected void validate(String type) throws PortalException {
        CommerceUserSegmentCriterionType commerceUserSegmentCriterionType = this._commerceUserSegmentCriterionTypeRegistry.getCommerceUserSegmentCriterionType(type);
        if (commerceUserSegmentCriterionType == null) {
            throw new CommerceUserSegmentCriterionTypeException();
        }
    }
}

