/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.theme.speedwell.site.initializer.internal.dependencies.resolver;

import com.liferay.portal.kernel.util.StringUtil;

import java.io.IOException;

import org.osgi.service.component.annotations.Component;

/**
 * @author Marco Leo
 */
@Component(immediate = true, service = SpeedwellDependencyResolver.class)
public class SpeedwellDependencyResolver {

	public String getDependenciesPath() {
		return _DEPENDENCIES_PATH;
	}

	public ClassLoader getDisplayTemplatesClassLoader() {
		return SpeedwellDependencyResolver.class.getClassLoader();
	}

	public String getDisplayTemplatesDependencyPath() {
		return _DEPENDENCIES_PATH + "display_templates/";
	}

	public ClassLoader getDocumentsClassLoader() {
		return SpeedwellDependencyResolver.class.getClassLoader();
	}

	public String getDocumentsDependencyPath() {
		return _DEPENDENCIES_PATH + "documents/";
	}

	public ClassLoader getImageClassLoader() {
		return SpeedwellDependencyResolver.class.getClassLoader();
	}

	public String getImageDependencyPath() {
		return _DEPENDENCIES_PATH + "images/";
	}

	public String getJSON(String name) throws IOException {
		return StringUtil.read(
			SpeedwellDependencyResolver.class.getClassLoader(),
			_DEPENDENCIES_PATH + name);
	}

	private static final String _DEPENDENCIES_PATH =
		"com/liferay/commerce/theme/speedwell/site/initializer/internal" +
			"/dependencies/";

}