/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.term.model.impl;

import com.liferay.commerce.term.model.CommerceTermEntryRel;
import com.liferay.commerce.term.model.CommerceTermEntryRelModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceTermEntryRel service. Represents a row in the &quot;CommerceTermEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceTermEntryRelModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceTermEntryRelImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceTermEntryRelImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceTermEntryRelModelImpl
	extends BaseModelImpl<CommerceTermEntryRel>
	implements CommerceTermEntryRelModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce term entry rel model instance should use the <code>CommerceTermEntryRel</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceTermEntryRel";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"commerceTermEntryRelId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"commerceTermEntryId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceTermEntryRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceTermEntryId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceTermEntryRel (mvccVersion LONG default 0 not null,commerceTermEntryRelId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,commerceTermEntryId LONG)";

	public static final String TABLE_SQL_DROP =
		"drop table CommerceTermEntryRel";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceTermEntryRel.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceTermEntryRel.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCETERMENTRYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommerceTermEntryRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceTermEntryRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceTermEntryRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceTermEntryRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceTermEntryRel.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceTermEntryRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceTermEntryRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceTermEntryRel, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceTermEntryRel, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceTermEntryRel)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceTermEntryRel, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceTermEntryRel, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceTermEntryRel)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceTermEntryRel, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceTermEntryRel, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceTermEntryRel>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceTermEntryRel.class.getClassLoader(),
			CommerceTermEntryRel.class, ModelWrapper.class);

		try {
			Constructor<CommerceTermEntryRel> constructor =
				(Constructor<CommerceTermEntryRel>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<CommerceTermEntryRel, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceTermEntryRel, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceTermEntryRel, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceTermEntryRel, Object>>();
		Map<String, BiConsumer<CommerceTermEntryRel, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceTermEntryRel, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", CommerceTermEntryRel::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<CommerceTermEntryRel, Long>)
				CommerceTermEntryRel::setMvccVersion);
		attributeGetterFunctions.put(
			"commerceTermEntryRelId",
			CommerceTermEntryRel::getCommerceTermEntryRelId);
		attributeSetterBiConsumers.put(
			"commerceTermEntryRelId",
			(BiConsumer<CommerceTermEntryRel, Long>)
				CommerceTermEntryRel::setCommerceTermEntryRelId);
		attributeGetterFunctions.put(
			"companyId", CommerceTermEntryRel::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceTermEntryRel, Long>)
				CommerceTermEntryRel::setCompanyId);
		attributeGetterFunctions.put("userId", CommerceTermEntryRel::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceTermEntryRel, Long>)
				CommerceTermEntryRel::setUserId);
		attributeGetterFunctions.put(
			"userName", CommerceTermEntryRel::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceTermEntryRel, String>)
				CommerceTermEntryRel::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceTermEntryRel::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceTermEntryRel, Date>)
				CommerceTermEntryRel::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceTermEntryRel::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceTermEntryRel, Date>)
				CommerceTermEntryRel::setModifiedDate);
		attributeGetterFunctions.put(
			"classNameId", CommerceTermEntryRel::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<CommerceTermEntryRel, Long>)
				CommerceTermEntryRel::setClassNameId);
		attributeGetterFunctions.put(
			"classPK", CommerceTermEntryRel::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK",
			(BiConsumer<CommerceTermEntryRel, Long>)
				CommerceTermEntryRel::setClassPK);
		attributeGetterFunctions.put(
			"commerceTermEntryId",
			CommerceTermEntryRel::getCommerceTermEntryId);
		attributeSetterBiConsumers.put(
			"commerceTermEntryId",
			(BiConsumer<CommerceTermEntryRel, Long>)
				CommerceTermEntryRel::setCommerceTermEntryId);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCommerceTermEntryRelId() {
		return _commerceTermEntryRelId;
	}

	@Override
	public void setCommerceTermEntryRelId(long commerceTermEntryRelId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceTermEntryRelId = commerceTermEntryRelId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public long getCommerceTermEntryId() {
		return _commerceTermEntryId;
	}

	@Override
	public void setCommerceTermEntryId(long commerceTermEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceTermEntryId = commerceTermEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceTermEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceTermEntryId"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceTermEntryRel.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceTermEntryRel toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceTermEntryRel>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceTermEntryRelImpl commerceTermEntryRelImpl =
			new CommerceTermEntryRelImpl();

		commerceTermEntryRelImpl.setMvccVersion(getMvccVersion());
		commerceTermEntryRelImpl.setCommerceTermEntryRelId(
			getCommerceTermEntryRelId());
		commerceTermEntryRelImpl.setCompanyId(getCompanyId());
		commerceTermEntryRelImpl.setUserId(getUserId());
		commerceTermEntryRelImpl.setUserName(getUserName());
		commerceTermEntryRelImpl.setCreateDate(getCreateDate());
		commerceTermEntryRelImpl.setModifiedDate(getModifiedDate());
		commerceTermEntryRelImpl.setClassNameId(getClassNameId());
		commerceTermEntryRelImpl.setClassPK(getClassPK());
		commerceTermEntryRelImpl.setCommerceTermEntryId(
			getCommerceTermEntryId());

		commerceTermEntryRelImpl.resetOriginalValues();

		return commerceTermEntryRelImpl;
	}

	@Override
	public CommerceTermEntryRel cloneWithOriginalValues() {
		CommerceTermEntryRelImpl commerceTermEntryRelImpl =
			new CommerceTermEntryRelImpl();

		commerceTermEntryRelImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceTermEntryRelImpl.setCommerceTermEntryRelId(
			this.<Long>getColumnOriginalValue("commerceTermEntryRelId"));
		commerceTermEntryRelImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceTermEntryRelImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceTermEntryRelImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceTermEntryRelImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceTermEntryRelImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceTermEntryRelImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		commerceTermEntryRelImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		commerceTermEntryRelImpl.setCommerceTermEntryId(
			this.<Long>getColumnOriginalValue("commerceTermEntryId"));

		return commerceTermEntryRelImpl;
	}

	@Override
	public int compareTo(CommerceTermEntryRel commerceTermEntryRel) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceTermEntryRel.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceTermEntryRel)) {
			return false;
		}

		CommerceTermEntryRel commerceTermEntryRel =
			(CommerceTermEntryRel)object;

		long primaryKey = commerceTermEntryRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceTermEntryRel> toCacheModel() {
		CommerceTermEntryRelCacheModel commerceTermEntryRelCacheModel =
			new CommerceTermEntryRelCacheModel();

		commerceTermEntryRelCacheModel.mvccVersion = getMvccVersion();

		commerceTermEntryRelCacheModel.commerceTermEntryRelId =
			getCommerceTermEntryRelId();

		commerceTermEntryRelCacheModel.companyId = getCompanyId();

		commerceTermEntryRelCacheModel.userId = getUserId();

		commerceTermEntryRelCacheModel.userName = getUserName();

		String userName = commerceTermEntryRelCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceTermEntryRelCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceTermEntryRelCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceTermEntryRelCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceTermEntryRelCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceTermEntryRelCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceTermEntryRelCacheModel.classNameId = getClassNameId();

		commerceTermEntryRelCacheModel.classPK = getClassPK();

		commerceTermEntryRelCacheModel.commerceTermEntryId =
			getCommerceTermEntryId();

		return commerceTermEntryRelCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceTermEntryRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceTermEntryRel, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceTermEntryRel, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceTermEntryRel)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceTermEntryRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceTermEntryRel, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceTermEntryRel, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((CommerceTermEntryRel)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceTermEntryRel>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _commerceTermEntryRelId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private long _commerceTermEntryId;

	public <T> T getColumnValue(String columnName) {
		Function<CommerceTermEntryRel, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceTermEntryRel)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"commerceTermEntryRelId", _commerceTermEntryRelId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("commerceTermEntryId", _commerceTermEntryId);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("commerceTermEntryRelId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("classNameId", 128L);

		columnBitmasks.put("classPK", 256L);

		columnBitmasks.put("commerceTermEntryId", 512L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceTermEntryRel _escapedModel;

}