/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.term.service.impl;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRelQualifierTable;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionQualifierTable;
import com.liferay.commerce.term.exception.CommerceTermEntryDisplayDateException;
import com.liferay.commerce.term.exception.CommerceTermEntryExpirationDateException;
import com.liferay.commerce.term.exception.CommerceTermEntryNameException;
import com.liferay.commerce.term.exception.CommerceTermEntryPriorityException;
import com.liferay.commerce.term.exception.CommerceTermEntryTypeException;
import com.liferay.commerce.term.model.CTermEntryLocalization;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.model.CommerceTermEntryRelTable;
import com.liferay.commerce.term.model.CommerceTermEntryTable;
import com.liferay.commerce.term.service.CommerceTermEntryRelLocalService;
import com.liferay.commerce.term.service.base.CommerceTermEntryLocalServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.term.model.CommerceTermEntry"}, service={AopService.class})
public class CommerceTermEntryLocalServiceImpl
extends CommerceTermEntryLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId"};
    private static final Log _log = LogFactoryUtil.getLog(CommerceTermEntryLocalServiceImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;
    @Reference
    private CommerceTermEntryRelLocalService _commerceTermEntryRelLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTermEntry addCommerceTermEntry(String externalReferenceCode, long userId, boolean active, Map<Locale, String> descriptionMap, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> labelMap, String name, double priority, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        name = FriendlyURLNormalizerUtil.normalize((String)name);
        this._validate(null, serviceContext.getCompanyId(), name, priority, type);
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryPersistence.create(this.counterLocalService.increment());
        commerceTermEntry.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        commerceTermEntry.setCompanyId(user.getCompanyId());
        commerceTermEntry.setUserId(user.getUserId());
        commerceTermEntry.setUserName(user.getFullName());
        commerceTermEntry.setActive(active);
        commerceTermEntry.setDisplayDate(this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommerceTermEntryDisplayDateException.class));
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommerceTermEntryExpirationDateException.class);
        }
        commerceTermEntry.setExpirationDate(expirationDate);
        commerceTermEntry.setName(name);
        commerceTermEntry.setPriority(priority);
        commerceTermEntry.setType(type);
        commerceTermEntry.setTypeSettingsUnicodeProperties(UnicodePropertiesBuilder.fastLoad((String)typeSettings).build());
        Date date = new Date();
        if (expirationDate == null || expirationDate.after(date)) {
            commerceTermEntry.setStatus(2);
        } else {
            commerceTermEntry.setStatus(3);
        }
        commerceTermEntry.setStatusByUserId(user.getUserId());
        commerceTermEntry.setStatusDate(serviceContext.getModifiedDate(date));
        commerceTermEntry = (CommerceTermEntry)this.commerceTermEntryPersistence.update((BaseModel)commerceTermEntry);
        this._addCommerceTermEntryLocalizedFields(user.getCompanyId(), commerceTermEntry.getCommerceTermEntryId(), descriptionMap, labelMap);
        this._resourceLocalService.addModelResources((AuditedModel)commerceTermEntry, serviceContext);
        return this._startWorkflowInstance(user.getUserId(), commerceTermEntry, serviceContext);
    }

    public void checkCommerceTermEntries() throws PortalException {
        this._checkCommerceTermEntriesByDisplayDate();
        this._checkCommerceTermEntriesByExpirationDate();
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceTermEntry deleteCommerceTermEntry(CommerceTermEntry commerceTermEntry) throws PortalException {
        commerceTermEntry = (CommerceTermEntry)this.commerceTermEntryPersistence.remove((BaseModel)commerceTermEntry);
        this._resourceLocalService.deleteResource(commerceTermEntry.getCompanyId(), CommerceTermEntry.class.getName(), 4, commerceTermEntry.getCommerceTermEntryId());
        this._commerceChannelAccountEntryRelLocalService.deleteCommerceChannelAccountEntryRels(CommerceTermEntry.class.getName(), commerceTermEntry.getCommerceTermEntryId());
        this._commerceTermEntryRelLocalService.deleteCommerceTermEntryRels(commerceTermEntry.getCommerceTermEntryId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceTermEntry.getCompanyId(), 0L, CommerceTermEntry.class.getName(), commerceTermEntry.getCommerceTermEntryId());
        return commerceTermEntry;
    }

    @Override
    public CommerceTermEntry deleteCommerceTermEntry(long commerceTermEntryId) throws PortalException {
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryPersistence.findByPrimaryKey(commerceTermEntryId);
        return this.commerceTermEntryLocalService.deleteCommerceTermEntry(commerceTermEntry);
    }

    public List<CommerceTermEntry> getCommerceTermEntries(long companyId, String type) {
        return this.commerceTermEntryPersistence.findByC_A_LikeType(companyId, true, type);
    }

    public List<String> getCTermEntryLocalizationLanguageIds(long commerceTermEntryId) {
        return TransformUtil.transform((Collection)this.cTermEntryLocalizationPersistence.findByCommerceTermEntryId(commerceTermEntryId), cTermEntryLocalization -> cTermEntryLocalization.getLanguageId());
    }

    public List<CommerceTermEntry> getDeliveryCommerceTermEntries(long companyId, long commerceOrderTypeId, long commerceShippingOptionId) {
        LinkedList<CommerceTermEntry> commerceTermEntries = new LinkedList<CommerceTermEntry>();
        commerceTermEntries.addAll((Collection)this.dslQuery((DSLQuery)this._getDeliveryTermsEntryGroupByStep(companyId, commerceOrderTypeId > 0L ? Long.valueOf(commerceOrderTypeId) : null, commerceShippingOptionId, DSLQueryFactoryUtil.selectDistinct((Table)CommerceTermEntryTable.INSTANCE)).orderBy(new OrderByExpression[]{CommerceTermEntryTable.INSTANCE.priority.descending()})));
        if (commerceOrderTypeId > 0L && commerceTermEntries.isEmpty()) {
            commerceTermEntries.addAll((Collection)this.dslQuery((DSLQuery)this._getDeliveryTermsEntryGroupByStep(companyId, null, commerceShippingOptionId, DSLQueryFactoryUtil.selectDistinct((Table)CommerceTermEntryTable.INSTANCE)).orderBy(new OrderByExpression[]{CommerceTermEntryTable.INSTANCE.priority.descending()})));
        }
        return commerceTermEntries;
    }

    public int getDeliveryCommerceTermEntriesCount(long companyId, long commerceOrderTypeId, long commerceShippingOptionId) {
        int count = this.dslQueryCount((DSLQuery)this._getDeliveryTermsEntryGroupByStep(companyId, commerceOrderTypeId > 0L ? Long.valueOf(commerceOrderTypeId) : null, commerceShippingOptionId, DSLQueryFactoryUtil.countDistinct((Expression)CommerceTermEntryTable.INSTANCE.commerceTermEntryId)));
        if (commerceOrderTypeId > 0L && count == 0) {
            count = this.dslQueryCount((DSLQuery)this._getDeliveryTermsEntryGroupByStep(companyId, null, commerceShippingOptionId, DSLQueryFactoryUtil.countDistinct((Expression)CommerceTermEntryTable.INSTANCE.commerceTermEntryId)));
        }
        return count;
    }

    public List<CommerceTermEntry> getPaymentCommerceTermEntries(long companyId, long commerceOrderTypeId, long commercePaymentMethodGroupRelId) {
        LinkedList<CommerceTermEntry> commerceTermEntries = new LinkedList<CommerceTermEntry>();
        commerceTermEntries.addAll((Collection)this.dslQuery((DSLQuery)this._getPaymentTermsEntryGroupByStep(companyId, commerceOrderTypeId > 0L ? Long.valueOf(commerceOrderTypeId) : null, commercePaymentMethodGroupRelId, DSLQueryFactoryUtil.selectDistinct((Table)CommerceTermEntryTable.INSTANCE)).orderBy(new OrderByExpression[]{CommerceTermEntryTable.INSTANCE.priority.descending()})));
        if (commerceOrderTypeId > 0L && commerceTermEntries.isEmpty()) {
            commerceTermEntries.addAll((Collection)this.dslQuery((DSLQuery)this._getPaymentTermsEntryGroupByStep(companyId, null, commercePaymentMethodGroupRelId, DSLQueryFactoryUtil.selectDistinct((Table)CommerceTermEntryTable.INSTANCE)).orderBy(new OrderByExpression[]{CommerceTermEntryTable.INSTANCE.priority.descending()})));
        }
        return commerceTermEntries;
    }

    public int getPaymentCommerceTermEntriesCount(long companyId, long commerceOrderTypeId, long commercePaymentMethodGroupRelId) {
        int count = this.dslQueryCount((DSLQuery)this._getPaymentTermsEntryGroupByStep(companyId, commerceOrderTypeId > 0L ? Long.valueOf(commerceOrderTypeId) : null, commercePaymentMethodGroupRelId, DSLQueryFactoryUtil.countDistinct((Expression)CommerceTermEntryTable.INSTANCE.commerceTermEntryId)));
        if (commerceOrderTypeId > 0L && count == 0) {
            count = this.dslQueryCount((DSLQuery)this._getPaymentTermsEntryGroupByStep(companyId, null, commercePaymentMethodGroupRelId, DSLQueryFactoryUtil.countDistinct((Expression)CommerceTermEntryTable.INSTANCE.commerceTermEntryId)));
        }
        return count;
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceTermEntry.class);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public BaseModelSearchResult<CommerceTermEntry> searchCommerceTermEntries(long companyId, long accountEntryId, String type, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, accountEntryId, type, keywords, start, end, sort);
        return this._searchCommerceTermEntries(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTermEntry updateCommerceTermEntry(long userId, long commerceTermEntryId, boolean active, Map<Locale, String> descriptionMap, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> labelMap, String name, double priority, String typeSettings, ServiceContext serviceContext) throws PortalException {
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryLocalService.getCommerceTermEntry(commerceTermEntryId);
        this._validate(commerceTermEntry, serviceContext.getCompanyId(), name, priority, commerceTermEntry.getType());
        commerceTermEntry.setActive(active);
        User user = this._userLocalService.getUser(userId);
        commerceTermEntry.setDisplayDate(this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommerceTermEntryDisplayDateException.class));
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommerceTermEntryExpirationDateException.class);
        }
        commerceTermEntry.setExpirationDate(expirationDate);
        commerceTermEntry.setName(name);
        commerceTermEntry.setPriority(priority);
        commerceTermEntry.setTypeSettingsUnicodeProperties(UnicodePropertiesBuilder.fastLoad((String)typeSettings).build());
        Date date = new Date();
        if (expirationDate == null || expirationDate.after(date)) {
            commerceTermEntry.setStatus(2);
        } else {
            commerceTermEntry.setStatus(3);
        }
        commerceTermEntry.setStatusByUserId(user.getUserId());
        commerceTermEntry.setStatusDate(serviceContext.getModifiedDate(date));
        commerceTermEntry.setExpandoBridgeAttributes(serviceContext);
        commerceTermEntry = (CommerceTermEntry)this.commerceTermEntryPersistence.update((BaseModel)commerceTermEntry);
        this._updateCommerceTermEntryLocalizedFields(user.getCompanyId(), commerceTermEntryId, descriptionMap, labelMap);
        return this._startWorkflowInstance(user.getUserId(), commerceTermEntry, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTermEntry updateCommerceTermEntryExternalReferenceCode(String externalReferenceCode, long commerceTermEntryId) throws PortalException {
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryPersistence.findByPrimaryKey(commerceTermEntryId);
        commerceTermEntry.setExternalReferenceCode(externalReferenceCode);
        return (CommerceTermEntry)this.commerceTermEntryPersistence.update((BaseModel)commerceTermEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTermEntry updateStatus(long userId, long commerceTermEntryId, int status, ServiceContext serviceContext) throws PortalException {
        Date expirationDate;
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryPersistence.findByPrimaryKey(commerceTermEntryId);
        Date date = new Date();
        if (status == 0 && commerceTermEntry.getDisplayDate() != null && date.before(commerceTermEntry.getDisplayDate())) {
            status = 7;
        }
        if (status == 0 && (expirationDate = commerceTermEntry.getExpirationDate()) != null && expirationDate.before(date)) {
            commerceTermEntry.setExpirationDate(null);
        }
        if (status == 3) {
            commerceTermEntry.setActive(false);
            commerceTermEntry.setExpirationDate(date);
        }
        commerceTermEntry.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        commerceTermEntry.setStatusByUserId(user.getUserId());
        commerceTermEntry.setStatusByUserName(user.getFullName());
        commerceTermEntry.setStatusDate(serviceContext.getModifiedDate(date));
        return (CommerceTermEntry)this.commerceTermEntryPersistence.update((BaseModel)commerceTermEntry);
    }

    private List<CTermEntryLocalization> _addCommerceTermEntryLocalizedFields(long companyId, long commerceTermEntryId, Map<Locale, String> descriptionMap, Map<Locale, String> labelMap) {
        HashSet<Locale> locales = new HashSet<Locale>();
        if (descriptionMap != null) {
            locales.addAll(descriptionMap.keySet());
        }
        if (labelMap != null) {
            locales.addAll(labelMap.keySet());
        }
        return TransformUtil.transform(locales, locale -> {
            String description = null;
            String label = null;
            if (descriptionMap != null) {
                description = (String)descriptionMap.get(locale);
            }
            if (labelMap != null) {
                label = (String)labelMap.get(locale);
            }
            if (Validator.isNull(description) && Validator.isNull((String)label)) {
                return null;
            }
            return this._addCommerceTermEntryLocalizedFields(companyId, commerceTermEntryId, description, label, LocaleUtil.toLanguageId((Locale)locale));
        });
    }

    private CTermEntryLocalization _addCommerceTermEntryLocalizedFields(long companyId, long commerceTermEntryId, String description, String label, String languageId) {
        CTermEntryLocalization cTermEntryLocalization = this.cTermEntryLocalizationPersistence.fetchByCommerceTermEntryId_LanguageId(commerceTermEntryId, languageId);
        if (cTermEntryLocalization == null) {
            cTermEntryLocalization = this.cTermEntryLocalizationPersistence.create(this.counterLocalService.increment());
            cTermEntryLocalization.setCompanyId(companyId);
            cTermEntryLocalization.setCommerceTermEntryId(commerceTermEntryId);
            cTermEntryLocalization.setLanguageId(languageId);
            cTermEntryLocalization.setDescription(description);
            cTermEntryLocalization.setLabel(label);
        } else {
            cTermEntryLocalization.setDescription(description);
            cTermEntryLocalization.setLabel(label);
        }
        return (CTermEntryLocalization)this.cTermEntryLocalizationPersistence.update((BaseModel)cTermEntryLocalization);
    }

    private SearchContext _buildSearchContext(long companyId, long accountEntryId, String type, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"name", (Object)keywords).put((Object)"type", (Object)type).put((Object)"accountEntryId", (Object)accountEntryId).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private void _checkCommerceTermEntriesByDisplayDate() throws PortalException {
        List commerceTermEntries = this.commerceTermEntryPersistence.findByLtD_S(new Date(), 7);
        for (CommerceTermEntry commerceTermEntry : commerceTermEntries) {
            long userId = this._portal.getValidUserId(commerceTermEntry.getCompanyId(), commerceTermEntry.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            this.commerceTermEntryLocalService.updateStatus(userId, commerceTermEntry.getCommerceTermEntryId(), 0, serviceContext);
        }
    }

    private void _checkCommerceTermEntriesByExpirationDate() throws PortalException {
        List commerceTermEntries = this.commerceTermEntryPersistence.findByLtE_S(new Date(), 0);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + commerceTermEntries.size() + " commerce term entries"));
        }
        for (CommerceTermEntry commerceTermEntry : commerceTermEntries) {
            long userId = this._portal.getValidUserId(commerceTermEntry.getCompanyId(), commerceTermEntry.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            this.commerceTermEntryLocalService.updateStatus(userId, commerceTermEntry.getCommerceTermEntryId(), 3, serviceContext);
        }
    }

    private List<CommerceTermEntry> _getCommerceTermEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceTermEntry> commerceTermEntries = new ArrayList<CommerceTermEntry>(documents.size());
        for (Document document : documents) {
            long commerceTermEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceTermEntry commerceTermEntry = this.fetchCommerceTermEntry(commerceTermEntryId);
            if (commerceTermEntry == null) {
                commerceTermEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceTermEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceTermEntries == null) continue;
            commerceTermEntries.add(commerceTermEntry);
        }
        return commerceTermEntries;
    }

    private GroupByStep _getDeliveryTermsEntryGroupByStep(Long companyId, Long commerceOrderTypeId, Long commerceShippingFixedOptionId, FromStep fromStep) {
        CommerceTermEntryRelTable commerceOrderTypeCommerceTermEntryRel = (CommerceTermEntryRelTable)CommerceTermEntryRelTable.INSTANCE.as("commerceOrderTypeCommerceTermEntryRel");
        Column commerceTermEntryRelTableClassNameIdColumn = commerceOrderTypeCommerceTermEntryRel.classNameId;
        Column commerceShippingFixedOptionQualifierTableClassNameIdColumn = CommerceShippingFixedOptionQualifierTable.INSTANCE.classNameId;
        JoinStep joinStep = fromStep.from((Table)CommerceTermEntryTable.INSTANCE).innerJoinON((Table)CommerceShippingFixedOptionQualifierTable.INSTANCE, commerceShippingFixedOptionQualifierTableClassNameIdColumn.eq((Object)this._classNameLocalService.getClassNameId(CommerceTermEntry.class.getName())).and((Expression)CommerceShippingFixedOptionQualifierTable.INSTANCE.classPK.eq((Expression)CommerceTermEntryTable.INSTANCE.commerceTermEntryId))).leftJoinOn((Table)commerceOrderTypeCommerceTermEntryRel, commerceTermEntryRelTableClassNameIdColumn.eq((Object)this._classNameLocalService.getClassNameId(CommerceOrderType.class.getName())).and((Expression)commerceOrderTypeCommerceTermEntryRel.commerceTermEntryId.eq((Expression)CommerceTermEntryTable.INSTANCE.commerceTermEntryId)));
        return joinStep.where(CommerceShippingFixedOptionQualifierTable.INSTANCE.commerceShippingFixedOptionId.eq((Object)commerceShippingFixedOptionId).and(() -> {
            if (commerceOrderTypeId != null) {
                return commerceOrderTypeCommerceTermEntryRel.classPK.eq((Object)commerceOrderTypeId);
            }
            return commerceOrderTypeCommerceTermEntryRel.commerceTermEntryId.isNull();
        }).and((Expression)CommerceTermEntryTable.INSTANCE.status.eq((Object)0)).and((Expression)CommerceTermEntryTable.INSTANCE.companyId.eq((Object)companyId)).and((Expression)CommerceTermEntryTable.INSTANCE.active.eq((Object)true)).and((Expression)CommerceTermEntryTable.INSTANCE.type.eq((Object)"delivery-terms")));
    }

    private GroupByStep _getPaymentTermsEntryGroupByStep(Long companyId, Long commerceOrderTypeId, Long commercePaymentMethodGroupRelId, FromStep fromStep) {
        CommerceTermEntryRelTable commerceOrderTypeCommerceTermEntryRel = (CommerceTermEntryRelTable)CommerceTermEntryRelTable.INSTANCE.as("commerceOrderTypeCommerceTermEntryRel");
        Column commerceTermEntryRelTableClassNameIdColumn = commerceOrderTypeCommerceTermEntryRel.classNameId;
        Column commercePaymentMethodGroupRelQualifierTableClassNameIdColumn = CommercePaymentMethodGroupRelQualifierTable.INSTANCE.classNameId;
        JoinStep joinStep = fromStep.from((Table)CommerceTermEntryTable.INSTANCE).innerJoinON((Table)CommercePaymentMethodGroupRelQualifierTable.INSTANCE, commercePaymentMethodGroupRelQualifierTableClassNameIdColumn.eq((Object)this._classNameLocalService.getClassNameId(CommerceTermEntry.class.getName())).and((Expression)CommercePaymentMethodGroupRelQualifierTable.INSTANCE.classPK.eq((Expression)CommerceTermEntryTable.INSTANCE.commerceTermEntryId))).leftJoinOn((Table)commerceOrderTypeCommerceTermEntryRel, commerceTermEntryRelTableClassNameIdColumn.eq((Object)this._classNameLocalService.getClassNameId(CommerceOrderType.class.getName())).and((Expression)commerceOrderTypeCommerceTermEntryRel.commerceTermEntryId.eq((Expression)CommerceTermEntryTable.INSTANCE.commerceTermEntryId)));
        return joinStep.where(CommercePaymentMethodGroupRelQualifierTable.INSTANCE.commercePaymentMethodGroupRelId.eq((Object)commercePaymentMethodGroupRelId).and(() -> {
            if (commerceOrderTypeId != null) {
                return commerceOrderTypeCommerceTermEntryRel.classPK.eq((Object)commerceOrderTypeId);
            }
            return commerceOrderTypeCommerceTermEntryRel.commerceTermEntryId.isNull();
        }).and((Expression)CommerceTermEntryTable.INSTANCE.status.eq((Object)0)).and((Expression)CommerceTermEntryTable.INSTANCE.companyId.eq((Object)companyId)).and((Expression)CommerceTermEntryTable.INSTANCE.active.eq((Object)true)).and((Expression)CommerceTermEntryTable.INSTANCE.type.eq((Object)"payment-terms")));
    }

    private BaseModelSearchResult<CommerceTermEntry> _searchCommerceTermEntries(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceTermEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceTermEntry> commerceTermEntries = this._getCommerceTermEntries(hits);
            if (commerceTermEntries == null) continue;
            return new BaseModelSearchResult(commerceTermEntries, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    private CommerceTermEntry _startWorkflowInstance(long userId, CommerceTermEntry commerceTermEntry, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommerceTermEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceTermEntry.getCompanyId(), (long)0L, (long)userId, (String)CommerceTermEntry.class.getName(), (long)commerceTermEntry.getCommerceTermEntryId(), (Object)commerceTermEntry, (ServiceContext)serviceContext, workflowContext);
    }

    private List<CTermEntryLocalization> _updateCommerceTermEntryLocalizedFields(long companyId, long commerceTermEntryId, Map<Locale, String> descriptionMap, Map<Locale, String> labelMap) {
        ArrayList oldCTermEntryLocalizations = new ArrayList(this.cTermEntryLocalizationPersistence.findByCommerceTermEntryId(commerceTermEntryId));
        List<CTermEntryLocalization> newCTermEntryLocalizations = this._addCommerceTermEntryLocalizedFields(companyId, commerceTermEntryId, descriptionMap, labelMap);
        oldCTermEntryLocalizations.removeAll(newCTermEntryLocalizations);
        for (CTermEntryLocalization oldCTermEntryLocalization : oldCTermEntryLocalizations) {
            this.cTermEntryLocalizationPersistence.remove((BaseModel)oldCTermEntryLocalization);
        }
        return newCTermEntryLocalizations;
    }

    private void _validate(CommerceTermEntry commerceTermEntry, long companyId, String name, double priority, String type) throws PortalException {
        CommerceTermEntry oldCommerceTermEntry = this.commerceTermEntryPersistence.fetchByC_N(companyId, name);
        if (!(commerceTermEntry != null && name.equals(commerceTermEntry.getName()) || !Validator.isNull((String)name) && oldCommerceTermEntry == null)) {
            throw new CommerceTermEntryNameException();
        }
        if (Validator.isNull((String)type)) {
            throw new CommerceTermEntryTypeException();
        }
        oldCommerceTermEntry = this.commerceTermEntryPersistence.fetchByC_P_T(companyId, priority, type);
        if ((commerceTermEntry == null || priority != commerceTermEntry.getPriority()) && oldCommerceTermEntry != null) {
            throw new CommerceTermEntryPriorityException();
        }
    }
}

