/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.term.model.impl;

import com.liferay.commerce.term.model.CommerceTermEntryRel;
import com.liferay.commerce.term.service.CommerceTermEntryRelLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceTermEntryRel service. Represents a row in the &quot;CommerceTermEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceTermEntryRelImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceTermEntryRelImpl
 * @see CommerceTermEntryRel
 * @generated
 */
public abstract class CommerceTermEntryRelBaseImpl
	extends CommerceTermEntryRelModelImpl implements CommerceTermEntryRel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce term entry rel model instance should use the <code>CommerceTermEntryRel</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceTermEntryRelLocalServiceUtil.addCommerceTermEntryRel(this);
		}
		else {
			CommerceTermEntryRelLocalServiceUtil.updateCommerceTermEntryRel(
				this);
		}
	}

}