/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.term.service.impl;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceOrderTypeTable;
import com.liferay.commerce.term.exception.DuplicateCommerceTermEntryRelException;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.model.CommerceTermEntryRel;
import com.liferay.commerce.term.model.CommerceTermEntryRelTable;
import com.liferay.commerce.term.model.CommerceTermEntryTable;
import com.liferay.commerce.term.service.base.CommerceTermEntryRelLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.term.model.CommerceTermEntryRel"}, service={AopService.class})
public class CommerceTermEntryRelLocalServiceImpl
extends CommerceTermEntryRelLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceTermEntryRel addCommerceTermEntryRel(long userId, String className, long classPK, long commerceTermEntryId) throws PortalException {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        this._validate(classNameId, classPK, commerceTermEntryId);
        CommerceTermEntryRel commerceTermEntryRel = this.commerceTermEntryRelPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        commerceTermEntryRel.setCompanyId(user.getCompanyId());
        commerceTermEntryRel.setUserId(user.getUserId());
        commerceTermEntryRel.setUserName(user.getFullName());
        commerceTermEntryRel.setClassNameId(classNameId);
        commerceTermEntryRel.setClassPK(classPK);
        commerceTermEntryRel.setCommerceTermEntryId(commerceTermEntryId);
        commerceTermEntryRel = (CommerceTermEntryRel)this.commerceTermEntryRelPersistence.update((BaseModel)commerceTermEntryRel);
        this._reindexCommerceTermEntry(commerceTermEntryId);
        return commerceTermEntryRel;
    }

    @Override
    @SystemEvent(type=1)
    public CommerceTermEntryRel deleteCommerceTermEntryRel(CommerceTermEntryRel commerceTermEntryRel) throws PortalException {
        this.commerceTermEntryRelPersistence.remove((BaseModel)commerceTermEntryRel);
        this._reindexCommerceTermEntry(commerceTermEntryRel.getCommerceTermEntryId());
        return commerceTermEntryRel;
    }

    @Override
    public CommerceTermEntryRel deleteCommerceTermEntryRel(long commerceTermEntryRelId) throws PortalException {
        CommerceTermEntryRel commerceTermEntryRel = this.commerceTermEntryRelPersistence.findByPrimaryKey(commerceTermEntryRelId);
        return this.commerceTermEntryRelLocalService.deleteCommerceTermEntryRel(commerceTermEntryRel);
    }

    public void deleteCommerceTermEntryRels(long commerceTermEntryId) throws PortalException {
        List commerceTermEntryRels = this.commerceTermEntryRelPersistence.findByCommerceTermEntryId(commerceTermEntryId);
        for (CommerceTermEntryRel commerceTermEntryRel : commerceTermEntryRels) {
            this.commerceTermEntryRelLocalService.deleteCommerceTermEntryRel(commerceTermEntryRel);
        }
    }

    public void deleteCommerceTermEntryRels(String className, long commerceTermEntryId) throws PortalException {
        List commerceTermEntryRels = this.commerceTermEntryRelPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), commerceTermEntryId);
        for (CommerceTermEntryRel commerceTermEntryRel : commerceTermEntryRels) {
            this.commerceTermEntryRelLocalService.deleteCommerceTermEntryRel(commerceTermEntryRel);
        }
    }

    public CommerceTermEntryRel fetchCommerceTermEntryRel(String className, long classPK, long commerceTermEntryId) {
        return this.commerceTermEntryRelPersistence.fetchByC_C_C(this._classNameLocalService.getClassNameId(className), classPK, commerceTermEntryId);
    }

    public List<CommerceTermEntryRel> getCommerceOrderTypeCommerceTermEntryRels(long commerceTermEntryId, String keywords, int start, int end) {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceTermEntryRelTable.INSTANCE), (Table)CommerceOrderTypeTable.INSTANCE, CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommerceTermEntryRelTable.INSTANCE.classPK), commerceTermEntryId, CommerceOrderType.class.getName(), keywords, (Expression<String>)CommerceOrderTypeTable.INSTANCE.name).limit(start, end));
    }

    public int getCommerceOrderTypeCommerceTermEntryRelsCount(long commerceTermEntryId, String keywords) {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommerceTermEntryRelTable.INSTANCE.commerceTermEntryRelId), (Table)CommerceOrderTypeTable.INSTANCE, CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommerceTermEntryRelTable.INSTANCE.classPK), commerceTermEntryId, CommerceOrderType.class.getName(), keywords, (Expression<String>)CommerceOrderTypeTable.INSTANCE.name));
    }

    public List<CommerceTermEntryRel> getCommerceTermEntryRels(long commerceTermEntryId) {
        return this.commerceTermEntryRelPersistence.findByCommerceTermEntryId(commerceTermEntryId);
    }

    public List<CommerceTermEntryRel> getCommerceTermEntryRels(long commerceTermEntryId, int start, int end, OrderByComparator<CommerceTermEntryRel> orderByComparator) {
        return this.commerceTermEntryRelPersistence.findByCommerceTermEntryId(commerceTermEntryId, start, end, orderByComparator);
    }

    public int getCommerceTermEntryRelsCount(long commerceTermEntryId) {
        return this.commerceTermEntryRelPersistence.countByCommerceTermEntryId(commerceTermEntryId);
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Table innerJoinTable, Predicate innerJoinPredicate, Long commerceTermEntryId, String className, String keywords, Expression<String> keywordsPredicateExpression) {
        JoinStep joinStep = fromStep.from((Table)CommerceTermEntryRelTable.INSTANCE).innerJoinON((Table)CommerceTermEntryTable.INSTANCE, CommerceTermEntryTable.INSTANCE.commerceTermEntryId.eq((Expression)CommerceTermEntryRelTable.INSTANCE.commerceTermEntryId)).innerJoinON(innerJoinTable, innerJoinPredicate);
        return joinStep.where(() -> CommerceTermEntryRelTable.INSTANCE.commerceTermEntryId.eq((Object)commerceTermEntryId).and((Expression)CommerceTermEntryRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(className))).and(() -> {
            if (Validator.isNotNull((String)keywords)) {
                return Predicate.withParentheses((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)keywordsPredicateExpression), this._customSQL.keywords(keywords, true)));
            }
            return null;
        }));
    }

    private void _reindexCommerceTermEntry(long commerceTermEntryId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceTermEntry.class);
        indexer.reindex(CommerceTermEntry.class.getName(), commerceTermEntryId);
    }

    private void _validate(long classNameId, long classPK, long commerceTermEntryId) throws PortalException {
        CommerceTermEntryRel commerceTermEntryRel = this.commerceTermEntryRelPersistence.fetchByC_C_C(classNameId, classPK, commerceTermEntryId);
        if (commerceTermEntryRel != null) {
            throw new DuplicateCommerceTermEntryRelException();
        }
    }
}

