/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.term.internal.permission;

import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.permission.CommerceTermEntryPermission;
import com.liferay.commerce.term.service.CommerceTermEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceTermEntryPermission.class})
public class CommerceTermEntryPermissionImpl
implements CommerceTermEntryPermission {
    @Reference
    private CommerceTermEntryLocalService _commerceTermEntryLocalService;

    public void check(PermissionChecker permissionChecker, CommerceTermEntry commerceTermEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceTermEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceTermEntry.class.getName(), commerceTermEntry.getCommerceTermEntryId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceTermEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceTermEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceTermEntry.class.getName(), commerceTermEntryId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceTermEntry commerceTermEntry, String actionId) throws PortalException {
        return this.contains(permissionChecker, commerceTermEntry.getCommerceTermEntryId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceTermEntryId, String actionId) throws PortalException {
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryLocalService.fetchCommerceTermEntry(commerceTermEntryId);
        if (commerceTermEntry == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceTermEntry, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceTermEntryIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceTermEntryIds)) {
            return false;
        }
        for (long commerceTermEntryId : commerceTermEntryIds) {
            if (this.contains(permissionChecker, commerceTermEntryId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceTermEntry commerceTermEntry, String actionId) {
        if (permissionChecker.isCompanyAdmin(commerceTermEntry.getCompanyId()) || permissionChecker.isOmniadmin() || permissionChecker.hasOwnerPermission(commerceTermEntry.getCompanyId(), CommerceTermEntry.class.getName(), commerceTermEntry.getCommerceTermEntryId(), commerceTermEntry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(null, CommerceTermEntry.class.getName(), commerceTermEntry.getCommerceTermEntryId(), actionId);
    }
}

