/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.term.service.impl;

import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.model.CommerceTermEntryRel;
import com.liferay.commerce.term.service.base.CommerceTermEntryRelLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.term.model.CommerceTermEntryRel"}, service={AopService.class})
public class CommerceTermEntryRelLocalServiceImpl
extends CommerceTermEntryRelLocalServiceBaseImpl {
    public CommerceTermEntryRel addCommerceTermEntryRel(long userId, String className, long classPK, long commerceTermEntryId) throws PortalException {
        CommerceTermEntryRel commerceTermEntryRel = this.commerceTermEntryRelPersistence.create(this.counterLocalService.increment());
        User user = this.userLocalService.getUser(userId);
        commerceTermEntryRel.setCompanyId(user.getCompanyId());
        commerceTermEntryRel.setUserId(user.getUserId());
        commerceTermEntryRel.setUserName(user.getFullName());
        commerceTermEntryRel.setClassNameId(this.classNameLocalService.getClassNameId(className));
        commerceTermEntryRel.setClassPK(classPK);
        commerceTermEntryRel.setCommerceTermEntryId(commerceTermEntryId);
        commerceTermEntryRel = (CommerceTermEntryRel)this.commerceTermEntryRelPersistence.update((BaseModel)commerceTermEntryRel);
        this.reindexCommerceTermEntry(commerceTermEntryId);
        return commerceTermEntryRel;
    }

    @Override
    @SystemEvent(type=1)
    public CommerceTermEntryRel deleteCommerceTermEntryRel(CommerceTermEntryRel commerceTermEntryRel) throws PortalException {
        this.commerceTermEntryRelPersistence.remove((BaseModel)commerceTermEntryRel);
        this.reindexCommerceTermEntry(commerceTermEntryRel.getCommerceTermEntryId());
        return commerceTermEntryRel;
    }

    @Override
    public CommerceTermEntryRel deleteCommerceTermEntryRel(long commerceTermEntryRelId) throws PortalException {
        CommerceTermEntryRel commerceTermEntryRel = this.commerceTermEntryRelPersistence.findByPrimaryKey(commerceTermEntryRelId);
        return this.commerceTermEntryRelLocalService.deleteCommerceTermEntryRel(commerceTermEntryRel);
    }

    public void deleteCommerceTermEntryRels(long commerceTermEntryId) throws PortalException {
        List commerceTermEntryRels = this.commerceTermEntryRelPersistence.findByCommerceTermEntryId(commerceTermEntryId);
        for (CommerceTermEntryRel commerceTermEntryRel : commerceTermEntryRels) {
            this.commerceTermEntryRelLocalService.deleteCommerceTermEntryRel(commerceTermEntryRel);
        }
    }

    public void deleteCommerceTermEntryRels(String className, long commerceTermEntryId) throws PortalException {
        List commerceTermEntryRels = this.commerceTermEntryRelPersistence.findByC_C(this.classNameLocalService.getClassNameId(className), commerceTermEntryId);
        for (CommerceTermEntryRel commerceTermEntryRel : commerceTermEntryRels) {
            this.commerceTermEntryRelLocalService.deleteCommerceTermEntryRel(commerceTermEntryRel);
        }
    }

    public CommerceTermEntryRel fetchCommerceTermEntryRel(String className, long classPK, long commerceTermEntryId) {
        return this.commerceTermEntryRelPersistence.fetchByC_C_C(this.classNameLocalService.getClassNameId(className), classPK, commerceTermEntryId);
    }

    public List<CommerceTermEntryRel> getCommerceTermEntryRels(long commerceTermEntryId) {
        return this.commerceTermEntryRelPersistence.findByCommerceTermEntryId(commerceTermEntryId);
    }

    public List<CommerceTermEntryRel> getCommerceTermEntryRels(long commerceTermEntryId, int start, int end, OrderByComparator<CommerceTermEntryRel> orderByComparator) {
        return this.commerceTermEntryRelPersistence.findByCommerceTermEntryId(commerceTermEntryId, start, end, orderByComparator);
    }

    public int getCommerceTermEntryRelsCount(long commerceTermEntryId) {
        return this.commerceTermEntryRelPersistence.countByCommerceTermEntryId(commerceTermEntryId);
    }

    protected void reindexCommerceTermEntry(long commerceTermEntryId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceTermEntry.class);
        indexer.reindex(CommerceTermEntry.class.getName(), commerceTermEntryId);
    }
}

