/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.term.service.impl;

import com.liferay.commerce.term.exception.CommerceTermEntryDisplayDateException;
import com.liferay.commerce.term.exception.CommerceTermEntryExpirationDateException;
import com.liferay.commerce.term.exception.CommerceTermEntryNameException;
import com.liferay.commerce.term.exception.CommerceTermEntryPriorityException;
import com.liferay.commerce.term.exception.CommerceTermEntryTypeException;
import com.liferay.commerce.term.model.CTermEntryLocalization;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.service.CommerceTermEntryRelLocalService;
import com.liferay.commerce.term.service.base.CommerceTermEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.term.model.CommerceTermEntry"}, service={AopService.class})
public class CommerceTermEntryLocalServiceImpl
extends CommerceTermEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceTermEntryLocalServiceImpl.class);
    @Reference
    private CommerceTermEntryRelLocalService _commerceTermEntryRelLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTermEntry addCommerceTermEntry(String externalReferenceCode, long userId, boolean active, Map<Locale, String> descriptionMap, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> labelMap, String name, double priority, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        this._validate(null, serviceContext.getCompanyId(), name, priority, type);
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryPersistence.create(this.counterLocalService.increment());
        commerceTermEntry.setExternalReferenceCode(externalReferenceCode);
        User user = this.userLocalService.getUser(userId);
        commerceTermEntry.setCompanyId(user.getCompanyId());
        commerceTermEntry.setUserId(user.getUserId());
        commerceTermEntry.setUserName(user.getFullName());
        commerceTermEntry.setActive(active);
        commerceTermEntry.setDisplayDate(this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommerceTermEntryDisplayDateException.class));
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommerceTermEntryExpirationDateException.class);
        }
        commerceTermEntry.setExpirationDate(expirationDate);
        commerceTermEntry.setName(name);
        commerceTermEntry.setPriority(priority);
        commerceTermEntry.setType(type);
        UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)typeSettings).build();
        commerceTermEntry.setTypeSettingsUnicodeProperties(typeSettingsUnicodeProperties);
        Date date = new Date();
        if (expirationDate == null || expirationDate.after(date)) {
            commerceTermEntry.setStatus(2);
        } else {
            commerceTermEntry.setStatus(3);
        }
        commerceTermEntry.setStatusByUserId(user.getUserId());
        commerceTermEntry.setStatusDate(serviceContext.getModifiedDate(date));
        commerceTermEntry = (CommerceTermEntry)this.commerceTermEntryPersistence.update((BaseModel)commerceTermEntry);
        this._addCommerceTermEntryLocalizedFields(user.getCompanyId(), commerceTermEntry.getCommerceTermEntryId(), descriptionMap, labelMap);
        this.resourceLocalService.addModelResources((AuditedModel)commerceTermEntry, serviceContext);
        return this._startWorkflowInstance(user.getUserId(), commerceTermEntry, serviceContext);
    }

    public void checkCommerceTermEntries() throws PortalException {
        this._checkCommerceTermEntriesByDisplayDate();
        this._checkCommerceTermEntriesByExpirationDate();
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceTermEntry deleteCommerceTermEntry(CommerceTermEntry commerceTermEntry) throws PortalException {
        this.commerceTermEntryPersistence.remove((BaseModel)commerceTermEntry);
        this.resourceLocalService.deleteResource(commerceTermEntry.getCompanyId(), CommerceTermEntry.class.getName(), 4, commerceTermEntry.getCommerceTermEntryId());
        this._commerceTermEntryRelLocalService.deleteCommerceTermEntryRels(commerceTermEntry.getCommerceTermEntryId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceTermEntry.getCompanyId(), 0L, CommerceTermEntry.class.getName(), commerceTermEntry.getCommerceTermEntryId());
        return commerceTermEntry;
    }

    @Override
    public CommerceTermEntry deleteCommerceTermEntry(long commerceTermEntryId) throws PortalException {
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryPersistence.findByPrimaryKey(commerceTermEntryId);
        return this.commerceTermEntryLocalService.deleteCommerceTermEntry(commerceTermEntry);
    }

    public List<String> getCTermEntryLocalizationLanguageIds(long commerceTermEntryId) {
        List cTermEntryLocalizations = this.cTermEntryLocalizationPersistence.findByCommerceTermEntryId(commerceTermEntryId);
        ArrayList<String> availableLanguageIds = new ArrayList<String>();
        for (CTermEntryLocalization cTermEntryLocalization : cTermEntryLocalizations) {
            availableLanguageIds.add(cTermEntryLocalization.getLanguageId());
        }
        return availableLanguageIds;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTermEntry updateCommerceTermEntry(long userId, long commerceTermEntryId, boolean active, Map<Locale, String> descriptionMap, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> labelMap, String name, double priority, String typeSettings, ServiceContext serviceContext) throws PortalException {
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryLocalService.getCommerceTermEntry(commerceTermEntryId);
        this._validate(commerceTermEntry, serviceContext.getCompanyId(), name, priority, commerceTermEntry.getType());
        commerceTermEntry.setActive(active);
        User user = this.userLocalService.getUser(userId);
        commerceTermEntry.setDisplayDate(this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommerceTermEntryDisplayDateException.class));
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommerceTermEntryExpirationDateException.class);
        }
        commerceTermEntry.setExpirationDate(expirationDate);
        commerceTermEntry.setName(name);
        commerceTermEntry.setPriority(priority);
        UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)typeSettings).build();
        commerceTermEntry.setTypeSettingsUnicodeProperties(typeSettingsUnicodeProperties);
        Date date = new Date();
        if (expirationDate == null || expirationDate.after(date)) {
            commerceTermEntry.setStatus(2);
        } else {
            commerceTermEntry.setStatus(3);
        }
        commerceTermEntry.setStatusByUserId(user.getUserId());
        commerceTermEntry.setStatusDate(serviceContext.getModifiedDate(date));
        commerceTermEntry.setExpandoBridgeAttributes(serviceContext);
        commerceTermEntry = (CommerceTermEntry)this.commerceTermEntryPersistence.update((BaseModel)commerceTermEntry);
        this._updateCommerceTermEntryLocalizedFields(user.getCompanyId(), commerceTermEntryId, descriptionMap, labelMap);
        return this._startWorkflowInstance(user.getUserId(), commerceTermEntry, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTermEntry updateCommerceTermEntryExternalReferenceCode(String externalReferenceCode, long commerceTermEntryId) throws PortalException {
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryPersistence.findByPrimaryKey(commerceTermEntryId);
        commerceTermEntry.setExternalReferenceCode(externalReferenceCode);
        return (CommerceTermEntry)this.commerceTermEntryPersistence.update((BaseModel)commerceTermEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTermEntry updateStatus(long userId, long commerceTermEntryId, int status, ServiceContext serviceContext) throws PortalException {
        Date expirationDate;
        CommerceTermEntry commerceTermEntry = this.commerceTermEntryPersistence.findByPrimaryKey(commerceTermEntryId);
        Date date = new Date();
        if (status == 0 && commerceTermEntry.getDisplayDate() != null && date.before(commerceTermEntry.getDisplayDate())) {
            status = 7;
        }
        if (status == 0 && (expirationDate = commerceTermEntry.getExpirationDate()) != null && expirationDate.before(date)) {
            commerceTermEntry.setExpirationDate(null);
        }
        if (status == 3) {
            commerceTermEntry.setActive(false);
            commerceTermEntry.setExpirationDate(date);
        }
        commerceTermEntry.setStatus(status);
        User user = this.userLocalService.getUser(userId);
        commerceTermEntry.setStatusByUserId(user.getUserId());
        commerceTermEntry.setStatusByUserName(user.getFullName());
        commerceTermEntry.setStatusDate(serviceContext.getModifiedDate(date));
        return (CommerceTermEntry)this.commerceTermEntryPersistence.update((BaseModel)commerceTermEntry);
    }

    private List<CTermEntryLocalization> _addCommerceTermEntryLocalizedFields(long companyId, long commerceTermEntryId, Map<Locale, String> descriptionMap, Map<Locale, String> labelMap) {
        HashSet<Locale> localeSet = new HashSet<Locale>();
        if (descriptionMap != null) {
            localeSet.addAll(descriptionMap.keySet());
        }
        if (labelMap != null) {
            localeSet.addAll(labelMap.keySet());
        }
        ArrayList<CTermEntryLocalization> cTermEntryLocalizations = new ArrayList<CTermEntryLocalization>();
        for (Locale locale : localeSet) {
            String description = null;
            String label = null;
            if (descriptionMap != null) {
                description = descriptionMap.get(locale);
            }
            if (labelMap != null) {
                label = labelMap.get(locale);
            }
            if (Validator.isNull(description) && Validator.isNull((String)label)) continue;
            CTermEntryLocalization cTermEntryLocalization = this._addCommerceTermEntryLocalizedFields(companyId, commerceTermEntryId, description, label, LocaleUtil.toLanguageId((Locale)locale));
            cTermEntryLocalizations.add(cTermEntryLocalization);
        }
        return cTermEntryLocalizations;
    }

    private CTermEntryLocalization _addCommerceTermEntryLocalizedFields(long companyId, long commerceTermEntryId, String description, String label, String languageId) {
        CTermEntryLocalization cTermEntryLocalization = this.cTermEntryLocalizationPersistence.fetchByCommerceTermEntryId_LanguageId(commerceTermEntryId, languageId);
        if (cTermEntryLocalization == null) {
            cTermEntryLocalization = this.cTermEntryLocalizationPersistence.create(this.counterLocalService.increment());
            cTermEntryLocalization.setCompanyId(companyId);
            cTermEntryLocalization.setCommerceTermEntryId(commerceTermEntryId);
            cTermEntryLocalization.setDescription(description);
            cTermEntryLocalization.setLabel(label);
            cTermEntryLocalization.setLanguageId(languageId);
        } else {
            cTermEntryLocalization.setDescription(description);
            cTermEntryLocalization.setLabel(label);
        }
        return (CTermEntryLocalization)this.cTermEntryLocalizationPersistence.update((BaseModel)cTermEntryLocalization);
    }

    private void _checkCommerceTermEntriesByDisplayDate() throws PortalException {
        List commerceTermEntries = this.commerceTermEntryPersistence.findByLtD_S(new Date(), 7);
        for (CommerceTermEntry commerceTermEntry : commerceTermEntries) {
            long userId = this._portal.getValidUserId(commerceTermEntry.getCompanyId(), commerceTermEntry.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            this.commerceTermEntryLocalService.updateStatus(userId, commerceTermEntry.getCommerceTermEntryId(), 0, serviceContext);
        }
    }

    private void _checkCommerceTermEntriesByExpirationDate() throws PortalException {
        List commerceTermEntries = this.commerceTermEntryPersistence.findByLtE_S(new Date(), 0);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + commerceTermEntries.size() + " commerce term entries"));
        }
        for (CommerceTermEntry commerceTermEntry : commerceTermEntries) {
            long userId = this._portal.getValidUserId(commerceTermEntry.getCompanyId(), commerceTermEntry.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            this.commerceTermEntryLocalService.updateStatus(userId, commerceTermEntry.getCommerceTermEntryId(), 3, serviceContext);
        }
    }

    private CommerceTermEntry _startWorkflowInstance(long userId, CommerceTermEntry commerceTermEntry, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommerceTermEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceTermEntry.getCompanyId(), (long)0L, (long)userId, (String)CommerceTermEntry.class.getName(), (long)commerceTermEntry.getCommerceTermEntryId(), (Object)commerceTermEntry, (ServiceContext)serviceContext, workflowContext);
    }

    private List<CTermEntryLocalization> _updateCommerceTermEntryLocalizedFields(long companyId, long commerceTermEntryId, Map<Locale, String> descriptionMap, Map<Locale, String> labelMap) {
        ArrayList oldCTermEntryLocalizations = new ArrayList(this.cTermEntryLocalizationPersistence.findByCommerceTermEntryId(commerceTermEntryId));
        List<CTermEntryLocalization> newCTermEntryLocalizations = this._addCommerceTermEntryLocalizedFields(companyId, commerceTermEntryId, descriptionMap, labelMap);
        oldCTermEntryLocalizations.removeAll(newCTermEntryLocalizations);
        for (CTermEntryLocalization oldCTermEntryLocalization : oldCTermEntryLocalizations) {
            this.cTermEntryLocalizationPersistence.remove((BaseModel)oldCTermEntryLocalization);
        }
        return newCTermEntryLocalizations;
    }

    private void _validate(CommerceTermEntry commerceTermEntry, long companyId, String name, double priority, String type) throws PortalException {
        CommerceTermEntry oldCommerceTermEntry = this.commerceTermEntryPersistence.fetchByC_N(companyId, name);
        if (!(commerceTermEntry != null && name.equals(commerceTermEntry.getName()) || !Validator.isNull((String)name) && oldCommerceTermEntry == null)) {
            throw new CommerceTermEntryNameException();
        }
        if (Validator.isNull((String)type)) {
            throw new CommerceTermEntryTypeException();
        }
        oldCommerceTermEntry = this.commerceTermEntryPersistence.fetchByC_P_T(companyId, priority, type);
        if ((commerceTermEntry == null || priority != commerceTermEntry.getPriority()) && oldCommerceTermEntry != null) {
            throw new CommerceTermEntryPriorityException();
        }
    }
}

