/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.engine.fixed.service.impl;

import com.liferay.commerce.tax.engine.fixed.model.CommerceTaxFixedRateAddressRel;
import com.liferay.commerce.tax.engine.fixed.service.base.CommerceTaxFixedRateAddressRelLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.tax.engine.fixed.model.CommerceTaxFixedRateAddressRel"}, service={AopService.class})
public class CommerceTaxFixedRateAddressRelLocalServiceImpl
extends CommerceTaxFixedRateAddressRelLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    public CommerceTaxFixedRateAddressRel addCommerceTaxFixedRateAddressRel(long userId, long groupId, long commerceTaxMethodId, long cpTaxCategoryId, long countryId, long regionId, String zip, double rate) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long commerceTaxFixedRateAddressRelId = this.counterLocalService.increment();
        CommerceTaxFixedRateAddressRel commerceTaxFixedRateAddressRel = this.commerceTaxFixedRateAddressRelPersistence.create(commerceTaxFixedRateAddressRelId);
        commerceTaxFixedRateAddressRel.setGroupId(groupId);
        commerceTaxFixedRateAddressRel.setCompanyId(user.getCompanyId());
        commerceTaxFixedRateAddressRel.setUserId(user.getUserId());
        commerceTaxFixedRateAddressRel.setUserName(user.getFullName());
        commerceTaxFixedRateAddressRel.setCommerceTaxMethodId(commerceTaxMethodId);
        commerceTaxFixedRateAddressRel.setCPTaxCategoryId(cpTaxCategoryId);
        commerceTaxFixedRateAddressRel.setCountryId(countryId);
        commerceTaxFixedRateAddressRel.setRegionId(regionId);
        commerceTaxFixedRateAddressRel.setZip(zip);
        commerceTaxFixedRateAddressRel.setRate(rate);
        return (CommerceTaxFixedRateAddressRel)this.commerceTaxFixedRateAddressRelPersistence.update((BaseModel)commerceTaxFixedRateAddressRel);
    }

    @Deprecated
    public CommerceTaxFixedRateAddressRel addCommerceTaxFixedRateAddressRel(long commerceTaxMethodId, long cpTaxCategoryId, long countryId, long regionId, String zip, double rate, ServiceContext serviceContext) throws PortalException {
        return this.commerceTaxFixedRateAddressRelLocalService.addCommerceTaxFixedRateAddressRel(serviceContext.getUserId(), serviceContext.getScopeGroupId(), commerceTaxMethodId, cpTaxCategoryId, countryId, regionId, zip, rate);
    }

    public void deleteCommerceTaxFixedRateAddressRelsByCommerceTaxMethodId(long commerceTaxMethodId) {
        this.commerceTaxFixedRateAddressRelPersistence.removeByCommerceTaxMethodId(commerceTaxMethodId);
    }

    public void deleteCommerceTaxFixedRateAddressRelsByCountryId(long countryId) {
        this.commerceTaxFixedRateAddressRelPersistence.removeByCountryId(countryId);
    }

    public void deleteCommerceTaxFixedRateAddressRelsByCPTaxCategoryId(long cpTaxCategoryId) {
        this.commerceTaxFixedRateAddressRelPersistence.removeByCPTaxCategoryId(cpTaxCategoryId);
    }

    public CommerceTaxFixedRateAddressRel fetchCommerceTaxFixedRateAddressRel(long commerceTaxMethodId, long cpTaxCategoryId, long countryId, long regionId, String zip) {
        return this.commerceTaxFixedRateAddressRelFinder.fetchByC_C_C_R_Z_First(commerceTaxMethodId, cpTaxCategoryId, countryId, regionId, zip);
    }

    public CommerceTaxFixedRateAddressRel fetchCommerceTaxFixedRateAddressRel(long commerceTaxMethodId, long countryId, long regionId, String zip) {
        return this.commerceTaxFixedRateAddressRelFinder.fetchByC_C_R_Z_First(commerceTaxMethodId, countryId, regionId, zip);
    }

    public List<CommerceTaxFixedRateAddressRel> getCommerceTaxFixedRateAddressRels(long cpTaxCategoryId, int start, int end) {
        return this.commerceTaxFixedRateAddressRelPersistence.findByCPTaxCategoryId(cpTaxCategoryId, start, end);
    }

    public List<CommerceTaxFixedRateAddressRel> getCommerceTaxFixedRateAddressRels(long cpTaxCategoryId, int start, int end, OrderByComparator<CommerceTaxFixedRateAddressRel> orderByComparator) {
        return this.commerceTaxFixedRateAddressRelPersistence.findByCPTaxCategoryId(cpTaxCategoryId, start, end, orderByComparator);
    }

    public int getCommerceTaxFixedRateAddressRelsCount(long cpTaxCategoryId) {
        return this.commerceTaxFixedRateAddressRelPersistence.countByCPTaxCategoryId(cpTaxCategoryId);
    }

    public List<CommerceTaxFixedRateAddressRel> getCommerceTaxMethodFixedRateAddressRels(long commerceTaxMethodId, int start, int end) {
        return this.commerceTaxFixedRateAddressRelPersistence.findByCommerceTaxMethodId(commerceTaxMethodId, start, end);
    }

    public List<CommerceTaxFixedRateAddressRel> getCommerceTaxMethodFixedRateAddressRels(long commerceTaxMethodId, int start, int end, OrderByComparator<CommerceTaxFixedRateAddressRel> orderByComparator) {
        return this.commerceTaxFixedRateAddressRelPersistence.findByCommerceTaxMethodId(commerceTaxMethodId, start, end, orderByComparator);
    }

    public int getCommerceTaxMethodFixedRateAddressRelsCount(long commerceTaxMethodId) {
        return this.commerceTaxFixedRateAddressRelPersistence.countByCommerceTaxMethodId(commerceTaxMethodId);
    }

    public CommerceTaxFixedRateAddressRel updateCommerceTaxFixedRateAddressRel(long commerceTaxFixedRateAddressRelId, long countryId, long regionId, String zip, double rate) throws PortalException {
        CommerceTaxFixedRateAddressRel commerceTaxFixedRateAddressRel = this.commerceTaxFixedRateAddressRelPersistence.findByPrimaryKey(commerceTaxFixedRateAddressRelId);
        commerceTaxFixedRateAddressRel.setCountryId(countryId);
        commerceTaxFixedRateAddressRel.setRegionId(regionId);
        commerceTaxFixedRateAddressRel.setZip(zip);
        commerceTaxFixedRateAddressRel.setRate(rate);
        return (CommerceTaxFixedRateAddressRel)this.commerceTaxFixedRateAddressRelPersistence.update((BaseModel)commerceTaxFixedRateAddressRel);
    }
}

