/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.tax.engine.fixed.model.impl;

import com.liferay.commerce.tax.engine.fixed.model.CommerceTaxFixedRate;
import com.liferay.commerce.tax.engine.fixed.service.CommerceTaxFixedRateLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceTaxFixedRate service. Represents a row in the &quot;CommerceTaxFixedRate&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceTaxFixedRateImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceTaxFixedRateImpl
 * @see CommerceTaxFixedRate
 * @generated
 */
public abstract class CommerceTaxFixedRateBaseImpl
	extends CommerceTaxFixedRateModelImpl implements CommerceTaxFixedRate {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce tax fixed rate model instance should use the <code>CommerceTaxFixedRate</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceTaxFixedRateLocalServiceUtil.addCommerceTaxFixedRate(this);
		}
		else {
			CommerceTaxFixedRateLocalServiceUtil.updateCommerceTaxFixedRate(
				this);
		}
	}

}