/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.engine.fixed.service.impl;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.tax.engine.fixed.model.CommerceTaxFixedRate;
import com.liferay.commerce.tax.engine.fixed.service.base.CommerceTaxFixedRateServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceTaxFixedRate"}, service={AopService.class})
public class CommerceTaxFixedRateServiceImpl
extends CommerceTaxFixedRateServiceBaseImpl {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceChannel)")
    private ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission;

    @Deprecated
    public CommerceTaxFixedRate addCommerceTaxFixedRate(long commerceTaxMethodId, long cpTaxCategoryId, double rate, ServiceContext serviceContext) throws PortalException {
        return this.commerceTaxFixedRateService.addCommerceTaxFixedRate(serviceContext.getScopeGroupId(), commerceTaxMethodId, cpTaxCategoryId, rate);
    }

    public CommerceTaxFixedRate addCommerceTaxFixedRate(long groupId, long commerceTaxMethodId, long cpTaxCategoryId, double rate) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceTaxFixedRateLocalService.addCommerceTaxFixedRate(this.getUserId(), groupId, commerceTaxMethodId, cpTaxCategoryId, rate);
    }

    public void deleteCommerceTaxFixedRate(long commerceTaxFixedRateId) throws PortalException {
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRateLocalService.getCommerceTaxFixedRate(commerceTaxFixedRateId);
        this._checkCommerceChannel(commerceTaxFixedRate.getGroupId());
        this.commerceTaxFixedRateLocalService.deleteCommerceTaxFixedRate(commerceTaxFixedRate);
    }

    public CommerceTaxFixedRate fetchCommerceTaxFixedRate(long commerceTaxFixedRateId) throws PortalException {
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRateLocalService.fetchCommerceTaxFixedRate(commerceTaxFixedRateId);
        if (commerceTaxFixedRate != null) {
            this._checkCommerceChannel(commerceTaxFixedRate.getGroupId());
        }
        return commerceTaxFixedRate;
    }

    public CommerceTaxFixedRate fetchCommerceTaxFixedRate(long cpTaxCategoryId, long commerceTaxMethodId) throws PortalException {
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRateLocalService.fetchCommerceTaxFixedRate(cpTaxCategoryId, commerceTaxMethodId);
        if (commerceTaxFixedRate != null) {
            this._checkCommerceChannel(commerceTaxFixedRate.getGroupId());
        }
        return commerceTaxFixedRate;
    }

    public List<CommerceTaxFixedRate> getCommerceTaxFixedRates(long groupId, long commerceTaxMethodId, int start, int end, OrderByComparator<CommerceTaxFixedRate> orderByComparator) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceTaxFixedRateLocalService.getCommerceTaxFixedRates(commerceTaxMethodId, start, end, orderByComparator);
    }

    public int getCommerceTaxFixedRatesCount(long groupId, long commerceTaxMethodId) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceTaxFixedRateLocalService.getCommerceTaxFixedRatesCount(commerceTaxMethodId);
    }

    public CommerceTaxFixedRate updateCommerceTaxFixedRate(long commerceTaxFixedRateId, double rate) throws PortalException {
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRateLocalService.getCommerceTaxFixedRate(commerceTaxFixedRateId);
        this._checkCommerceChannel(commerceTaxFixedRate.getGroupId());
        return this.commerceTaxFixedRateLocalService.updateCommerceTaxFixedRate(commerceTaxFixedRateId, rate);
    }

    private void _checkCommerceChannel(long groupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
        this._commerceChannelModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceChannel, "UPDATE");
    }
}

