/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.engine.fixed.internal.engine;

import com.liferay.commerce.exception.CommerceTaxEngineException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.tax.CommerceTaxCalculateRequest;
import com.liferay.commerce.tax.CommerceTaxEngine;
import com.liferay.commerce.tax.CommerceTaxValue;
import com.liferay.commerce.tax.engine.fixed.configuration.CommerceTaxByAddressTypeConfiguration;
import com.liferay.commerce.tax.engine.fixed.model.CommerceTaxFixedRateAddressRel;
import com.liferay.commerce.tax.engine.fixed.service.CommerceTaxFixedRateAddressRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.tax.engine.key=by-address"}, service={CommerceTaxEngine.class})
public class ByAddressCommerceTaxEngine
implements CommerceTaxEngine {
    public static final String KEY = "by-address";
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final int _SCALE = 10;
    private static final Log _log = LogFactoryUtil.getLog(ByAddressCommerceTaxEngine.class);
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommerceTaxFixedRateAddressRelLocalService _commerceTaxFixedRateAddressRelLocalService;
    @Reference
    private Language _language;

    public CommerceTaxValue getCommerceTaxValue(CommerceTaxCalculateRequest commerceTaxCalculateRequest) throws CommerceTaxEngineException {
        BigDecimal rate;
        CommerceTaxFixedRateAddressRel commerceTaxFixedRateAddressRel;
        CommerceAddress commerceAddress;
        long countryId = 0L;
        long regionId = 0L;
        String zip = "";
        long commerceAddressId = commerceTaxCalculateRequest.getCommerceBillingAddressId();
        if (this._isTaxAppliedToShippingAddress(commerceTaxCalculateRequest.getCommerceChannelGroupId())) {
            commerceAddressId = commerceTaxCalculateRequest.getCommerceShippingAddressId();
        }
        if ((commerceAddress = this._commerceAddressLocalService.fetchCommerceAddress(commerceAddressId)) != null) {
            countryId = commerceAddress.getCountryId();
            regionId = commerceAddress.getRegionId();
            zip = commerceAddress.getZip();
        }
        if ((commerceTaxFixedRateAddressRel = this._commerceTaxFixedRateAddressRelLocalService.fetchCommerceTaxFixedRateAddressRel(commerceTaxCalculateRequest.getCommerceTaxMethodId(), commerceTaxCalculateRequest.getTaxCategoryId(), countryId, regionId, zip)) == null) {
            return null;
        }
        BigDecimal taxValue = rate = BigDecimal.valueOf(commerceTaxFixedRateAddressRel.getRate());
        if (commerceTaxCalculateRequest.isPercentage()) {
            BigDecimal amount = commerceTaxCalculateRequest.getPrice();
            taxValue = amount.multiply(rate);
            BigDecimal denominator = _ONE_HUNDRED;
            if (commerceTaxCalculateRequest.isIncludeTax()) {
                denominator = _ONE_HUNDRED.add(rate);
            }
            taxValue = taxValue.divide(denominator, 10, RoundingMode.HALF_EVEN);
        }
        return new CommerceTaxValue(KEY, KEY, taxValue);
    }

    public String getDescription(Locale locale) {
        return this._language.get(this._getResourceBundle(locale), "by-address-tax-rate-description");
    }

    public String getName(Locale locale) {
        return this._language.get(this._getResourceBundle(locale), KEY);
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
    }

    private boolean _isTaxAppliedToShippingAddress(long groupId) {
        try {
            CommerceTaxByAddressTypeConfiguration commerceTaxByAddressTypeConfiguration = (CommerceTaxByAddressTypeConfiguration)ConfigurationProviderUtil.getConfiguration(CommerceTaxByAddressTypeConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, CommerceTaxByAddressTypeConfiguration.class.getName()));
            return commerceTaxByAddressTypeConfiguration.taxAppliedToShippingAddress();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return false;
        }
    }
}

