/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.engine.fixed.internal.engine;

import com.liferay.commerce.exception.CommerceTaxEngineException;
import com.liferay.commerce.tax.CommerceTaxCalculateRequest;
import com.liferay.commerce.tax.CommerceTaxEngine;
import com.liferay.commerce.tax.CommerceTaxValue;
import com.liferay.commerce.tax.engine.fixed.model.CommerceTaxFixedRate;
import com.liferay.commerce.tax.engine.fixed.service.CommerceTaxFixedRateLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.tax.engine.key=fixed-tax"}, service={CommerceTaxEngine.class})
public class FixedCommerceTaxEngine
implements CommerceTaxEngine {
    public static final String KEY = "fixed-tax";
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final Log _log = LogFactoryUtil.getLog(FixedCommerceTaxEngine.class);
    @Reference
    private CommerceTaxFixedRateLocalService _commerceTaxFixedRateLocalService;

    public CommerceTaxValue getCommerceTaxValue(CommerceTaxCalculateRequest commerceTaxCalculateRequest) throws CommerceTaxEngineException {
        CommerceTaxValue commerceTaxValue = null;
        try {
            CommerceTaxFixedRate commerceTaxFixedRate = this._commerceTaxFixedRateLocalService.fetchCommerceTaxFixedRate(commerceTaxCalculateRequest.getTaxCategoryId(), commerceTaxCalculateRequest.getCommerceTaxMethodId());
            if (commerceTaxFixedRate == null) {
                return new CommerceTaxValue(KEY, KEY, BigDecimal.ZERO);
            }
            BigDecimal rate = BigDecimal.valueOf(commerceTaxFixedRate.getRate());
            BigDecimal amount = commerceTaxCalculateRequest.getPrice();
            BigDecimal taxValue = rate;
            if (commerceTaxCalculateRequest.isPercentage()) {
                taxValue = amount.multiply(rate);
                BigDecimal denominator = _ONE_HUNDRED;
                if (commerceTaxCalculateRequest.isWithTaxAmount()) {
                    denominator = _ONE_HUNDRED.add(rate);
                }
                taxValue = taxValue.divide(denominator, RoundingMode.HALF_EVEN);
            }
            commerceTaxValue = new CommerceTaxValue(KEY, KEY, taxValue);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            throw new CommerceTaxEngineException((Throwable)pe);
        }
        return commerceTaxValue;
    }

    public String getDescription(Locale locale) {
        ResourceBundle resourceBundle = this._getResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"fixed-tax-description");
    }

    public String getName(Locale locale) {
        ResourceBundle resourceBundle = this._getResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)KEY);
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
    }
}

