/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.engine.fixed.service.impl;

import com.liferay.commerce.tax.engine.fixed.exception.DuplicateCommerceTaxFixedRateException;
import com.liferay.commerce.tax.engine.fixed.model.CommerceTaxFixedRate;
import com.liferay.commerce.tax.engine.fixed.service.base.CommerceTaxFixedRateLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceTaxFixedRateLocalServiceImpl
extends CommerceTaxFixedRateLocalServiceBaseImpl {
    public CommerceTaxFixedRate addCommerceTaxFixedRate(long commerceTaxMethodId, long cpTaxCategoryId, double rate, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        this.validate(cpTaxCategoryId, commerceTaxMethodId);
        long commerceTaxFixedRateId = this.counterLocalService.increment();
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRatePersistence.create(commerceTaxFixedRateId);
        commerceTaxFixedRate.setGroupId(serviceContext.getScopeGroupId());
        commerceTaxFixedRate.setCompanyId(user.getCompanyId());
        commerceTaxFixedRate.setUserId(user.getUserId());
        commerceTaxFixedRate.setUserName(user.getFullName());
        commerceTaxFixedRate.setCommerceTaxMethodId(commerceTaxMethodId);
        commerceTaxFixedRate.setCPTaxCategoryId(cpTaxCategoryId);
        commerceTaxFixedRate.setRate(rate);
        return (CommerceTaxFixedRate)this.commerceTaxFixedRatePersistence.update((BaseModel)commerceTaxFixedRate);
    }

    public void deleteCommerceTaxFixedRateByCommerceTaxMethodId(long commerceTaxMethodId) {
        this.commerceTaxFixedRatePersistence.removeByCommerceTaxMethodId(commerceTaxMethodId);
    }

    public void deleteCommerceTaxFixedRateByCPTaxCategoryId(long cpTaxCategoryId) {
        this.commerceTaxFixedRatePersistence.removeByCPTaxCategoryId(cpTaxCategoryId);
    }

    public CommerceTaxFixedRate fetchCommerceTaxFixedRate(long cpTaxCategoryId, long commerceTaxMethodId) throws PortalException {
        return this.commerceTaxFixedRatePersistence.fetchByC_C(cpTaxCategoryId, commerceTaxMethodId);
    }

    public CommerceTaxFixedRate getCommerceTaxFixedRate(long cpTaxCategoryId, long commerceTaxMethodId) throws PortalException {
        return this.commerceTaxFixedRatePersistence.fetchByC_C(cpTaxCategoryId, commerceTaxMethodId);
    }

    public List<CommerceTaxFixedRate> getCommerceTaxFixedRates(long commerceTaxMethodId, int start, int end, OrderByComparator<CommerceTaxFixedRate> orderByComparator) {
        return this.commerceTaxFixedRatePersistence.findByCommerceTaxMethodId(commerceTaxMethodId, start, end, orderByComparator);
    }

    public int getCommerceTaxFixedRatesCount(long commerceTaxMethodId) {
        return this.commerceTaxFixedRatePersistence.countByCommerceTaxMethodId(commerceTaxMethodId);
    }

    public CommerceTaxFixedRate updateCommerceTaxFixedRate(long commerceTaxFixedRateId, double rate) throws PortalException {
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRatePersistence.findByPrimaryKey(commerceTaxFixedRateId);
        commerceTaxFixedRate.setRate(rate);
        return (CommerceTaxFixedRate)this.commerceTaxFixedRatePersistence.update((BaseModel)commerceTaxFixedRate);
    }

    protected void validate(long cpTaxCategoryId, long commerceTaxMethodId) throws PortalException {
        int count = this.commerceTaxFixedRatePersistence.countByC_C(cpTaxCategoryId, commerceTaxMethodId);
        if (count > 0) {
            throw new DuplicateCommerceTaxFixedRateException();
        }
    }
}

