/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.engine.fixed.service.impl;

import com.liferay.commerce.tax.engine.fixed.model.CommerceTaxFixedRateAddressRel;
import com.liferay.commerce.tax.engine.fixed.service.base.CommerceTaxFixedRateAddressRelLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceTaxFixedRateAddressRelLocalServiceImpl
extends CommerceTaxFixedRateAddressRelLocalServiceBaseImpl {
    public CommerceTaxFixedRateAddressRel addCommerceTaxFixedRateAddressRel(long commerceTaxMethodId, long cpTaxCategoryId, long commerceCountryId, long commerceRegionId, String zip, double rate, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        long commerceTaxFixedRateAddressRelId = this.counterLocalService.increment();
        CommerceTaxFixedRateAddressRel commerceTaxFixedRateAddressRel = this.commerceTaxFixedRateAddressRelPersistence.create(commerceTaxFixedRateAddressRelId);
        commerceTaxFixedRateAddressRel.setGroupId(groupId);
        commerceTaxFixedRateAddressRel.setCompanyId(user.getCompanyId());
        commerceTaxFixedRateAddressRel.setUserId(user.getUserId());
        commerceTaxFixedRateAddressRel.setUserName(user.getFullName());
        commerceTaxFixedRateAddressRel.setCommerceTaxMethodId(commerceTaxMethodId);
        commerceTaxFixedRateAddressRel.setCPTaxCategoryId(cpTaxCategoryId);
        commerceTaxFixedRateAddressRel.setCommerceCountryId(commerceCountryId);
        commerceTaxFixedRateAddressRel.setCommerceRegionId(commerceRegionId);
        commerceTaxFixedRateAddressRel.setZip(zip);
        commerceTaxFixedRateAddressRel.setRate(rate);
        return (CommerceTaxFixedRateAddressRel)this.commerceTaxFixedRateAddressRelPersistence.update((BaseModel)commerceTaxFixedRateAddressRel);
    }

    public void deleteCommerceTaxFixedRateAddressRelsByCommerceTaxMethodId(long commerceTaxMethodId) {
        this.commerceTaxFixedRateAddressRelPersistence.removeByCommerceTaxMethodId(commerceTaxMethodId);
    }

    public void deleteCommerceTaxFixedRateAddressRelsByCPTaxCategoryId(long cpTaxCategoryId) {
        this.commerceTaxFixedRateAddressRelPersistence.removeByCPTaxCategoryId(cpTaxCategoryId);
    }

    public CommerceTaxFixedRateAddressRel fetchCommerceTaxFixedRateAddressRel(long commerceTaxMethodId, long commerceCountryId, long commerceRegionId, String zip) {
        return this.commerceTaxFixedRateAddressRelFinder.fetchByC_C_C_Z_First(commerceTaxMethodId, commerceCountryId, commerceRegionId, zip);
    }

    public List<CommerceTaxFixedRateAddressRel> getCommerceTaxFixedRateAddressRels(long cpTaxCategoryId, int start, int end) {
        return this.commerceTaxFixedRateAddressRelPersistence.findByCPTaxCategoryId(cpTaxCategoryId, start, end);
    }

    public List<CommerceTaxFixedRateAddressRel> getCommerceTaxFixedRateAddressRels(long cpTaxCategoryId, int start, int end, OrderByComparator<CommerceTaxFixedRateAddressRel> orderByComparator) {
        return this.commerceTaxFixedRateAddressRelPersistence.findByCPTaxCategoryId(cpTaxCategoryId, start, end, orderByComparator);
    }

    public int getCommerceTaxFixedRateAddressRelsCount(long cpTaxCategoryId) {
        return this.commerceTaxFixedRateAddressRelPersistence.countByCPTaxCategoryId(cpTaxCategoryId);
    }

    public List<CommerceTaxFixedRateAddressRel> getCommerceTaxMethodFixedRateAddressRels(long commerceTaxMethodId, int start, int end) {
        return this.commerceTaxFixedRateAddressRelPersistence.findByCommerceTaxMethodId(commerceTaxMethodId, start, end);
    }

    public List<CommerceTaxFixedRateAddressRel> getCommerceTaxMethodFixedRateAddressRels(long commerceTaxMethodId, int start, int end, OrderByComparator<CommerceTaxFixedRateAddressRel> orderByComparator) {
        return this.commerceTaxFixedRateAddressRelPersistence.findByCommerceTaxMethodId(commerceTaxMethodId, start, end, orderByComparator);
    }

    public int getCommerceTaxMethodFixedRateAddressRelsCount(long commerceTaxMethodId) {
        return this.commerceTaxFixedRateAddressRelPersistence.countByCommerceTaxMethodId(commerceTaxMethodId);
    }

    public CommerceTaxFixedRateAddressRel updateCommerceTaxFixedRateAddressRel(long commerceTaxFixedRateAddressRelId, long commerceCountryId, long commerceRegionId, String zip, double rate) throws PortalException {
        CommerceTaxFixedRateAddressRel commerceTaxFixedRateAddressRel = this.commerceTaxFixedRateAddressRelPersistence.findByPrimaryKey(commerceTaxFixedRateAddressRelId);
        commerceTaxFixedRateAddressRel.setCommerceCountryId(commerceCountryId);
        commerceTaxFixedRateAddressRel.setCommerceRegionId(commerceRegionId);
        commerceTaxFixedRateAddressRel.setZip(zip);
        commerceTaxFixedRateAddressRel.setRate(rate);
        return (CommerceTaxFixedRateAddressRel)this.commerceTaxFixedRateAddressRelPersistence.update((BaseModel)commerceTaxFixedRateAddressRel);
    }
}

