/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.engine.fixed.service.impl;

import com.liferay.commerce.tax.engine.fixed.model.CommerceTaxFixedRate;
import com.liferay.commerce.tax.engine.fixed.service.base.CommerceTaxFixedRateServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceTaxFixedRateServiceImpl
extends CommerceTaxFixedRateServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceTaxFixedRateServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public CommerceTaxFixedRate addCommerceTaxFixedRate(long commerceTaxMethodId, long cpTaxCategoryId, double rate, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COMMERCE_TAX_METHODS");
        return this.commerceTaxFixedRateLocalService.addCommerceTaxFixedRate(commerceTaxMethodId, cpTaxCategoryId, rate, serviceContext);
    }

    public void deleteCommerceTaxFixedRate(long commerceTaxFixedRateId) throws PortalException {
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRateLocalService.getCommerceTaxFixedRate(commerceTaxFixedRateId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceTaxFixedRate.getGroupId(), "MANAGE_COMMERCE_TAX_METHODS");
        this.commerceTaxFixedRateLocalService.deleteCommerceTaxFixedRate(commerceTaxFixedRate);
    }

    public CommerceTaxFixedRate fetchCommerceTaxFixedRate(long commerceTaxFixedRateId) throws PortalException {
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRateLocalService.fetchCommerceTaxFixedRate(commerceTaxFixedRateId);
        if (commerceTaxFixedRate != null) {
            _portletResourcePermission.check(this.getPermissionChecker(), commerceTaxFixedRate.getGroupId(), "MANAGE_COMMERCE_TAX_METHODS");
        }
        return commerceTaxFixedRate;
    }

    public CommerceTaxFixedRate fetchCommerceTaxFixedRate(long cpTaxCategoryId, long commerceTaxMethodId) throws PortalException {
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRateLocalService.fetchCommerceTaxFixedRate(cpTaxCategoryId, commerceTaxMethodId);
        if (commerceTaxFixedRate != null) {
            _portletResourcePermission.check(this.getPermissionChecker(), commerceTaxFixedRate.getGroupId(), "MANAGE_COMMERCE_TAX_METHODS");
        }
        return commerceTaxFixedRate;
    }

    public List<CommerceTaxFixedRate> getCommerceTaxFixedRates(long groupId, long commerceTaxMethodId, int start, int end, OrderByComparator<CommerceTaxFixedRate> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_TAX_METHODS");
        return this.commerceTaxFixedRateLocalService.getCommerceTaxFixedRates(commerceTaxMethodId, start, end, orderByComparator);
    }

    public int getCommerceTaxFixedRatesCount(long groupId, long commerceTaxMethodId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_TAX_METHODS");
        return this.commerceTaxFixedRateLocalService.getCommerceTaxFixedRatesCount(commerceTaxMethodId);
    }

    public CommerceTaxFixedRate updateCommerceTaxFixedRate(long commerceTaxFixedRateId, double rate) throws PortalException {
        CommerceTaxFixedRate commerceTaxFixedRate = this.commerceTaxFixedRateLocalService.getCommerceTaxFixedRate(commerceTaxFixedRateId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceTaxFixedRate.getGroupId(), "MANAGE_COMMERCE_TAX_METHODS");
        return this.commerceTaxFixedRateLocalService.updateCommerceTaxFixedRate(commerceTaxFixedRateId, rate);
    }
}

