/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.shipping.engine.fixed.internal.upgrade.v1_1_0;

import com.liferay.commerce.shipping.engine.fixed.model.impl.CommerceShippingFixedOptionRelImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author Alessio Antonio Rendina
 */
public class CommerceShippingFixedOptionRelUpgradeProcess
	extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		if (_log.isInfoEnabled()) {
			_log.info(
				String.format(
					"Renaming column %s to table %s", "commerceWarehouseId",
					CommerceShippingFixedOptionRelImpl.TABLE_NAME));
		}

		if (!hasColumn(
				CommerceShippingFixedOptionRelImpl.TABLE_NAME,
				"commerceInventoryWarehouseId")) {

			alter(
				CommerceShippingFixedOptionRelImpl.class,
				new AlterColumnName(
					"commerceWarehouseId",
					"commerceInventoryWarehouseId LONG"));
		}
		else {
			if (_log.isInfoEnabled()) {
				_log.info(
					String.format(
						"Column %s already exists on table %s",
						"commerceInventoryWarehouseId",
						CommerceShippingFixedOptionRelImpl.TABLE_NAME));
			}
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		CommerceShippingFixedOptionRelUpgradeProcess.class);

}