/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipping.engine.fixed.service.impl;

import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceShippingMethodService;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel;
import com.liferay.commerce.shipping.engine.fixed.service.base.CommerceShippingFixedOptionRelServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceShippingFixedOptionRel"}, service={AopService.class})
public class CommerceShippingFixedOptionRelServiceImpl
extends CommerceShippingFixedOptionRelServiceBaseImpl {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceChannel)")
    private ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission;
    @Reference
    private CommerceShippingMethodService _commerceShippingMethodService;

    public CommerceShippingFixedOptionRel addCommerceShippingFixedOptionRel(long groupId, long commerceInventoryWarehouseId, long commerceShippingFixedOptionId, long commerceShippingMethodId, long countryId, long regionId, BigDecimal fixedPrice, double ratePercentage, BigDecimal rateUnitWeightPrice, double weightFrom, double weightTo, String zip) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingFixedOptionRelLocalService.addCommerceShippingFixedOptionRel(this.getUserId(), groupId, commerceInventoryWarehouseId, commerceShippingFixedOptionId, commerceShippingMethodId, countryId, regionId, fixedPrice, ratePercentage, rateUnitWeightPrice, weightFrom, weightTo, zip);
    }

    public void deleteCommerceShippingFixedOptionRel(long commerceShippingFixedOptionRelId) throws PortalException {
        CommerceShippingFixedOptionRel commerceShippingFixedOptionRel = this.commerceShippingFixedOptionRelLocalService.getCommerceShippingFixedOptionRel(commerceShippingFixedOptionRelId);
        this._checkCommerceChannel(commerceShippingFixedOptionRel.getGroupId());
        this.commerceShippingFixedOptionRelLocalService.deleteCommerceShippingFixedOptionRel(commerceShippingFixedOptionRel);
    }

    public CommerceShippingFixedOptionRel fetchCommerceShippingFixedOptionRel(long commerceShippingFixedOptionRelId) throws PortalException {
        CommerceShippingFixedOptionRel commerceShippingFixedOptionRel = this.commerceShippingFixedOptionRelLocalService.fetchCommerceShippingFixedOptionRel(commerceShippingFixedOptionRelId);
        if (commerceShippingFixedOptionRel != null) {
            this._checkCommerceChannel(commerceShippingFixedOptionRel.getGroupId());
        }
        return commerceShippingFixedOptionRel;
    }

    public List<CommerceShippingFixedOptionRel> getCommerceShippingFixedOptionRels(long commerceShippingFixedOptionId, long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceShippingFixedOptionRel> orderByComparator) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        return this.commerceShippingFixedOptionRelLocalService.getCommerceShippingFixedOptionRels(commerceShippingFixedOptionId, commerceShippingMethod.getCommerceShippingMethodId(), start, end, orderByComparator);
    }

    public int getCommerceShippingFixedOptionRelsCount(long commerceShippingFixedOptionId, long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        return this.commerceShippingFixedOptionRelLocalService.getCommerceShippingFixedOptionRelsCount(commerceShippingFixedOptionId, commerceShippingMethod.getCommerceShippingMethodId());
    }

    public List<CommerceShippingFixedOptionRel> getCommerceShippingMethodFixedOptionRels(long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceShippingFixedOptionRel> orderByComparator) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        return this.commerceShippingFixedOptionRelLocalService.getCommerceShippingMethodFixedOptionRels(commerceShippingMethod.getCommerceShippingMethodId(), start, end, orderByComparator);
    }

    public int getCommerceShippingMethodFixedOptionRelsCount(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        return this.commerceShippingFixedOptionRelLocalService.getCommerceShippingMethodFixedOptionRelsCount(commerceShippingMethod.getCommerceShippingMethodId());
    }

    public CommerceShippingFixedOptionRel updateCommerceShippingFixedOptionRel(long commerceShippingFixedOptionRelId, long commerceInventoryWarehouseId, long countryId, long regionId, BigDecimal fixedPrice, double ratePercentage, BigDecimal rateUnitWeightPrice, double weightFrom, double weightTo, String zip) throws PortalException {
        CommerceShippingFixedOptionRel commerceShippingFixedOptionRel = this.commerceShippingFixedOptionRelLocalService.getCommerceShippingFixedOptionRel(commerceShippingFixedOptionRelId);
        this._checkCommerceChannel(commerceShippingFixedOptionRel.getGroupId());
        return this.commerceShippingFixedOptionRelLocalService.updateCommerceShippingFixedOptionRel(commerceShippingFixedOptionRelId, commerceInventoryWarehouseId, countryId, regionId, fixedPrice, ratePercentage, rateUnitWeightPrice, weightFrom, weightTo, zip);
    }

    private void _checkCommerceChannel(long groupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
        this._commerceChannelModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceChannel, "UPDATE");
    }
}

