/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipping.engine.fixed.internal.search;

import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Indexer.class})
public class CommerceShippingFixedOptionIndexer
extends BaseIndexer<CommerceShippingFixedOption> {
    public static final String CLASS_NAME = CommerceShippingFixedOption.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CommerceShippingFixedOptionIndexer.class);
    @Reference
    private CommerceShippingFixedOptionLocalService _commerceShippingFixedOptionLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommerceShippingFixedOptionIndexer() {
        this.setFilterSearch(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long commerceShippingMethodId = (Long)searchContext.getAttribute("commerceShippingMethodId");
        if (commerceShippingMethodId != -1L) {
            TermFilter termFilter = new TermFilter("commerceShippingMethodId", String.valueOf(commerceShippingMethodId));
            contextBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        super.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "name", true);
        this.addSearchTerm(searchQuery, searchContext, "commerceShippingMethodId", false);
        this.addSearchTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "key", true);
    }

    protected void doDelete(CommerceShippingFixedOption commerceShippingFixedOption) throws Exception {
        this.deleteDocument(commerceShippingFixedOption.getCompanyId(), commerceShippingFixedOption.getCommerceShippingFixedOptionId());
    }

    protected Document doGetDocument(CommerceShippingFixedOption commerceShippingFixedOption) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing shipping fixed option " + commerceShippingFixedOption));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceShippingFixedOption);
        document.addKeyword("description", commerceShippingFixedOption.getDescription());
        document.addKeyword("name", commerceShippingFixedOption.getName());
        document.addKeyword("commerceShippingMethodId", commerceShippingFixedOption.getCommerceShippingMethodId());
        document.addKeyword("key", commerceShippingFixedOption.getKey());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceShippingFixedOption + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return null;
    }

    protected void doReindex(CommerceShippingFixedOption commerceShippingFixedOption) throws Exception {
        this._indexWriterHelper.updateDocument(commerceShippingFixedOption.getCompanyId(), this.getDocument(commerceShippingFixedOption));
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceShippingFixedOptionLocalService.getCommerceShippingFixedOption(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexCommerceShippingFixedOptions(companyId);
    }

    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        Boolean useSearchResultPermissionFilter = (Boolean)searchContext.getAttribute("useSearchResultPermissionFilter");
        if (useSearchResultPermissionFilter != null) {
            return useSearchResultPermissionFilter;
        }
        return super.isUseSearchResultPermissionFilter(searchContext);
    }

    private void _reindexCommerceShippingFixedOptions(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceShippingFixedOptionLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceShippingFixedOption -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceShippingFixedOption)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    long commerceShippingFixedOptionId = commerceShippingFixedOption.getCommerceShippingFixedOptionId();
                    _log.warn((Object)("Unable to index commerce shipping fixed option " + commerceShippingFixedOptionId), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.performActions();
    }
}

