/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipping.engine.fixed.service.impl;

import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceShippingMethodService;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.base.CommerceShippingFixedOptionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceShippingFixedOption"}, service={AopService.class})
public class CommerceShippingFixedOptionServiceImpl
extends CommerceShippingFixedOptionServiceBaseImpl {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceChannel)")
    private ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission;
    @Reference
    private CommerceShippingMethodService _commerceShippingMethodService;

    public CommerceShippingFixedOption addCommerceShippingFixedOption(long groupId, long commerceShippingMethodId, BigDecimal amount, Map<Locale, String> descriptionMap, String key, Map<Locale, String> nameMap, double priority) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingFixedOptionLocalService.addCommerceShippingFixedOption(this.getUserId(), groupId, commerceShippingMethodId, amount, descriptionMap, key, nameMap, priority);
    }

    public void deleteCommerceShippingFixedOption(long commerceShippingFixedOptionId) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOption(commerceShippingFixedOptionId);
        this._checkCommerceChannel(commerceShippingFixedOption.getGroupId());
        this.commerceShippingFixedOptionLocalService.deleteCommerceShippingFixedOption(commerceShippingFixedOption);
    }

    public CommerceShippingFixedOption fetchCommerceShippingFixedOption(long commerceShippingFixedOptionId) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(commerceShippingFixedOptionId);
        if (commerceShippingFixedOption != null) {
            this._checkCommerceChannel(commerceShippingFixedOption.getGroupId());
        }
        return commerceShippingFixedOption;
    }

    public CommerceShippingFixedOption fetchCommerceShippingFixedOption(long companyId, String key) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(companyId, key);
        if (commerceShippingFixedOption != null) {
            this._checkCommerceChannel(commerceShippingFixedOption.getGroupId());
        }
        return commerceShippingFixedOption;
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long commerceShippingMethodId, int start, int end) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        return this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOptions(commerceShippingMethod.getCommerceShippingMethodId(), start, end);
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceShippingFixedOption> orderByComparator) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        return this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOptions(commerceShippingMethod.getCommerceShippingMethodId(), start, end, orderByComparator);
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long companyId, long groupId, long commerceShippingMethodId, String keywords, int start, int end) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOptions(companyId, groupId, commerceShippingMethodId, keywords, start, end);
    }

    public int getCommerceShippingFixedOptionsCount(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        return this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOptionsCount(commerceShippingMethod.getCommerceShippingMethodId());
    }

    public long getCommerceShippingFixedOptionsCount(long companyId, long groupId, long commerceShippingMethodId, String keywords) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOptionsCount(companyId, groupId, commerceShippingMethodId, keywords);
    }

    public CommerceShippingFixedOption updateCommerceShippingFixedOption(long commerceShippingFixedOptionId, BigDecimal amount, Map<Locale, String> descriptionMap, String key, Map<Locale, String> nameMap, double priority) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOption(commerceShippingFixedOptionId);
        this._checkCommerceChannel(commerceShippingFixedOption.getGroupId());
        return this.commerceShippingFixedOptionLocalService.updateCommerceShippingFixedOption(commerceShippingFixedOptionId, amount, descriptionMap, key, nameMap, priority);
    }

    private void _checkCommerceChannel(long groupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
        this._commerceChannelModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceChannel, "UPDATE");
    }
}

