/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.shipping.engine.fixed.model.impl;

import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionQualifier;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionQualifierModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceShippingFixedOptionQualifier service. Represents a row in the &quot;CSFixedOptionQualifier&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceShippingFixedOptionQualifierModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceShippingFixedOptionQualifierImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShippingFixedOptionQualifierImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceShippingFixedOptionQualifierModelImpl
	extends BaseModelImpl<CommerceShippingFixedOptionQualifier>
	implements CommerceShippingFixedOptionQualifierModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce shipping fixed option qualifier model instance should use the <code>CommerceShippingFixedOptionQualifier</code> interface instead.
	 */
	public static final String TABLE_NAME = "CSFixedOptionQualifier";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT},
		{"CSFixedOptionQualifierId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"commerceShippingFixedOptionId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CSFixedOptionQualifierId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceShippingFixedOptionId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CSFixedOptionQualifier (mvccVersion LONG default 0 not null,CSFixedOptionQualifierId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,commerceShippingFixedOptionId LONG)";

	public static final String TABLE_SQL_DROP =
		"drop table CSFixedOptionQualifier";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceShippingFixedOptionQualifier.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CSFixedOptionQualifier.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCESHIPPINGFIXEDOPTIONID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 8L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.shipping.engine.fixed.service.util.ServiceProps.
			get(
				"lock.expiration.time.com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionQualifier"));

	public CommerceShippingFixedOptionQualifierModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceShippingFixedOptionQualifierId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceShippingFixedOptionQualifierId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceShippingFixedOptionQualifierId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceShippingFixedOptionQualifier.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceShippingFixedOptionQualifier.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceShippingFixedOptionQualifier, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry
				<String, Function<CommerceShippingFixedOptionQualifier, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceShippingFixedOptionQualifier, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceShippingFixedOptionQualifier)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceShippingFixedOptionQualifier, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceShippingFixedOptionQualifier, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceShippingFixedOptionQualifier)this,
					entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceShippingFixedOptionQualifier, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceShippingFixedOptionQualifier, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map
		<String, Function<CommerceShippingFixedOptionQualifier, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<CommerceShippingFixedOptionQualifier, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceShippingFixedOptionQualifier, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String,
					 Function<CommerceShippingFixedOptionQualifier, Object>>();
		Map<String, BiConsumer<CommerceShippingFixedOptionQualifier, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String,
					 BiConsumer<CommerceShippingFixedOptionQualifier, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion",
			CommerceShippingFixedOptionQualifier::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<CommerceShippingFixedOptionQualifier, Long>)
				CommerceShippingFixedOptionQualifier::setMvccVersion);
		attributeGetterFunctions.put(
			"commerceShippingFixedOptionQualifierId",
			CommerceShippingFixedOptionQualifier::
				getCommerceShippingFixedOptionQualifierId);
		attributeSetterBiConsumers.put(
			"commerceShippingFixedOptionQualifierId",
			(BiConsumer<CommerceShippingFixedOptionQualifier, Long>)
				CommerceShippingFixedOptionQualifier::
					setCommerceShippingFixedOptionQualifierId);
		attributeGetterFunctions.put(
			"companyId", CommerceShippingFixedOptionQualifier::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceShippingFixedOptionQualifier, Long>)
				CommerceShippingFixedOptionQualifier::setCompanyId);
		attributeGetterFunctions.put(
			"userId", CommerceShippingFixedOptionQualifier::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceShippingFixedOptionQualifier, Long>)
				CommerceShippingFixedOptionQualifier::setUserId);
		attributeGetterFunctions.put(
			"userName", CommerceShippingFixedOptionQualifier::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceShippingFixedOptionQualifier, String>)
				CommerceShippingFixedOptionQualifier::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceShippingFixedOptionQualifier::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceShippingFixedOptionQualifier, Date>)
				CommerceShippingFixedOptionQualifier::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate",
			CommerceShippingFixedOptionQualifier::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceShippingFixedOptionQualifier, Date>)
				CommerceShippingFixedOptionQualifier::setModifiedDate);
		attributeGetterFunctions.put(
			"classNameId",
			CommerceShippingFixedOptionQualifier::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<CommerceShippingFixedOptionQualifier, Long>)
				CommerceShippingFixedOptionQualifier::setClassNameId);
		attributeGetterFunctions.put(
			"classPK", CommerceShippingFixedOptionQualifier::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK",
			(BiConsumer<CommerceShippingFixedOptionQualifier, Long>)
				CommerceShippingFixedOptionQualifier::setClassPK);
		attributeGetterFunctions.put(
			"commerceShippingFixedOptionId",
			CommerceShippingFixedOptionQualifier::
				getCommerceShippingFixedOptionId);
		attributeSetterBiConsumers.put(
			"commerceShippingFixedOptionId",
			(BiConsumer<CommerceShippingFixedOptionQualifier, Long>)
				CommerceShippingFixedOptionQualifier::
					setCommerceShippingFixedOptionId);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCommerceShippingFixedOptionQualifierId() {
		return _commerceShippingFixedOptionQualifierId;
	}

	@Override
	public void setCommerceShippingFixedOptionQualifierId(
		long commerceShippingFixedOptionQualifierId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceShippingFixedOptionQualifierId =
			commerceShippingFixedOptionQualifierId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public long getCommerceShippingFixedOptionId() {
		return _commerceShippingFixedOptionId;
	}

	@Override
	public void setCommerceShippingFixedOptionId(
		long commerceShippingFixedOptionId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceShippingFixedOptionId = commerceShippingFixedOptionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceShippingFixedOptionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceShippingFixedOptionId"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(),
			CommerceShippingFixedOptionQualifier.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceShippingFixedOptionQualifier toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceShippingFixedOptionQualifier>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceShippingFixedOptionQualifierImpl
			commerceShippingFixedOptionQualifierImpl =
				new CommerceShippingFixedOptionQualifierImpl();

		commerceShippingFixedOptionQualifierImpl.setMvccVersion(
			getMvccVersion());
		commerceShippingFixedOptionQualifierImpl.
			setCommerceShippingFixedOptionQualifierId(
				getCommerceShippingFixedOptionQualifierId());
		commerceShippingFixedOptionQualifierImpl.setCompanyId(getCompanyId());
		commerceShippingFixedOptionQualifierImpl.setUserId(getUserId());
		commerceShippingFixedOptionQualifierImpl.setUserName(getUserName());
		commerceShippingFixedOptionQualifierImpl.setCreateDate(getCreateDate());
		commerceShippingFixedOptionQualifierImpl.setModifiedDate(
			getModifiedDate());
		commerceShippingFixedOptionQualifierImpl.setClassNameId(
			getClassNameId());
		commerceShippingFixedOptionQualifierImpl.setClassPK(getClassPK());
		commerceShippingFixedOptionQualifierImpl.
			setCommerceShippingFixedOptionId(
				getCommerceShippingFixedOptionId());

		commerceShippingFixedOptionQualifierImpl.resetOriginalValues();

		return commerceShippingFixedOptionQualifierImpl;
	}

	@Override
	public CommerceShippingFixedOptionQualifier cloneWithOriginalValues() {
		CommerceShippingFixedOptionQualifierImpl
			commerceShippingFixedOptionQualifierImpl =
				new CommerceShippingFixedOptionQualifierImpl();

		commerceShippingFixedOptionQualifierImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceShippingFixedOptionQualifierImpl.
			setCommerceShippingFixedOptionQualifierId(
				this.<Long>getColumnOriginalValue("CSFixedOptionQualifierId"));
		commerceShippingFixedOptionQualifierImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceShippingFixedOptionQualifierImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceShippingFixedOptionQualifierImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceShippingFixedOptionQualifierImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceShippingFixedOptionQualifierImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceShippingFixedOptionQualifierImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		commerceShippingFixedOptionQualifierImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		commerceShippingFixedOptionQualifierImpl.
			setCommerceShippingFixedOptionId(
				this.<Long>getColumnOriginalValue(
					"commerceShippingFixedOptionId"));

		return commerceShippingFixedOptionQualifierImpl;
	}

	@Override
	public int compareTo(
		CommerceShippingFixedOptionQualifier
			commerceShippingFixedOptionQualifier) {

		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(),
			commerceShippingFixedOptionQualifier.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceShippingFixedOptionQualifier)) {
			return false;
		}

		CommerceShippingFixedOptionQualifier
			commerceShippingFixedOptionQualifier =
				(CommerceShippingFixedOptionQualifier)object;

		long primaryKey = commerceShippingFixedOptionQualifier.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceShippingFixedOptionQualifier> toCacheModel() {
		CommerceShippingFixedOptionQualifierCacheModel
			commerceShippingFixedOptionQualifierCacheModel =
				new CommerceShippingFixedOptionQualifierCacheModel();

		commerceShippingFixedOptionQualifierCacheModel.mvccVersion =
			getMvccVersion();

		commerceShippingFixedOptionQualifierCacheModel.
			commerceShippingFixedOptionQualifierId =
				getCommerceShippingFixedOptionQualifierId();

		commerceShippingFixedOptionQualifierCacheModel.companyId =
			getCompanyId();

		commerceShippingFixedOptionQualifierCacheModel.userId = getUserId();

		commerceShippingFixedOptionQualifierCacheModel.userName = getUserName();

		String userName =
			commerceShippingFixedOptionQualifierCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceShippingFixedOptionQualifierCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceShippingFixedOptionQualifierCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceShippingFixedOptionQualifierCacheModel.createDate =
				Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceShippingFixedOptionQualifierCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceShippingFixedOptionQualifierCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		commerceShippingFixedOptionQualifierCacheModel.classNameId =
			getClassNameId();

		commerceShippingFixedOptionQualifierCacheModel.classPK = getClassPK();

		commerceShippingFixedOptionQualifierCacheModel.
			commerceShippingFixedOptionId = getCommerceShippingFixedOptionId();

		return commerceShippingFixedOptionQualifierCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceShippingFixedOptionQualifier, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry
				<String, Function<CommerceShippingFixedOptionQualifier, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceShippingFixedOptionQualifier, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceShippingFixedOptionQualifier)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceShippingFixedOptionQualifier, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry
				<String, Function<CommerceShippingFixedOptionQualifier, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceShippingFixedOptionQualifier, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(CommerceShippingFixedOptionQualifier)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceShippingFixedOptionQualifier>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						CommerceShippingFixedOptionQualifier.class,
						ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _commerceShippingFixedOptionQualifierId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private long _commerceShippingFixedOptionId;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceShippingFixedOptionQualifier, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceShippingFixedOptionQualifier)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"CSFixedOptionQualifierId",
			_commerceShippingFixedOptionQualifierId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put(
			"commerceShippingFixedOptionId", _commerceShippingFixedOptionId);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put(
			"CSFixedOptionQualifierId",
			"commerceShippingFixedOptionQualifierId");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("CSFixedOptionQualifierId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("classNameId", 128L);

		columnBitmasks.put("classPK", 256L);

		columnBitmasks.put("commerceShippingFixedOptionId", 512L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceShippingFixedOptionQualifier _escapedModel;

}