/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.shipping.engine.fixed.model.impl;

import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionQualifier;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionQualifierLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceShippingFixedOptionQualifier service. Represents a row in the &quot;CSFixedOptionQualifier&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceShippingFixedOptionQualifierImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShippingFixedOptionQualifierImpl
 * @see CommerceShippingFixedOptionQualifier
 * @generated
 */
public abstract class CommerceShippingFixedOptionQualifierBaseImpl
	extends CommerceShippingFixedOptionQualifierModelImpl
	implements CommerceShippingFixedOptionQualifier {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce shipping fixed option qualifier model instance should use the <code>CommerceShippingFixedOptionQualifier</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceShippingFixedOptionQualifierLocalServiceUtil.
				addCommerceShippingFixedOptionQualifier(this);
		}
		else {
			CommerceShippingFixedOptionQualifierLocalServiceUtil.
				updateCommerceShippingFixedOptionQualifier(this);
		}
	}

}