/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.shipping.engine.fixed.internal.upgrade;

import com.liferay.commerce.shipping.engine.fixed.internal.upgrade.v1_1_0.CommerceShippingFixedOptionRelUpgradeProcess;
import com.liferay.commerce.shipping.engine.fixed.internal.upgrade.v2_2_0.CommerceShippingFixedOptionQualifierUpgradeProcess;
import com.liferay.commerce.shipping.engine.fixed.internal.upgrade.v2_3_0.CommerceShippingFixedOptionUpgradeProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.MVCCVersionUpgradeProcess;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	enabled = false, immediate = true, service = UpgradeStepRegistrator.class
)
public class CommerceShippingEngineFixedUpgradeStepRegistrator
	implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		if (_log.isInfoEnabled()) {
			_log.info(
				"Commerce shipping engine fixed upgrade step registrator " +
					"STARTED");
		}

		registry.register(
			"1.0.0", "1.1.0",
			new CommerceShippingFixedOptionRelUpgradeProcess());

		registry.register(
			"1.1.0", "2.0.0",
			new com.liferay.commerce.shipping.engine.fixed.internal.upgrade.
				v2_0_0.CommerceShippingFixedOptionRelUpgradeProcess());

		registry.register(
			"2.0.0", "2.1.0",
			new MVCCVersionUpgradeProcess() {

				@Override
				protected String[] getModuleTableNames() {
					return new String[] {
						"CShippingFixedOptionRel", "CommerceShippingFixedOption"
					};
				}

			});

		registry.register(
			"2.1.0", "2.2.0",
			new CommerceShippingFixedOptionQualifierUpgradeProcess());

		registry.register(
			"2.2.0", "2.3.0", new CommerceShippingFixedOptionUpgradeProcess());

		if (_log.isInfoEnabled()) {
			_log.info(
				"Commerce shipping engine fixed upgrade step registrator " +
					"finished");
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		CommerceShippingEngineFixedUpgradeStepRegistrator.class);

}