/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipping.engine.fixed.service.impl;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceShippingMethodTable;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionQualifierTable;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionTable;
import com.liferay.commerce.shipping.engine.fixed.service.base.CommerceShippingFixedOptionLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class CommerceShippingFixedOptionLocalServiceImpl
extends CommerceShippingFixedOptionLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public CommerceShippingFixedOption addCommerceShippingFixedOption(long userId, long groupId, long commerceShippingMethodId, BigDecimal amount, Map<Locale, String> descriptionMap, Map<Locale, String> nameMap, double priority) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long commerceShippingFixedOptionId = this.counterLocalService.increment();
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionPersistence.create(commerceShippingFixedOptionId);
        commerceShippingFixedOption.setGroupId(groupId);
        commerceShippingFixedOption.setCompanyId(user.getCompanyId());
        commerceShippingFixedOption.setUserId(user.getUserId());
        commerceShippingFixedOption.setUserName(user.getFullName());
        commerceShippingFixedOption.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceShippingFixedOption.setAmount(amount);
        commerceShippingFixedOption.setDescriptionMap(descriptionMap);
        commerceShippingFixedOption.setKey(this._getKey(user.getCompanyId(), nameMap));
        commerceShippingFixedOption.setNameMap(nameMap);
        commerceShippingFixedOption.setPriority(priority);
        return (CommerceShippingFixedOption)this.commerceShippingFixedOptionPersistence.update((BaseModel)commerceShippingFixedOption);
    }

    @Deprecated
    public CommerceShippingFixedOption addCommerceShippingFixedOption(long commerceShippingMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, BigDecimal amount, double priority, ServiceContext serviceContext) throws PortalException {
        return this.commerceShippingFixedOptionLocalService.addCommerceShippingFixedOption(serviceContext.getUserId(), serviceContext.getScopeGroupId(), commerceShippingMethodId, amount, descriptionMap, nameMap, priority);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShippingFixedOption deleteCommerceShippingFixedOption(CommerceShippingFixedOption commerceShippingFixedOption) {
        this.commerceShippingFixedOptionPersistence.remove((BaseModel)commerceShippingFixedOption);
        this.commerceShippingFixedOptionRelLocalService.deleteCommerceShippingFixedOptionRels(commerceShippingFixedOption.getCommerceShippingFixedOptionId());
        return commerceShippingFixedOption;
    }

    public void deleteCommerceShippingFixedOptions(long commerceShippingMethodId) {
        this.commerceShippingFixedOptionPersistence.removeByCommerceShippingMethodId(commerceShippingMethodId);
    }

    public CommerceShippingFixedOption fetchCommerceShippingFixedOption(long companyId, String key) {
        return this.commerceShippingFixedOptionPersistence.fetchByC_K(companyId, key);
    }

    public List<CommerceShippingFixedOption> getCommerceOrderTypeCommerceShippingFixedOptions(long companyId, long commerceOrderTypeId, long commerceShippingMethodId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(companyId, commerceOrderTypeId, commerceShippingMethodId, DSLQueryFactoryUtil.selectDistinct((Table)CommerceShippingFixedOptionTable.INSTANCE)));
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long commerceShippingMethodId, int start, int end) {
        return this.commerceShippingFixedOptionPersistence.findByCommerceShippingMethodId(commerceShippingMethodId, start, end);
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceShippingFixedOption> orderByComparator) {
        return this.commerceShippingFixedOptionPersistence.findByCommerceShippingMethodId(commerceShippingMethodId, start, end, orderByComparator);
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long companyId, long groupId, long commerceShippingMethodId, String keywords, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, commerceShippingMethodId, keywords, start, end);
        BaseModelSearchResult<CommerceShippingFixedOption> baseModelSearchResult = this.searchCommerceShippingFixedOption(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public int getCommerceShippingFixedOptionsCount(long commerceShippingMethodId) {
        return this.commerceShippingFixedOptionPersistence.countByCommerceShippingMethodId(commerceShippingMethodId);
    }

    public long getCommerceShippingFixedOptionsCount(long companyId, long groupId, long commerceShippingMethodId, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, commerceShippingMethodId, keywords, 0, 0);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceShippingFixedOption.class.getName());
        return indexer.searchCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BaseModelSearchResult<CommerceShippingFixedOption> searchCommerceShippingFixedOption(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceShippingFixedOption.class.getName());
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<CommerceShippingFixedOption> commerceShippingFixedOptions = this.getCommerceShippingFixedOptions(hits);
            if (commerceShippingFixedOptions == null) continue;
            return new BaseModelSearchResult(commerceShippingFixedOptions, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public CommerceShippingFixedOption updateCommerceShippingFixedOption(long commerceShippingFixedOptionId, BigDecimal amount, Map<Locale, String> descriptionMap, Map<Locale, String> nameMap, double priority) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionPersistence.findByPrimaryKey(commerceShippingFixedOptionId);
        commerceShippingFixedOption.setAmount(amount);
        commerceShippingFixedOption.setDescriptionMap(descriptionMap);
        commerceShippingFixedOption.setNameMap(nameMap);
        commerceShippingFixedOption.setPriority(priority);
        if (Validator.isNull((String)commerceShippingFixedOption.getKey())) {
            commerceShippingFixedOption.setKey(this._getKey(commerceShippingFixedOption.getCompanyId(), nameMap));
        }
        return (CommerceShippingFixedOption)this.commerceShippingFixedOptionPersistence.update((BaseModel)commerceShippingFixedOption);
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, long commerceShippingMethodId, String keywords, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("commerceShippingMethodId", (Serializable)Long.valueOf(commerceShippingMethodId));
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setKeywords(keywords);
        Sort sort = SortFactoryUtil.getSort(CommerceShippingFixedOption.class, (int)6, (String)"createDate", (String)"DESC");
        searchContext.setSorts(new Sort[]{sort});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceShippingFixedOption> commerceShippingFixedOptions = new ArrayList<CommerceShippingFixedOption>(documents.size());
        for (Document document : documents) {
            long commerceShippingFixedOptionId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceShippingFixedOption commerceShippingFixedOption = this.fetchCommerceShippingFixedOption(commerceShippingFixedOptionId);
            if (commerceShippingFixedOption == null) {
                commerceShippingFixedOption = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceShippingFixedOption.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceShippingFixedOptions == null) continue;
            commerceShippingFixedOptions.add(commerceShippingFixedOption);
        }
        return commerceShippingFixedOptions;
    }

    private GroupByStep _getGroupByStep(Long companyId, Long commerceOrderTypeId, Long commerceShippingMethodId, FromStep fromStep) {
        CommerceShippingFixedOptionQualifierTable commerceOrderTypeCommerceShippingFixedQualifier = (CommerceShippingFixedOptionQualifierTable)CommerceShippingFixedOptionQualifierTable.INSTANCE.as("commerceOrderTypeCommerceShippingFixedQualifier");
        JoinStep joinStep = fromStep.from((Table)CommerceShippingFixedOptionTable.INSTANCE).innerJoinON((Table)CommerceShippingMethodTable.INSTANCE, CommerceShippingMethodTable.INSTANCE.commerceShippingMethodId.eq((Expression)CommerceShippingFixedOptionTable.INSTANCE.commerceShippingMethodId)).leftJoinOn((Table)commerceOrderTypeCommerceShippingFixedQualifier, this._getPredicate(CommerceOrderType.class.getName(), (Column<CommerceShippingFixedOptionQualifierTable, Long>)commerceOrderTypeCommerceShippingFixedQualifier.classNameId, (Column<CommerceShippingFixedOptionQualifierTable, Long>)commerceOrderTypeCommerceShippingFixedQualifier.commerceShippingFixedOptionId));
        Column classPKColumn = commerceOrderTypeCommerceShippingFixedQualifier.classPK;
        return joinStep.where(CommerceShippingFixedOptionTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceShippingFixedOptionTable.INSTANCE.commerceShippingMethodId.eq((Object)commerceShippingMethodId)).and((Expression)Predicate.withParentheses((Predicate)classPKColumn.eq((Object)commerceOrderTypeId).or((Expression)commerceOrderTypeCommerceShippingFixedQualifier.commerceShippingFixedOptionId.isNull()))));
    }

    private String _getKey(long companyId, Map<Locale, String> nameMap) {
        CommerceShippingFixedOption commerceShippingFixedOption;
        String key = FriendlyURLNormalizerUtil.normalize((String)nameMap.get(LocaleThreadLocal.getDefaultLocale()));
        if (Validator.isNull((String)key)) {
            Collection<String> values = nameMap.values();
            Stream<String> stream = values.stream();
            Optional<String> firstOptional = stream.filter(value -> Validator.isNotNull((String)value)).findFirst();
            key = FriendlyURLNormalizerUtil.normalize((String)firstOptional.get());
        }
        if ((commerceShippingFixedOption = this.commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(companyId, key)) != null) {
            key = key + StringUtil.randomString((int)5);
        }
        return key;
    }

    private Predicate _getPredicate(String className, Column<CommerceShippingFixedOptionQualifierTable, Long> classNameIdColumn, Column<CommerceShippingFixedOptionQualifierTable, Long> commerceShippingFixedOptionIdColumn) {
        return classNameIdColumn.eq((Object)this.classNameLocalService.getClassNameId(className)).and((Expression)commerceShippingFixedOptionIdColumn.eq((Expression)CommerceShippingFixedOptionTable.INSTANCE.commerceShippingFixedOptionId));
    }
}

