/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.shipping.engine.fixed.model.impl;

import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRelModel;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRelSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceShippingFixedOptionRel service. Represents a row in the &quot;CShippingFixedOptionRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceShippingFixedOptionRelModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceShippingFixedOptionRelImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShippingFixedOptionRelImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceShippingFixedOptionRelModelImpl
	extends BaseModelImpl<CommerceShippingFixedOptionRel>
	implements CommerceShippingFixedOptionRelModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce shipping fixed option rel model instance should use the <code>CommerceShippingFixedOptionRel</code> interface instead.
	 */
	public static final String TABLE_NAME = "CShippingFixedOptionRel";

	public static final Object[][] TABLE_COLUMNS = {
		{"CShippingFixedOptionRelId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP},
		{"commerceShippingMethodId", Types.BIGINT},
		{"commerceShippingFixedOptionId", Types.BIGINT},
		{"commerceInventoryWarehouseId", Types.BIGINT},
		{"commerceCountryId", Types.BIGINT}, {"commerceRegionId", Types.BIGINT},
		{"zip", Types.VARCHAR}, {"weightFrom", Types.DOUBLE},
		{"weightTo", Types.DOUBLE}, {"fixedPrice", Types.DECIMAL},
		{"rateUnitWeightPrice", Types.DECIMAL}, {"ratePercentage", Types.DOUBLE}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("CShippingFixedOptionRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceShippingMethodId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceShippingFixedOptionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceInventoryWarehouseId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceCountryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceRegionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("zip", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("weightFrom", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("weightTo", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("fixedPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("rateUnitWeightPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("ratePercentage", Types.DOUBLE);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CShippingFixedOptionRel (CShippingFixedOptionRelId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceShippingMethodId LONG,commerceShippingFixedOptionId LONG,commerceInventoryWarehouseId LONG,commerceCountryId LONG,commerceRegionId LONG,zip VARCHAR(75) null,weightFrom DOUBLE,weightTo DOUBLE,fixedPrice DECIMAL(30, 16) null,rateUnitWeightPrice DECIMAL(30, 16) null,ratePercentage DOUBLE)";

	public static final String TABLE_SQL_DROP =
		"drop table CShippingFixedOptionRel";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceShippingFixedOptionRel.commerceCountryId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CShippingFixedOptionRel.commerceCountryId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.shipping.engine.fixed.service.util.ServiceProps.
			get(
				"value.object.entity.cache.enabled.com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.shipping.engine.fixed.service.util.ServiceProps.
			get(
				"value.object.finder.cache.enabled.com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.shipping.engine.fixed.service.util.ServiceProps.
			get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel"),
		true);

	public static final long COMMERCESHIPPINGFIXEDOPTIONID_COLUMN_BITMASK = 1L;

	public static final long COMMERCESHIPPINGMETHODID_COLUMN_BITMASK = 2L;

	public static final long COMMERCECOUNTRYID_COLUMN_BITMASK = 4L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceShippingFixedOptionRel toModel(
		CommerceShippingFixedOptionRelSoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		CommerceShippingFixedOptionRel model =
			new CommerceShippingFixedOptionRelImpl();

		model.setCommerceShippingFixedOptionRelId(
			soapModel.getCommerceShippingFixedOptionRelId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceShippingMethodId(
			soapModel.getCommerceShippingMethodId());
		model.setCommerceShippingFixedOptionId(
			soapModel.getCommerceShippingFixedOptionId());
		model.setCommerceInventoryWarehouseId(
			soapModel.getCommerceInventoryWarehouseId());
		model.setCommerceCountryId(soapModel.getCommerceCountryId());
		model.setCommerceRegionId(soapModel.getCommerceRegionId());
		model.setZip(soapModel.getZip());
		model.setWeightFrom(soapModel.getWeightFrom());
		model.setWeightTo(soapModel.getWeightTo());
		model.setFixedPrice(soapModel.getFixedPrice());
		model.setRateUnitWeightPrice(soapModel.getRateUnitWeightPrice());
		model.setRatePercentage(soapModel.getRatePercentage());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceShippingFixedOptionRel> toModels(
		CommerceShippingFixedOptionRelSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceShippingFixedOptionRel> models =
			new ArrayList<CommerceShippingFixedOptionRel>(soapModels.length);

		for (CommerceShippingFixedOptionRelSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.shipping.engine.fixed.service.util.ServiceProps.
			get(
				"lock.expiration.time.com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel"));

	public CommerceShippingFixedOptionRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceShippingFixedOptionRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceShippingFixedOptionRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceShippingFixedOptionRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceShippingFixedOptionRel.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceShippingFixedOptionRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceShippingFixedOptionRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceShippingFixedOptionRel, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceShippingFixedOptionRel, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceShippingFixedOptionRel)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceShippingFixedOptionRel, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceShippingFixedOptionRel, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceShippingFixedOptionRel)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceShippingFixedOptionRel, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceShippingFixedOptionRel, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceShippingFixedOptionRel>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceShippingFixedOptionRel.class.getClassLoader(),
			CommerceShippingFixedOptionRel.class, ModelWrapper.class);

		try {
			Constructor<CommerceShippingFixedOptionRel> constructor =
				(Constructor<CommerceShippingFixedOptionRel>)
					proxyClass.getConstructor(InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map
		<String, Function<CommerceShippingFixedOptionRel, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<CommerceShippingFixedOptionRel, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceShippingFixedOptionRel, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String,
					 Function<CommerceShippingFixedOptionRel, Object>>();
		Map<String, BiConsumer<CommerceShippingFixedOptionRel, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceShippingFixedOptionRel, ?>>();

		attributeGetterFunctions.put(
			"commerceShippingFixedOptionRelId",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.
						getCommerceShippingFixedOptionRelId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceShippingFixedOptionRelId",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object commerceShippingFixedOptionRelIdObject) {

					commerceShippingFixedOptionRel.
						setCommerceShippingFixedOptionRelId(
							(Long)commerceShippingFixedOptionRelIdObject);
				}

			});
		attributeGetterFunctions.put(
			"groupId",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getGroupId();
				}

			});
		attributeSetterBiConsumers.put(
			"groupId",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object groupIdObject) {

					commerceShippingFixedOptionRel.setGroupId(
						(Long)groupIdObject);
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getCompanyId();
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object companyIdObject) {

					commerceShippingFixedOptionRel.setCompanyId(
						(Long)companyIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getUserId();
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object userIdObject) {

					commerceShippingFixedOptionRel.setUserId(
						(Long)userIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getUserName();
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object userNameObject) {

					commerceShippingFixedOptionRel.setUserName(
						(String)userNameObject);
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getCreateDate();
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object createDateObject) {

					commerceShippingFixedOptionRel.setCreateDate(
						(Date)createDateObject);
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getModifiedDate();
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object modifiedDateObject) {

					commerceShippingFixedOptionRel.setModifiedDate(
						(Date)modifiedDateObject);
				}

			});
		attributeGetterFunctions.put(
			"commerceShippingMethodId",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.
						getCommerceShippingMethodId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceShippingMethodId",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object commerceShippingMethodIdObject) {

					commerceShippingFixedOptionRel.setCommerceShippingMethodId(
						(Long)commerceShippingMethodIdObject);
				}

			});
		attributeGetterFunctions.put(
			"commerceShippingFixedOptionId",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.
						getCommerceShippingFixedOptionId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceShippingFixedOptionId",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object commerceShippingFixedOptionIdObject) {

					commerceShippingFixedOptionRel.
						setCommerceShippingFixedOptionId(
							(Long)commerceShippingFixedOptionIdObject);
				}

			});
		attributeGetterFunctions.put(
			"commerceInventoryWarehouseId",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.
						getCommerceInventoryWarehouseId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceInventoryWarehouseId",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object commerceInventoryWarehouseIdObject) {

					commerceShippingFixedOptionRel.
						setCommerceInventoryWarehouseId(
							(Long)commerceInventoryWarehouseIdObject);
				}

			});
		attributeGetterFunctions.put(
			"commerceCountryId",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.
						getCommerceCountryId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceCountryId",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object commerceCountryIdObject) {

					commerceShippingFixedOptionRel.setCommerceCountryId(
						(Long)commerceCountryIdObject);
				}

			});
		attributeGetterFunctions.put(
			"commerceRegionId",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getCommerceRegionId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceRegionId",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object commerceRegionIdObject) {

					commerceShippingFixedOptionRel.setCommerceRegionId(
						(Long)commerceRegionIdObject);
				}

			});
		attributeGetterFunctions.put(
			"zip",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getZip();
				}

			});
		attributeSetterBiConsumers.put(
			"zip",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object zipObject) {

					commerceShippingFixedOptionRel.setZip((String)zipObject);
				}

			});
		attributeGetterFunctions.put(
			"weightFrom",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getWeightFrom();
				}

			});
		attributeSetterBiConsumers.put(
			"weightFrom",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object weightFromObject) {

					commerceShippingFixedOptionRel.setWeightFrom(
						(Double)weightFromObject);
				}

			});
		attributeGetterFunctions.put(
			"weightTo",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getWeightTo();
				}

			});
		attributeSetterBiConsumers.put(
			"weightTo",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object weightToObject) {

					commerceShippingFixedOptionRel.setWeightTo(
						(Double)weightToObject);
				}

			});
		attributeGetterFunctions.put(
			"fixedPrice",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getFixedPrice();
				}

			});
		attributeSetterBiConsumers.put(
			"fixedPrice",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object fixedPriceObject) {

					commerceShippingFixedOptionRel.setFixedPrice(
						(BigDecimal)fixedPriceObject);
				}

			});
		attributeGetterFunctions.put(
			"rateUnitWeightPrice",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.
						getRateUnitWeightPrice();
				}

			});
		attributeSetterBiConsumers.put(
			"rateUnitWeightPrice",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object rateUnitWeightPriceObject) {

					commerceShippingFixedOptionRel.setRateUnitWeightPrice(
						(BigDecimal)rateUnitWeightPriceObject);
				}

			});
		attributeGetterFunctions.put(
			"ratePercentage",
			new Function<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public Object apply(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel) {

					return commerceShippingFixedOptionRel.getRatePercentage();
				}

			});
		attributeSetterBiConsumers.put(
			"ratePercentage",
			new BiConsumer<CommerceShippingFixedOptionRel, Object>() {

				@Override
				public void accept(
					CommerceShippingFixedOptionRel
						commerceShippingFixedOptionRel,
					Object ratePercentageObject) {

					commerceShippingFixedOptionRel.setRatePercentage(
						(Double)ratePercentageObject);
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getCommerceShippingFixedOptionRelId() {
		return _commerceShippingFixedOptionRelId;
	}

	@Override
	public void setCommerceShippingFixedOptionRelId(
		long commerceShippingFixedOptionRelId) {

		_commerceShippingFixedOptionRelId = commerceShippingFixedOptionRelId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_groupId = groupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceShippingMethodId() {
		return _commerceShippingMethodId;
	}

	@Override
	public void setCommerceShippingMethodId(long commerceShippingMethodId) {
		_columnBitmask |= COMMERCESHIPPINGMETHODID_COLUMN_BITMASK;

		if (!_setOriginalCommerceShippingMethodId) {
			_setOriginalCommerceShippingMethodId = true;

			_originalCommerceShippingMethodId = _commerceShippingMethodId;
		}

		_commerceShippingMethodId = commerceShippingMethodId;
	}

	public long getOriginalCommerceShippingMethodId() {
		return _originalCommerceShippingMethodId;
	}

	@JSON
	@Override
	public long getCommerceShippingFixedOptionId() {
		return _commerceShippingFixedOptionId;
	}

	@Override
	public void setCommerceShippingFixedOptionId(
		long commerceShippingFixedOptionId) {

		_columnBitmask |= COMMERCESHIPPINGFIXEDOPTIONID_COLUMN_BITMASK;

		if (!_setOriginalCommerceShippingFixedOptionId) {
			_setOriginalCommerceShippingFixedOptionId = true;

			_originalCommerceShippingFixedOptionId =
				_commerceShippingFixedOptionId;
		}

		_commerceShippingFixedOptionId = commerceShippingFixedOptionId;
	}

	public long getOriginalCommerceShippingFixedOptionId() {
		return _originalCommerceShippingFixedOptionId;
	}

	@JSON
	@Override
	public long getCommerceInventoryWarehouseId() {
		return _commerceInventoryWarehouseId;
	}

	@Override
	public void setCommerceInventoryWarehouseId(
		long commerceInventoryWarehouseId) {

		_commerceInventoryWarehouseId = commerceInventoryWarehouseId;
	}

	@JSON
	@Override
	public long getCommerceCountryId() {
		return _commerceCountryId;
	}

	@Override
	public void setCommerceCountryId(long commerceCountryId) {
		_commerceCountryId = commerceCountryId;
	}

	@JSON
	@Override
	public long getCommerceRegionId() {
		return _commerceRegionId;
	}

	@Override
	public void setCommerceRegionId(long commerceRegionId) {
		_commerceRegionId = commerceRegionId;
	}

	@JSON
	@Override
	public String getZip() {
		if (_zip == null) {
			return "";
		}
		else {
			return _zip;
		}
	}

	@Override
	public void setZip(String zip) {
		_zip = zip;
	}

	@JSON
	@Override
	public double getWeightFrom() {
		return _weightFrom;
	}

	@Override
	public void setWeightFrom(double weightFrom) {
		_weightFrom = weightFrom;
	}

	@JSON
	@Override
	public double getWeightTo() {
		return _weightTo;
	}

	@Override
	public void setWeightTo(double weightTo) {
		_weightTo = weightTo;
	}

	@JSON
	@Override
	public BigDecimal getFixedPrice() {
		return _fixedPrice;
	}

	@Override
	public void setFixedPrice(BigDecimal fixedPrice) {
		_fixedPrice = fixedPrice;
	}

	@JSON
	@Override
	public BigDecimal getRateUnitWeightPrice() {
		return _rateUnitWeightPrice;
	}

	@Override
	public void setRateUnitWeightPrice(BigDecimal rateUnitWeightPrice) {
		_rateUnitWeightPrice = rateUnitWeightPrice;
	}

	@JSON
	@Override
	public double getRatePercentage() {
		return _ratePercentage;
	}

	@Override
	public void setRatePercentage(double ratePercentage) {
		_ratePercentage = ratePercentage;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceShippingFixedOptionRel.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceShippingFixedOptionRel toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceShippingFixedOptionRel>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceShippingFixedOptionRelImpl commerceShippingFixedOptionRelImpl =
			new CommerceShippingFixedOptionRelImpl();

		commerceShippingFixedOptionRelImpl.setCommerceShippingFixedOptionRelId(
			getCommerceShippingFixedOptionRelId());
		commerceShippingFixedOptionRelImpl.setGroupId(getGroupId());
		commerceShippingFixedOptionRelImpl.setCompanyId(getCompanyId());
		commerceShippingFixedOptionRelImpl.setUserId(getUserId());
		commerceShippingFixedOptionRelImpl.setUserName(getUserName());
		commerceShippingFixedOptionRelImpl.setCreateDate(getCreateDate());
		commerceShippingFixedOptionRelImpl.setModifiedDate(getModifiedDate());
		commerceShippingFixedOptionRelImpl.setCommerceShippingMethodId(
			getCommerceShippingMethodId());
		commerceShippingFixedOptionRelImpl.setCommerceShippingFixedOptionId(
			getCommerceShippingFixedOptionId());
		commerceShippingFixedOptionRelImpl.setCommerceInventoryWarehouseId(
			getCommerceInventoryWarehouseId());
		commerceShippingFixedOptionRelImpl.setCommerceCountryId(
			getCommerceCountryId());
		commerceShippingFixedOptionRelImpl.setCommerceRegionId(
			getCommerceRegionId());
		commerceShippingFixedOptionRelImpl.setZip(getZip());
		commerceShippingFixedOptionRelImpl.setWeightFrom(getWeightFrom());
		commerceShippingFixedOptionRelImpl.setWeightTo(getWeightTo());
		commerceShippingFixedOptionRelImpl.setFixedPrice(getFixedPrice());
		commerceShippingFixedOptionRelImpl.setRateUnitWeightPrice(
			getRateUnitWeightPrice());
		commerceShippingFixedOptionRelImpl.setRatePercentage(
			getRatePercentage());

		commerceShippingFixedOptionRelImpl.resetOriginalValues();

		return commerceShippingFixedOptionRelImpl;
	}

	@Override
	public int compareTo(
		CommerceShippingFixedOptionRel commerceShippingFixedOptionRel) {

		int value = 0;

		if (getCommerceCountryId() <
				commerceShippingFixedOptionRel.getCommerceCountryId()) {

			value = -1;
		}
		else if (getCommerceCountryId() >
					commerceShippingFixedOptionRel.getCommerceCountryId()) {

			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceShippingFixedOptionRel)) {
			return false;
		}

		CommerceShippingFixedOptionRel commerceShippingFixedOptionRel =
			(CommerceShippingFixedOptionRel)object;

		long primaryKey = commerceShippingFixedOptionRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_setModifiedDate = false;
		_originalCommerceShippingMethodId = _commerceShippingMethodId;

		_setOriginalCommerceShippingMethodId = false;

		_originalCommerceShippingFixedOptionId = _commerceShippingFixedOptionId;

		_setOriginalCommerceShippingFixedOptionId = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceShippingFixedOptionRel> toCacheModel() {
		CommerceShippingFixedOptionRelCacheModel
			commerceShippingFixedOptionRelCacheModel =
				new CommerceShippingFixedOptionRelCacheModel();

		commerceShippingFixedOptionRelCacheModel.
			commerceShippingFixedOptionRelId =
				getCommerceShippingFixedOptionRelId();

		commerceShippingFixedOptionRelCacheModel.groupId = getGroupId();

		commerceShippingFixedOptionRelCacheModel.companyId = getCompanyId();

		commerceShippingFixedOptionRelCacheModel.userId = getUserId();

		commerceShippingFixedOptionRelCacheModel.userName = getUserName();

		String userName = commerceShippingFixedOptionRelCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceShippingFixedOptionRelCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceShippingFixedOptionRelCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceShippingFixedOptionRelCacheModel.createDate =
				Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceShippingFixedOptionRelCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceShippingFixedOptionRelCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		commerceShippingFixedOptionRelCacheModel.commerceShippingMethodId =
			getCommerceShippingMethodId();

		commerceShippingFixedOptionRelCacheModel.commerceShippingFixedOptionId =
			getCommerceShippingFixedOptionId();

		commerceShippingFixedOptionRelCacheModel.commerceInventoryWarehouseId =
			getCommerceInventoryWarehouseId();

		commerceShippingFixedOptionRelCacheModel.commerceCountryId =
			getCommerceCountryId();

		commerceShippingFixedOptionRelCacheModel.commerceRegionId =
			getCommerceRegionId();

		commerceShippingFixedOptionRelCacheModel.zip = getZip();

		String zip = commerceShippingFixedOptionRelCacheModel.zip;

		if ((zip != null) && (zip.length() == 0)) {
			commerceShippingFixedOptionRelCacheModel.zip = null;
		}

		commerceShippingFixedOptionRelCacheModel.weightFrom = getWeightFrom();

		commerceShippingFixedOptionRelCacheModel.weightTo = getWeightTo();

		commerceShippingFixedOptionRelCacheModel.fixedPrice = getFixedPrice();

		commerceShippingFixedOptionRelCacheModel.rateUnitWeightPrice =
			getRateUnitWeightPrice();

		commerceShippingFixedOptionRelCacheModel.ratePercentage =
			getRatePercentage();

		return commerceShippingFixedOptionRelCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceShippingFixedOptionRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			4 * attributeGetterFunctions.size() + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceShippingFixedOptionRel, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceShippingFixedOptionRel, Object>
				attributeGetterFunction = entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(
				attributeGetterFunction.apply(
					(CommerceShippingFixedOptionRel)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceShippingFixedOptionRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			5 * attributeGetterFunctions.size() + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceShippingFixedOptionRel, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceShippingFixedOptionRel, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(CommerceShippingFixedOptionRel)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceShippingFixedOptionRel>
				_escapedModelProxyProviderFunction =
					_getProxyProviderFunction();

	}

	private long _commerceShippingFixedOptionRelId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceShippingMethodId;
	private long _originalCommerceShippingMethodId;
	private boolean _setOriginalCommerceShippingMethodId;
	private long _commerceShippingFixedOptionId;
	private long _originalCommerceShippingFixedOptionId;
	private boolean _setOriginalCommerceShippingFixedOptionId;
	private long _commerceInventoryWarehouseId;
	private long _commerceCountryId;
	private long _commerceRegionId;
	private String _zip;
	private double _weightFrom;
	private double _weightTo;
	private BigDecimal _fixedPrice;
	private BigDecimal _rateUnitWeightPrice;
	private double _ratePercentage;
	private long _columnBitmask;
	private CommerceShippingFixedOptionRel _escapedModel;

}