/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.shipping.engine.fixed.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRelModel;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRelSoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.math.BigDecimal;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceShippingFixedOptionRel service. Represents a row in the &quot;CShippingFixedOptionRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceShippingFixedOptionRelModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceShippingFixedOptionRelImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShippingFixedOptionRelImpl
 * @see CommerceShippingFixedOptionRel
 * @see CommerceShippingFixedOptionRelModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceShippingFixedOptionRelModelImpl extends BaseModelImpl<CommerceShippingFixedOptionRel>
	implements CommerceShippingFixedOptionRelModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce shipping fixed option rel model instance should use the {@link CommerceShippingFixedOptionRel} interface instead.
	 */
	public static final String TABLE_NAME = "CShippingFixedOptionRel";
	public static final Object[][] TABLE_COLUMNS = {
			{ "CShippingFixedOptionRelId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "commerceShippingMethodId", Types.BIGINT },
			{ "commerceShippingFixedOptionId", Types.BIGINT },
			{ "commerceWarehouseId", Types.BIGINT },
			{ "commerceCountryId", Types.BIGINT },
			{ "commerceRegionId", Types.BIGINT },
			{ "zip", Types.VARCHAR },
			{ "weightFrom", Types.DOUBLE },
			{ "weightTo", Types.DOUBLE },
			{ "fixedPrice", Types.DECIMAL },
			{ "rateUnitWeightPrice", Types.DECIMAL },
			{ "ratePercentage", Types.DOUBLE }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("CShippingFixedOptionRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceShippingMethodId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceShippingFixedOptionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceWarehouseId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceCountryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceRegionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("zip", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("weightFrom", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("weightTo", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("fixedPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("rateUnitWeightPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("ratePercentage", Types.DOUBLE);
	}

	public static final String TABLE_SQL_CREATE = "create table CShippingFixedOptionRel (CShippingFixedOptionRelId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceShippingMethodId LONG,commerceShippingFixedOptionId LONG,commerceWarehouseId LONG,commerceCountryId LONG,commerceRegionId LONG,zip VARCHAR(75) null,weightFrom DOUBLE,weightTo DOUBLE,fixedPrice DECIMAL(30, 16) null,rateUnitWeightPrice DECIMAL(30, 16) null,ratePercentage DOUBLE)";
	public static final String TABLE_SQL_DROP = "drop table CShippingFixedOptionRel";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceShippingFixedOptionRel.commerceCountryId ASC";
	public static final String ORDER_BY_SQL = " ORDER BY CShippingFixedOptionRel.commerceCountryId ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.shipping.engine.fixed.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.shipping.engine.fixed.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.shipping.engine.fixed.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel"),
			true);
	public static final long COMMERCESHIPPINGFIXEDOPTIONID_COLUMN_BITMASK = 1L;
	public static final long COMMERCESHIPPINGMETHODID_COLUMN_BITMASK = 2L;
	public static final long COMMERCECOUNTRYID_COLUMN_BITMASK = 4L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceShippingFixedOptionRel toModel(
		CommerceShippingFixedOptionRelSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceShippingFixedOptionRel model = new CommerceShippingFixedOptionRelImpl();

		model.setCommerceShippingFixedOptionRelId(soapModel.getCommerceShippingFixedOptionRelId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceShippingMethodId(soapModel.getCommerceShippingMethodId());
		model.setCommerceShippingFixedOptionId(soapModel.getCommerceShippingFixedOptionId());
		model.setCommerceWarehouseId(soapModel.getCommerceWarehouseId());
		model.setCommerceCountryId(soapModel.getCommerceCountryId());
		model.setCommerceRegionId(soapModel.getCommerceRegionId());
		model.setZip(soapModel.getZip());
		model.setWeightFrom(soapModel.getWeightFrom());
		model.setWeightTo(soapModel.getWeightTo());
		model.setFixedPrice(soapModel.getFixedPrice());
		model.setRateUnitWeightPrice(soapModel.getRateUnitWeightPrice());
		model.setRatePercentage(soapModel.getRatePercentage());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceShippingFixedOptionRel> toModels(
		CommerceShippingFixedOptionRelSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceShippingFixedOptionRel> models = new ArrayList<CommerceShippingFixedOptionRel>(soapModels.length);

		for (CommerceShippingFixedOptionRelSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.shipping.engine.fixed.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel"));

	public CommerceShippingFixedOptionRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceShippingFixedOptionRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceShippingFixedOptionRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceShippingFixedOptionRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceShippingFixedOptionRel.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceShippingFixedOptionRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceShippingFixedOptionRelId",
			getCommerceShippingFixedOptionRelId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("commerceShippingMethodId", getCommerceShippingMethodId());
		attributes.put("commerceShippingFixedOptionId",
			getCommerceShippingFixedOptionId());
		attributes.put("commerceWarehouseId", getCommerceWarehouseId());
		attributes.put("commerceCountryId", getCommerceCountryId());
		attributes.put("commerceRegionId", getCommerceRegionId());
		attributes.put("zip", getZip());
		attributes.put("weightFrom", getWeightFrom());
		attributes.put("weightTo", getWeightTo());
		attributes.put("fixedPrice", getFixedPrice());
		attributes.put("rateUnitWeightPrice", getRateUnitWeightPrice());
		attributes.put("ratePercentage", getRatePercentage());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceShippingFixedOptionRelId = (Long)attributes.get(
				"commerceShippingFixedOptionRelId");

		if (commerceShippingFixedOptionRelId != null) {
			setCommerceShippingFixedOptionRelId(commerceShippingFixedOptionRelId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long commerceShippingMethodId = (Long)attributes.get(
				"commerceShippingMethodId");

		if (commerceShippingMethodId != null) {
			setCommerceShippingMethodId(commerceShippingMethodId);
		}

		Long commerceShippingFixedOptionId = (Long)attributes.get(
				"commerceShippingFixedOptionId");

		if (commerceShippingFixedOptionId != null) {
			setCommerceShippingFixedOptionId(commerceShippingFixedOptionId);
		}

		Long commerceWarehouseId = (Long)attributes.get("commerceWarehouseId");

		if (commerceWarehouseId != null) {
			setCommerceWarehouseId(commerceWarehouseId);
		}

		Long commerceCountryId = (Long)attributes.get("commerceCountryId");

		if (commerceCountryId != null) {
			setCommerceCountryId(commerceCountryId);
		}

		Long commerceRegionId = (Long)attributes.get("commerceRegionId");

		if (commerceRegionId != null) {
			setCommerceRegionId(commerceRegionId);
		}

		String zip = (String)attributes.get("zip");

		if (zip != null) {
			setZip(zip);
		}

		Double weightFrom = (Double)attributes.get("weightFrom");

		if (weightFrom != null) {
			setWeightFrom(weightFrom);
		}

		Double weightTo = (Double)attributes.get("weightTo");

		if (weightTo != null) {
			setWeightTo(weightTo);
		}

		BigDecimal fixedPrice = (BigDecimal)attributes.get("fixedPrice");

		if (fixedPrice != null) {
			setFixedPrice(fixedPrice);
		}

		BigDecimal rateUnitWeightPrice = (BigDecimal)attributes.get(
				"rateUnitWeightPrice");

		if (rateUnitWeightPrice != null) {
			setRateUnitWeightPrice(rateUnitWeightPrice);
		}

		Double ratePercentage = (Double)attributes.get("ratePercentage");

		if (ratePercentage != null) {
			setRatePercentage(ratePercentage);
		}
	}

	@JSON
	@Override
	public long getCommerceShippingFixedOptionRelId() {
		return _commerceShippingFixedOptionRelId;
	}

	@Override
	public void setCommerceShippingFixedOptionRelId(
		long commerceShippingFixedOptionRelId) {
		_commerceShippingFixedOptionRelId = commerceShippingFixedOptionRelId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_groupId = groupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceShippingMethodId() {
		return _commerceShippingMethodId;
	}

	@Override
	public void setCommerceShippingMethodId(long commerceShippingMethodId) {
		_columnBitmask |= COMMERCESHIPPINGMETHODID_COLUMN_BITMASK;

		if (!_setOriginalCommerceShippingMethodId) {
			_setOriginalCommerceShippingMethodId = true;

			_originalCommerceShippingMethodId = _commerceShippingMethodId;
		}

		_commerceShippingMethodId = commerceShippingMethodId;
	}

	public long getOriginalCommerceShippingMethodId() {
		return _originalCommerceShippingMethodId;
	}

	@JSON
	@Override
	public long getCommerceShippingFixedOptionId() {
		return _commerceShippingFixedOptionId;
	}

	@Override
	public void setCommerceShippingFixedOptionId(
		long commerceShippingFixedOptionId) {
		_columnBitmask |= COMMERCESHIPPINGFIXEDOPTIONID_COLUMN_BITMASK;

		if (!_setOriginalCommerceShippingFixedOptionId) {
			_setOriginalCommerceShippingFixedOptionId = true;

			_originalCommerceShippingFixedOptionId = _commerceShippingFixedOptionId;
		}

		_commerceShippingFixedOptionId = commerceShippingFixedOptionId;
	}

	public long getOriginalCommerceShippingFixedOptionId() {
		return _originalCommerceShippingFixedOptionId;
	}

	@JSON
	@Override
	public long getCommerceWarehouseId() {
		return _commerceWarehouseId;
	}

	@Override
	public void setCommerceWarehouseId(long commerceWarehouseId) {
		_commerceWarehouseId = commerceWarehouseId;
	}

	@JSON
	@Override
	public long getCommerceCountryId() {
		return _commerceCountryId;
	}

	@Override
	public void setCommerceCountryId(long commerceCountryId) {
		_columnBitmask = -1L;

		_commerceCountryId = commerceCountryId;
	}

	@JSON
	@Override
	public long getCommerceRegionId() {
		return _commerceRegionId;
	}

	@Override
	public void setCommerceRegionId(long commerceRegionId) {
		_commerceRegionId = commerceRegionId;
	}

	@JSON
	@Override
	public String getZip() {
		if (_zip == null) {
			return "";
		}
		else {
			return _zip;
		}
	}

	@Override
	public void setZip(String zip) {
		_zip = zip;
	}

	@JSON
	@Override
	public double getWeightFrom() {
		return _weightFrom;
	}

	@Override
	public void setWeightFrom(double weightFrom) {
		_weightFrom = weightFrom;
	}

	@JSON
	@Override
	public double getWeightTo() {
		return _weightTo;
	}

	@Override
	public void setWeightTo(double weightTo) {
		_weightTo = weightTo;
	}

	@JSON
	@Override
	public BigDecimal getFixedPrice() {
		return _fixedPrice;
	}

	@Override
	public void setFixedPrice(BigDecimal fixedPrice) {
		_fixedPrice = fixedPrice;
	}

	@JSON
	@Override
	public BigDecimal getRateUnitWeightPrice() {
		return _rateUnitWeightPrice;
	}

	@Override
	public void setRateUnitWeightPrice(BigDecimal rateUnitWeightPrice) {
		_rateUnitWeightPrice = rateUnitWeightPrice;
	}

	@JSON
	@Override
	public double getRatePercentage() {
		return _ratePercentage;
	}

	@Override
	public void setRatePercentage(double ratePercentage) {
		_ratePercentage = ratePercentage;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceShippingFixedOptionRel.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceShippingFixedOptionRel toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceShippingFixedOptionRel)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceShippingFixedOptionRelImpl commerceShippingFixedOptionRelImpl = new CommerceShippingFixedOptionRelImpl();

		commerceShippingFixedOptionRelImpl.setCommerceShippingFixedOptionRelId(getCommerceShippingFixedOptionRelId());
		commerceShippingFixedOptionRelImpl.setGroupId(getGroupId());
		commerceShippingFixedOptionRelImpl.setCompanyId(getCompanyId());
		commerceShippingFixedOptionRelImpl.setUserId(getUserId());
		commerceShippingFixedOptionRelImpl.setUserName(getUserName());
		commerceShippingFixedOptionRelImpl.setCreateDate(getCreateDate());
		commerceShippingFixedOptionRelImpl.setModifiedDate(getModifiedDate());
		commerceShippingFixedOptionRelImpl.setCommerceShippingMethodId(getCommerceShippingMethodId());
		commerceShippingFixedOptionRelImpl.setCommerceShippingFixedOptionId(getCommerceShippingFixedOptionId());
		commerceShippingFixedOptionRelImpl.setCommerceWarehouseId(getCommerceWarehouseId());
		commerceShippingFixedOptionRelImpl.setCommerceCountryId(getCommerceCountryId());
		commerceShippingFixedOptionRelImpl.setCommerceRegionId(getCommerceRegionId());
		commerceShippingFixedOptionRelImpl.setZip(getZip());
		commerceShippingFixedOptionRelImpl.setWeightFrom(getWeightFrom());
		commerceShippingFixedOptionRelImpl.setWeightTo(getWeightTo());
		commerceShippingFixedOptionRelImpl.setFixedPrice(getFixedPrice());
		commerceShippingFixedOptionRelImpl.setRateUnitWeightPrice(getRateUnitWeightPrice());
		commerceShippingFixedOptionRelImpl.setRatePercentage(getRatePercentage());

		commerceShippingFixedOptionRelImpl.resetOriginalValues();

		return commerceShippingFixedOptionRelImpl;
	}

	@Override
	public int compareTo(
		CommerceShippingFixedOptionRel commerceShippingFixedOptionRel) {
		int value = 0;

		if (getCommerceCountryId() < commerceShippingFixedOptionRel.getCommerceCountryId()) {
			value = -1;
		}
		else if (getCommerceCountryId() > commerceShippingFixedOptionRel.getCommerceCountryId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceShippingFixedOptionRel)) {
			return false;
		}

		CommerceShippingFixedOptionRel commerceShippingFixedOptionRel = (CommerceShippingFixedOptionRel)obj;

		long primaryKey = commerceShippingFixedOptionRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceShippingFixedOptionRelModelImpl commerceShippingFixedOptionRelModelImpl =
			this;

		commerceShippingFixedOptionRelModelImpl._setModifiedDate = false;

		commerceShippingFixedOptionRelModelImpl._originalCommerceShippingMethodId = commerceShippingFixedOptionRelModelImpl._commerceShippingMethodId;

		commerceShippingFixedOptionRelModelImpl._setOriginalCommerceShippingMethodId = false;

		commerceShippingFixedOptionRelModelImpl._originalCommerceShippingFixedOptionId = commerceShippingFixedOptionRelModelImpl._commerceShippingFixedOptionId;

		commerceShippingFixedOptionRelModelImpl._setOriginalCommerceShippingFixedOptionId = false;

		commerceShippingFixedOptionRelModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceShippingFixedOptionRel> toCacheModel() {
		CommerceShippingFixedOptionRelCacheModel commerceShippingFixedOptionRelCacheModel =
			new CommerceShippingFixedOptionRelCacheModel();

		commerceShippingFixedOptionRelCacheModel.commerceShippingFixedOptionRelId = getCommerceShippingFixedOptionRelId();

		commerceShippingFixedOptionRelCacheModel.groupId = getGroupId();

		commerceShippingFixedOptionRelCacheModel.companyId = getCompanyId();

		commerceShippingFixedOptionRelCacheModel.userId = getUserId();

		commerceShippingFixedOptionRelCacheModel.userName = getUserName();

		String userName = commerceShippingFixedOptionRelCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceShippingFixedOptionRelCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceShippingFixedOptionRelCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceShippingFixedOptionRelCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceShippingFixedOptionRelCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceShippingFixedOptionRelCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceShippingFixedOptionRelCacheModel.commerceShippingMethodId = getCommerceShippingMethodId();

		commerceShippingFixedOptionRelCacheModel.commerceShippingFixedOptionId = getCommerceShippingFixedOptionId();

		commerceShippingFixedOptionRelCacheModel.commerceWarehouseId = getCommerceWarehouseId();

		commerceShippingFixedOptionRelCacheModel.commerceCountryId = getCommerceCountryId();

		commerceShippingFixedOptionRelCacheModel.commerceRegionId = getCommerceRegionId();

		commerceShippingFixedOptionRelCacheModel.zip = getZip();

		String zip = commerceShippingFixedOptionRelCacheModel.zip;

		if ((zip != null) && (zip.length() == 0)) {
			commerceShippingFixedOptionRelCacheModel.zip = null;
		}

		commerceShippingFixedOptionRelCacheModel.weightFrom = getWeightFrom();

		commerceShippingFixedOptionRelCacheModel.weightTo = getWeightTo();

		commerceShippingFixedOptionRelCacheModel.fixedPrice = getFixedPrice();

		commerceShippingFixedOptionRelCacheModel.rateUnitWeightPrice = getRateUnitWeightPrice();

		commerceShippingFixedOptionRelCacheModel.ratePercentage = getRatePercentage();

		return commerceShippingFixedOptionRelCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(37);

		sb.append("{commerceShippingFixedOptionRelId=");
		sb.append(getCommerceShippingFixedOptionRelId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", commerceShippingMethodId=");
		sb.append(getCommerceShippingMethodId());
		sb.append(", commerceShippingFixedOptionId=");
		sb.append(getCommerceShippingFixedOptionId());
		sb.append(", commerceWarehouseId=");
		sb.append(getCommerceWarehouseId());
		sb.append(", commerceCountryId=");
		sb.append(getCommerceCountryId());
		sb.append(", commerceRegionId=");
		sb.append(getCommerceRegionId());
		sb.append(", zip=");
		sb.append(getZip());
		sb.append(", weightFrom=");
		sb.append(getWeightFrom());
		sb.append(", weightTo=");
		sb.append(getWeightTo());
		sb.append(", fixedPrice=");
		sb.append(getFixedPrice());
		sb.append(", rateUnitWeightPrice=");
		sb.append(getRateUnitWeightPrice());
		sb.append(", ratePercentage=");
		sb.append(getRatePercentage());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(58);

		sb.append("<model><model-name>");
		sb.append(
			"com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionRel");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>commerceShippingFixedOptionRelId</column-name><column-value><![CDATA[");
		sb.append(getCommerceShippingFixedOptionRelId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceShippingMethodId</column-name><column-value><![CDATA[");
		sb.append(getCommerceShippingMethodId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceShippingFixedOptionId</column-name><column-value><![CDATA[");
		sb.append(getCommerceShippingFixedOptionId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceWarehouseId</column-name><column-value><![CDATA[");
		sb.append(getCommerceWarehouseId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceCountryId</column-name><column-value><![CDATA[");
		sb.append(getCommerceCountryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceRegionId</column-name><column-value><![CDATA[");
		sb.append(getCommerceRegionId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>zip</column-name><column-value><![CDATA[");
		sb.append(getZip());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>weightFrom</column-name><column-value><![CDATA[");
		sb.append(getWeightFrom());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>weightTo</column-name><column-value><![CDATA[");
		sb.append(getWeightTo());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>fixedPrice</column-name><column-value><![CDATA[");
		sb.append(getFixedPrice());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>rateUnitWeightPrice</column-name><column-value><![CDATA[");
		sb.append(getRateUnitWeightPrice());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ratePercentage</column-name><column-value><![CDATA[");
		sb.append(getRatePercentage());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceShippingFixedOptionRel.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceShippingFixedOptionRel.class, ModelWrapper.class
		};
	private long _commerceShippingFixedOptionRelId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceShippingMethodId;
	private long _originalCommerceShippingMethodId;
	private boolean _setOriginalCommerceShippingMethodId;
	private long _commerceShippingFixedOptionId;
	private long _originalCommerceShippingFixedOptionId;
	private boolean _setOriginalCommerceShippingFixedOptionId;
	private long _commerceWarehouseId;
	private long _commerceCountryId;
	private long _commerceRegionId;
	private String _zip;
	private double _weightFrom;
	private double _weightTo;
	private BigDecimal _fixedPrice;
	private BigDecimal _rateUnitWeightPrice;
	private double _ratePercentage;
	private long _columnBitmask;
	private CommerceShippingFixedOptionRel _escapedModel;
}