/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.util;

import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.commerce.tax.CommerceTaxValue;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;

public class CommercePriceConverterUtil {
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final int _SCALE = 10;

    public static CommerceDiscountValue getConvertedCommerceDiscountValue(CommerceDiscountValue commerceDiscountValue, BigDecimal initialPrice, BigDecimal discountedPrice, CommerceMoneyFactory commerceMoneyFactory, RoundingMode roundingMode) {
        if (commerceDiscountValue == null) {
            return null;
        }
        CommerceMoney currentDiscountAmount = commerceDiscountValue.getDiscountAmount();
        BigDecimal discountAmount = initialPrice.subtract(discountedPrice);
        CommerceMoney convertedDiscountAmount = commerceMoneyFactory.create(currentDiscountAmount.getCommerceCurrency(), discountAmount);
        BigDecimal discountPercentage = _ONE_HUNDRED;
        if (discountedPrice.compareTo(initialPrice) != 0) {
            discountPercentage = CommercePriceConverterUtil._getDiscountPercentage(discountedPrice, initialPrice, roundingMode);
        }
        return new CommerceDiscountValue(commerceDiscountValue.getId(), convertedDiscountAmount, discountPercentage, CommercePriceConverterUtil._getPercentages(commerceDiscountValue.getDiscountPercentage(), discountPercentage, commerceDiscountValue.getPercentages(), roundingMode));
    }

    public static BigDecimal getConvertedPrice(long commerceChannelGroupId, long cpInstanceId, long commerceBillingAddressId, long commerceShippingAddressId, BigDecimal price, boolean includeTax, CommerceTaxCalculation commerceTaxCalculation) throws PortalException {
        List commerceTaxValues = commerceTaxCalculation.getCommerceTaxValues(commerceChannelGroupId, cpInstanceId, commerceBillingAddressId, commerceShippingAddressId, price, includeTax);
        if (commerceTaxValues == null || commerceTaxValues.isEmpty()) {
            return price;
        }
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (CommerceTaxValue commerceTaxValue : commerceTaxValues) {
            taxAmount = taxAmount.add(commerceTaxValue.getAmount());
        }
        if (includeTax) {
            return price.subtract(taxAmount);
        }
        return price.add(taxAmount);
    }

    private static BigDecimal _getDiscountPercentage(BigDecimal discountedAmount, BigDecimal amount, RoundingMode roundingMode) {
        double actualPrice = discountedAmount.doubleValue();
        double originalPrice = amount.doubleValue();
        double percentage = actualPrice / originalPrice;
        BigDecimal discountPercentage = new BigDecimal(percentage);
        discountPercentage = discountPercentage.multiply(_ONE_HUNDRED);
        MathContext mathContext = new MathContext(discountPercentage.precision(), roundingMode);
        return _ONE_HUNDRED.subtract(discountPercentage, mathContext);
    }

    private static BigDecimal[] _getPercentages(BigDecimal currentPercentage, BigDecimal percentage, BigDecimal[] percentages, RoundingMode roundingMode) {
        if (currentPercentage == null || currentPercentage.compareTo(BigDecimal.ZERO) == 0 || percentage == null || percentage.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        }
        BigDecimal percentageRatio = percentage.divide(currentPercentage, 10, roundingMode);
        for (int i = 0; i < percentages.length; ++i) {
            if (percentages[i] == null || percentages[i].compareTo(BigDecimal.ZERO) == 0) continue;
            percentages[i] = percentages[i].multiply(percentageRatio);
        }
        return percentages;
    }
}

