/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"commerce.order.status.key=10", "commerce.order.status.priority:Integer=50"}, service={CommerceOrderStatus.class})
public class ProcessingCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 10;
    public static final int PRIORITY = 50;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderService _commerceOrderService;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId) throws PortalException {
        commerceOrder.setOrderStatus(10);
        return this._commerceOrderService.updateCommerceOrder(commerceOrder);
    }

    public int getKey() {
        return 10;
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)CommerceOrderConstants.getOrderStatusLabel((int)10));
    }

    public int getPriority() {
        return 50;
    }

    public boolean isComplete(CommerceOrder commerceOrder) {
        return !commerceOrder.isOpen() && commerceOrder.isApproved() && commerceOrder.getOrderStatus() != 1;
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        return commerceOrder.getOrderStatus() == 1 || commerceOrder.getOrderStatus() == 20;
    }
}

